/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.windowsapi.metadata;

import java.util.List;
import java.util.UUID;
import java.util.stream.Stream;
import net.codecrete.windowsapi.metadata.Method;
import net.codecrete.windowsapi.metadata.Namespace;
import net.codecrete.windowsapi.metadata.Type;

public final class ComInterface
extends Type {
    private final UUID iid;
    private List<Method> methods;
    private ComInterface implementedInterface;

    public ComInterface(String name, Namespace namespace, int typeDefIndex, UUID iid) {
        super(name, namespace, typeDefIndex);
        this.iid = iid;
    }

    public UUID getIid() {
        return this.iid;
    }

    public ComInterface implementedInterface() {
        return this.implementedInterface;
    }

    public void setImplementedInterfaces(List<ComInterface> implementedInterfaces) {
        assert (implementedInterfaces.size() <= 1);
        this.implementedInterface = !implementedInterfaces.isEmpty() ? implementedInterfaces.getFirst() : null;
    }

    public List<Method> methods() {
        return this.methods;
    }

    public void setMethods(List<Method> methods) {
        this.methods = methods;
    }

    @Override
    public Stream<Type> referencedTypes() {
        return Stream.concat(this.methods.stream().flatMap(Method::referencedTypes), this.implementedInterface != null ? Stream.of(this.implementedInterface) : Stream.empty());
    }
}

