/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.windowsapi.writer;

import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.function.Function;
import net.codecrete.windowsapi.events.Event;
import net.codecrete.windowsapi.events.EventListener;
import net.codecrete.windowsapi.metadata.Metadata;

class GenerationContext {
    final Metadata metadata;
    protected Function<Path, PrintWriter> writerFactory;
    protected final EventListener eventListener;
    protected String basePackage = "";

    GenerationContext(Metadata metadata, EventListener eventListener) {
        this.metadata = metadata;
        this.eventListener = eventListener;
    }

    Metadata metadata() {
        return this.metadata;
    }

    void notify(Event event) {
        this.eventListener.onEvent(event);
    }

    String basePackage() {
        return this.basePackage;
    }

    void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    void setWriterFactory(Function<Path, PrintWriter> writerFactory) {
        this.writerFactory = writerFactory;
    }

    PrintWriter createWriter(Path path) {
        return this.writerFactory.apply(path);
    }
}

