/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.windowsapi.writer;

import net.codecrete.windowsapi.metadata.Method;
import net.codecrete.windowsapi.metadata.Parameter;
import net.codecrete.windowsapi.metadata.Type;
import net.codecrete.windowsapi.writer.GenerationContext;
import net.codecrete.windowsapi.writer.JavaCodeWriter;

class FunctionCodeWriterBase<T extends Type>
extends JavaCodeWriter<T> {
    protected FunctionCodeWriterBase(GenerationContext generationContext) {
        super(generationContext);
    }

    protected void writeFunctionDescriptor(Method method, String thisParameter) {
        this.writer.print("FunctionDescriptor.");
        if (method.hasReturnType()) {
            this.writer.print("of(");
            this.writer.print(this.getLayoutName(method.returnType(), null));
        } else {
            this.writer.print("ofVoid(");
        }
        if (thisParameter != null) {
            if (method.hasReturnType()) {
                this.writer.print(", ");
            }
            this.writer.print(thisParameter);
        }
        Parameter[] parameters = method.parameters();
        for (int i = 0; i < parameters.length; ++i) {
            this.writer.print(i > 0 || thisParameter != null || method.hasReturnType() ? ", " : "");
            this.writer.print(this.getLayoutName(parameters[i].type(), null));
        }
        this.writer.print(")");
    }

    protected void writeFunctionSignature(Method function, String functionName) {
        this.writeFunctionSignatureIntro(function, functionName);
        this.writeFunctionSignatureParameters(function);
    }

    protected void writeFunctionSignatureIntro(Method function, String functionName) {
        this.writer.printf("%s %s(", function.hasReturnType() ? FunctionCodeWriterBase.getJavaType(function.returnType()) : "void", functionName);
    }

    protected void writeFunctionSignatureParameters(Method function) {
        Parameter[] parameters = function.parameters();
        if (function.supportsLastError()) {
            this.writer.print("MemorySegment lastErrorState");
        }
        for (int i = 0; i < parameters.length; ++i) {
            this.writer.printf("%s%s %s", i > 0 || function.supportsLastError() ? ", " : "", FunctionCodeWriterBase.getJavaType(parameters[i].type()), FunctionCodeWriterBase.getJavaSafeName(parameters[i].name()));
        }
        this.writer.print(")");
    }

    protected void writeInvoke(Method function, String invoke, int indenting) {
        String indent = FunctionCodeWriterBase.getIndent(indenting);
        String returnWithCast = function.hasReturnType() ? String.format("return (%s) ", FunctionCodeWriterBase.getJavaType(function.returnType())) : "";
        this.writer.printf("%1$stry {\n%1$s    %2$s%3$s", indent, returnWithCast, invoke);
        boolean supportsLastError = function.supportsLastError();
        if (supportsLastError) {
            this.writer.print("lastErrorState");
        }
        Parameter[] parameters = function.parameters();
        for (int i = 0; i < parameters.length; ++i) {
            this.writer.print(i > 0 || supportsLastError ? ", " : "");
            this.writer.print(FunctionCodeWriterBase.getJavaSafeName(parameters[i].name()));
        }
        this.writer.println(");");
        this.writer.printf("%1$s} catch (Throwable ex) {\n%1$s    throw new RuntimeException(ex);\n%1$s}\n", indent);
    }
}

