/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.windowsapi.writer;

import java.util.List;
import net.codecrete.windowsapi.metadata.EnumType;
import net.codecrete.windowsapi.metadata.Member;
import net.codecrete.windowsapi.writer.GenerationContext;
import net.codecrete.windowsapi.writer.JavaCodeWriter;

class EnumCodeWriter
extends JavaCodeWriter<EnumType> {
    EnumCodeWriter(GenerationContext generationContext) {
        super(generationContext);
    }

    void writeEnum(EnumType enumeration) {
        String className = EnumCodeWriter.toJavaClassName(enumeration.name());
        this.withFile(enumeration.namespace(), enumeration, className, this::writeEnumValues);
    }

    private void writeEnumValues() {
        String javaType = EnumCodeWriter.getPrimitiveJavaType(((EnumType)this.type).baseType());
        List<Member> fields = ((EnumType)this.type).members();
        String prefix = this.className + "_";
        boolean haveCommonPrefix = fields.stream().allMatch(field -> field.name().startsWith(prefix));
        this.writer.printf("package %s ;%n%n", this.packageName);
        this.writeEnumComment(haveCommonPrefix);
        this.writer.printf("public class %1$s {\n", this.className);
        for (Member field2 : fields) {
            Object name;
            Object object = name = haveCommonPrefix ? field2.name().substring(prefix.length()) : field2.name();
            if (Character.isDigit(((String)name).charAt(0))) {
                name = "_" + (String)name;
            }
            String constantValue = EnumCodeWriter.getJavaIntegerConstant(javaType, field2.value());
            this.writeComment("Enumeration value {@code %s}", field2.name());
            this.writer.printf("    public static final %s %s = %s;\n\n", javaType, name, constantValue);
        }
        this.writer.printf("\n    private %s() {}\n}\n", this.className);
    }

    void writeEnumComment(boolean haveCommonPrefix) {
        this.writer.printf("/**\n * {@code %1$s} %2$s\n", ((EnumType)this.type).nativeName(), ((EnumType)this.type).isEnumFlags() ? "enumeration flags" : "enumeration");
        if (haveCommonPrefix) {
            this.writer.printf(" * <p>\n * The enumeration member names do not include the prefix {@code %s} as it is the same as the enumeration name.\n * </p>\n", ((EnumType)this.type).nativeName());
        }
        this.writeDocumentationUrl(this.type);
        this.writer.println(" */");
    }
}

