/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.windowsapi.writer;

import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.codecrete.windowsapi.metadata.ConstantValue;
import net.codecrete.windowsapi.metadata.Namespace;
import net.codecrete.windowsapi.metadata.Primitive;
import net.codecrete.windowsapi.metadata.Type;
import net.codecrete.windowsapi.writer.CommentWriter;
import net.codecrete.windowsapi.writer.GenerationContext;
import net.codecrete.windowsapi.writer.JavaCodeWriter;

class ConstantCodeWriter
extends JavaCodeWriter<Type> {
    private static final Set<String> POINTER_STRUCT_TYPES = Set.of("CONDITION_VARIABLE", "SRWLOCK", "INIT_ONCE");

    ConstantCodeWriter(GenerationContext generationContext) {
        super(generationContext);
    }

    void writeConstants(Namespace namespace, Collection<ConstantValue> constants) {
        this.withFile(namespace, null, "Constants", () -> this.writeConstantsContent(constants));
    }

    void writeConstantsContent(Collection<ConstantValue> constants) {
        boolean needsArena = constants.stream().anyMatch(constant -> !(constant.value() instanceof Number));
        boolean hasGuids = constants.stream().anyMatch(constant -> constant.value() instanceof UUID);
        boolean hasPropertyKeys = constants.stream().anyMatch(ConstantCodeWriter::isPropertyKey);
        this.writer.printf("package %s;\n\nimport java.lang.foreign.*;\n\n/**\n * Constants of namespace %s.\n */\npublic class Constants {\n", this.packageName, this.namespace.name());
        if (needsArena) {
            this.writer.print("    private static final Arena ARENA = Arena.ofAuto();\n\n");
        }
        if (hasGuids) {
            this.writeCreateGuidMethod(4);
        }
        if (hasPropertyKeys) {
            this.writer.print("    private static MemorySegment createPropertyKey(long v1, long v2, int v3) {\n        var seg = ARENA.allocate(20, 4);\n        seg.set(ValueLayout.JAVA_LONG, 0, v1);\n        seg.set(ValueLayout.JAVA_LONG, 8, v2);\n        seg.set(ValueLayout.JAVA_INT, 16, v3);\n        return seg;\n    }\n\n");
        }
        for (ConstantValue constant2 : constants) {
            this.writeConstant(constant2);
        }
        this.writer.println("}");
    }

    private void writeConstant(ConstantValue constant) {
        String typeName = constant.type().name();
        Object object = constant.value();
        Objects.requireNonNull(object);
        Object object2 = object;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, UUID.class, Number.class}, (Object)object2, n)) {
            case 0: {
                String ignored = (String)object2;
                if (ConstantCodeWriter.isPropertyKey(constant)) {
                    this.writePropertyKey(constant);
                    break;
                }
                if (typeName.equals("SID_IDENTIFIER_AUTHORITY")) {
                    this.writeByteArrayConstant(constant);
                    break;
                }
                if (POINTER_STRUCT_TYPES.contains(typeName)) {
                    this.writePointerStruct(constant);
                    break;
                }
                this.writeStringConstant(constant);
                break;
            }
            case 1: {
                UUID ignored = (UUID)object2;
                this.writeGuidConstant(constant);
                break;
            }
            case 2: {
                Number ignored = (Number)object2;
                this.writeNumericConstant(constant);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unexpected constant type: " + String.valueOf(constant.type())));
            }
        }
    }

    private void writeNumericConstant(ConstantValue constant) {
        String typeName;
        Type type = constant.type();
        if (type instanceof Primitive) {
            Primitive primitive = (Primitive)type;
            typeName = CommentWriter.getPrimitiveCType(primitive);
        } else {
            typeName = constant.type().name();
        }
        this.writer.printf("    /**\n     * Numeric constant {@code %s} (%s).\n     */\n", constant.name(), typeName);
        this.writer.printf("    public static final %s %s = ", ConstantCodeWriter.getJavaType(constant.type()), constant.name());
        this.writeValue(constant.type(), constant.value());
        this.writer.println(";");
        this.writer.println();
    }

    private void writeStringConstant(ConstantValue constant) {
        String value = constant.value().toString();
        assert (!constant.isAnsiEncoding() || Arrays.compare(value.getBytes(StandardCharsets.UTF_8), value.getBytes(Charset.forName("windows-1252"))) == 0);
        String stringType = String.format("%s, null-terminated", constant.isAnsiEncoding() ? "ANSI" : "UTF-16");
        this.writer.printf("    private static final MemorySegment %s$SEG = ARENA.allocateFrom(\"%s\"%s);%n%n", constant.name(), value.replace("\\", "\\\\").replace("\n", "\\n").replace("\r", "\\r"), !constant.isAnsiEncoding() ? ", java.nio.charset.StandardCharsets.UTF_16LE" : "");
        this.writer.printf("    /**\n     * String constant {@code %s} (%s).\n     */\n", constant.name(), stringType);
        this.writeMemorySegmentConstant(constant.name());
    }

    private void writeGuidConstant(ConstantValue constant) {
        this.writeGuidConstantMemorySegment(constant.name(), (UUID)constant.value(), 4);
        this.writer.printf("    /**\n     * GUID constant {@code %s} ({@code {%s}}).\n     */\n", constant.name(), constant.value());
        this.writeMemorySegmentConstant(constant.name());
    }

    private static boolean isPropertyKey(ConstantValue constant) {
        return constant.type().name().equals("PROPERTYKEY") || constant.type().name().equals("DEVPROPKEY");
    }

    private void writePropertyKey(ConstantValue constant) {
        assert (constant.value() instanceof String);
        Long[] numbers = ConstantCodeWriter.parseNumbers((String)constant.value());
        assert (numbers.length == 12);
        long data1 = numbers[0];
        long data2 = numbers[1] << 32;
        long data3 = numbers[2] << 48;
        long v1 = data1 | data2 | data3;
        long v2 = 0L;
        for (int i = 10; i >= 3; --i) {
            v2 = v2 << 8 | numbers[i];
        }
        int v3 = numbers[11].intValue();
        this.writer.printf("    private static final MemorySegment %s$SEG = createPropertyKey(%dL, %dL, %d);\n\n", constant.name(), v1, v2, v3);
        this.writer.printf("    /**\n     * Property key constant {@code %s}.\n     */\n", constant.name());
        this.writeMemorySegmentConstant(constant.name());
    }

    private void writeByteArrayConstant(ConstantValue constant) {
        Long[] numbers = ConstantCodeWriter.parseNumbers(constant.value().toString());
        this.writer.printf("    private static final MemorySegment %s$SEG = ARENA.allocateFrom(ValueLayout.JAVA_BYTE", constant.name());
        for (Long number : numbers) {
            this.writer.print(", (byte) ");
            this.writer.print(number.intValue());
        }
        this.writer.println(");");
        this.writer.println();
        this.writer.printf("    /**\n     * Binary constant {@code %s}.\n     */\n", constant.name());
        this.writeMemorySegmentConstant(constant.name());
    }

    private void writePointerStruct(ConstantValue constant) {
        this.writer.printf("    private static final MemorySegment %s$SEG = ARENA.allocateFrom(ValueLayout.JAVA_LONG, %sL);\n\n", constant.name(), constant.value());
        this.writer.printf("    /**\n     * %s constant {@code %s}.\n     */\n", constant.type().name(), constant.name());
        this.writeMemorySegmentConstant(constant.name());
    }

    private static Long[] parseNumbers(String value) {
        String[] numbers = value.replace('{', ' ').replace('}', ' ').replace(" ", "").split(",");
        return (Long[])Arrays.stream(numbers).map(Long::parseLong).toArray(Long[]::new);
    }

    private void writeMemorySegmentConstant(String name) {
        this.writer.printf("    public static MemorySegment %1$s() {\n        return %1$s$SEG;\n    }\n\n", name);
    }
}

