/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.windowsapi.writer;

import java.io.PrintWriter;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import net.codecrete.windowsapi.metadata.Array;
import net.codecrete.windowsapi.metadata.LazyString;
import net.codecrete.windowsapi.metadata.Member;
import net.codecrete.windowsapi.metadata.Method;
import net.codecrete.windowsapi.metadata.Parameter;
import net.codecrete.windowsapi.metadata.Pointer;
import net.codecrete.windowsapi.metadata.Primitive;
import net.codecrete.windowsapi.metadata.PrimitiveKind;
import net.codecrete.windowsapi.metadata.Struct;
import net.codecrete.windowsapi.metadata.Type;

class CommentWriter {
    private static final String SPACES_BEFORE_ASTERISK = "        ".repeat(10) + " * ";
    private static final String SPACES_AFTER_ASTERISK = " *" + "        ".repeat(10);

    CommentWriter() {
    }

    void writeStructSnippet(PrintWriter writer, Struct struct) {
        writer.printf(" * {@snippet lang=c :\n * %s %s {\n", struct.isUnion() ? "union" : "struct", struct.nativeName());
        this.writeStructMembers(writer, 4, struct.members());
        writer.print(" * }\n * }\n");
    }

    private void writeStructMembers(PrintWriter writer, int indenting, List<Member> fields) {
        for (Member field : fields) {
            this.writeField(writer, indenting, field);
        }
    }

    private void writeField(PrintWriter writer, int indenting, Member field) {
        this.writeIndentAfterAsterisk(writer, indenting);
        this.writeCType(writer, indenting, field.type());
        writer.print(" ");
        writer.print(field.name());
        writer.println(";");
    }

    private void writeCType(PrintWriter writer, int indenting, Type type) {
        Type type2 = type;
        Objects.requireNonNull(type2);
        Type type3 = type2;
        int n = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Struct.class, Array.class}, (Object)type3, n)) {
                case 0: {
                    Struct struct = (Struct)type3;
                    if (struct.namespace() != null) {
                        n = 1;
                        continue block4;
                    }
                    writer.println(struct.isUnion() ? "union {" : "struct {");
                    this.writeStructMembers(writer, indenting + 4, struct.members());
                    this.writeIndentAfterAsterisk(writer, indenting);
                    writer.print("}");
                    break block4;
                }
                case 1: {
                    Array array = (Array)type3;
                    CommentWriter.writeShortCType(writer, array.itemType());
                    writer.print("[");
                    writer.print(array.arrayLength());
                    writer.print("]");
                    break block4;
                }
                default: {
                    CommentWriter.writeShortCType(writer, type);
                    break block4;
                }
            }
            break;
        }
    }

    void writeFunctionComment(PrintWriter writer, Method function, String label) {
        writer.printf("    /**\n     * {@code %2$s} %1$s\n     * <p>\n     * {@snippet lang=c :\n", label, function.nativeName());
        this.writeFunctionSignatureIntro(writer, function, function.nativeName(), 4);
        this.writeFunctionSignatureParameters(writer, function, 4);
        writer.print("     * );\n     * }\n     * </p>\n");
        if (function.supportsLastError()) {
            writer.print("     * <p>\n     * The additional first parameter takes a memory segment to capture the call state (replacement for {@code GetLastError()}).\n     * </p>\n");
        }
        this.writeDocumentationUrl(writer, function);
        writer.println("     */");
    }

    void writeFunctionSignatureIntro(PrintWriter writer, Method function, String functionName, int indenting) {
        this.writeIndentBeforeAsterisk(writer, indenting);
        if (function.hasReturnType()) {
            CommentWriter.writeShortCType(writer, function.returnType());
        } else {
            writer.print("void");
        }
        writer.print(" ");
        writer.print(functionName);
        writer.println("(");
    }

    void writeFunctionSignatureParameters(PrintWriter writer, Method function, int indenting) {
        for (int i = 0; i < function.parameters().length; ++i) {
            Parameter parameter = function.parameters()[i];
            this.writeIndentBeforeAsterisk(writer, indenting);
            writer.print("    ");
            CommentWriter.writeShortCType(writer, parameter.type());
            writer.print(" ");
            writer.print(parameter.name());
            if (i != function.parameters().length - 1) {
                writer.print(",");
            }
            writer.println();
        }
    }

    private void writeDocumentationUrl(PrintWriter writer, Method function) {
        LazyString documentationUrl = function.documentationUrl();
        if (documentationUrl != null) {
            writer.printf("     *\n     * @see <a href=\"%1$s\">%2$s (Microsoft)</a>\n", documentationUrl, function.nativeName());
        }
    }

    static void writeShortCType(PrintWriter writer, Type type) {
        Type type2 = type;
        Objects.requireNonNull(type2);
        Type type3 = type2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Primitive.class, Pointer.class}, (Object)type3, n)) {
            case 0: {
                Primitive primitive = (Primitive)type3;
                writer.print(CommentWriter.getPrimitiveCType(primitive));
                break;
            }
            case 1: {
                Pointer pointer = (Pointer)type3;
                CommentWriter.writeShortCType(writer, pointer.referencedType());
                writer.print("*");
                break;
            }
            default: {
                writer.print(type.nativeName());
            }
        }
    }

    static String getPrimitiveCType(Primitive type) {
        return switch (type.kind()) {
            case PrimitiveKind.INT64 -> "LONGLONG";
            case PrimitiveKind.UINT64 -> "ULONGLONG";
            case PrimitiveKind.INT_PTR -> "LONG_PTR";
            case PrimitiveKind.UINT_PTR -> "ULONG_PTR";
            case PrimitiveKind.INT32 -> "LONG";
            case PrimitiveKind.UINT32 -> "DWORD";
            case PrimitiveKind.UINT16 -> "WORD";
            case PrimitiveKind.INT16 -> "SHORT";
            case PrimitiveKind.BYTE -> "BYTE";
            case PrimitiveKind.SBYTE -> "INT8";
            case PrimitiveKind.CHAR -> "WCHAR";
            case PrimitiveKind.SINGLE -> "FLOAT";
            case PrimitiveKind.DOUBLE -> "DOUBLE";
            case PrimitiveKind.BOOL -> "BOOL";
            case PrimitiveKind.VOID -> "void";
            default -> throw new AssertionError((Object)("Unexpected primitive type: " + type.name()));
        };
    }

    private void writeIndentBeforeAsterisk(PrintWriter writer, int indenting) {
        writer.write(SPACES_BEFORE_ASTERISK, SPACES_BEFORE_ASTERISK.length() - indenting - 3, indenting + 3);
    }

    private void writeIndentAfterAsterisk(PrintWriter writer, int indenting) {
        writer.write(SPACES_AFTER_ASTERISK, 0, indenting + 2);
    }
}

