/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.windowsapi.writer;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.codecrete.windowsapi.metadata.Array;
import net.codecrete.windowsapi.metadata.ComInterface;
import net.codecrete.windowsapi.metadata.Delegate;
import net.codecrete.windowsapi.metadata.EnumType;
import net.codecrete.windowsapi.metadata.Member;
import net.codecrete.windowsapi.metadata.Method;
import net.codecrete.windowsapi.metadata.Pointer;
import net.codecrete.windowsapi.metadata.Primitive;
import net.codecrete.windowsapi.metadata.PrimitiveKind;
import net.codecrete.windowsapi.metadata.Struct;
import net.codecrete.windowsapi.metadata.Type;
import net.codecrete.windowsapi.metadata.TypeAlias;

record AddressLayout(boolean aligned, int structSize, int packageSize, String fixedName) implements Comparable<AddressLayout>
{
    private static final AddressLayout TO_ADDRESS = new AddressLayout(true, 8, 0, "ADDRESS$ADDRESS");
    private static final AddressLayout TO_ADDRESS_UNALIGNED = new AddressLayout(false, 8, 0, "ADDRESS_UNALIGNED$ADDRESS");
    private static final AddressLayout TO_UNKNOWN = new AddressLayout(true, Integer.MIN_VALUE, 0, "ADDRESS$UNKNOWN_SIZE");
    private static final AddressLayout TO_UNKNOWN_UNALIGNED = new AddressLayout(false, Integer.MIN_VALUE, 0, "ADDRESS_UNALIGNED$UNKNOWN_SIZE");
    private static final AddressLayout TO_VOID = new AddressLayout(true, 0, 0, "ADDRESS");
    private static final AddressLayout TO_VOID_UNALIGNED = new AddressLayout(false, 0, 0, "ADDRESS_UNALIGNED");

    static AddressLayout pointerToAddress(boolean aligned) {
        return aligned ? TO_ADDRESS : TO_ADDRESS_UNALIGNED;
    }

    static AddressLayout pointerToUnknown(boolean aligned) {
        return aligned ? TO_UNKNOWN : TO_UNKNOWN_UNALIGNED;
    }

    static AddressLayout pointerToVoid(boolean aligned) {
        return aligned ? TO_VOID : TO_VOID_UNALIGNED;
    }

    String name() {
        if (this.fixedName != null) {
            return this.fixedName;
        }
        return String.format("ADDRESS%s$STRUCT_%d_%d", this.aligned ? "" : "_UNALIGNED", this.structSize, this.packageSize);
    }

    @Override
    public int compareTo(AddressLayout other) {
        if (this.packageSize == 0 != (other.packageSize == 0)) {
            return this.packageSize - other.packageSize;
        }
        if (this.packageSize == 0) {
            return this.fixedName.compareTo(other.fixedName);
        }
        int cmp = this.structSize - other.structSize;
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.packageSize - other.packageSize;
        if (cmp != 0) {
            return cmp;
        }
        if (this.aligned == other.aligned) {
            return 0;
        }
        return this.aligned ? 1 : -1;
    }

    boolean isForStruct() {
        return this.packageSize > 0;
    }

    static List<AddressLayout> requiredLayouts(Struct struct) {
        HashSet<AddressLayout> addressLayouts = new HashSet<AddressLayout>();
        AddressLayout.addLayoutsRecursively(struct, struct.packageSize(), addressLayouts);
        return AddressLayout.filteredAndSorted(addressLayouts);
    }

    static List<AddressLayout> requiredLayouts(Collection<Method> functions) {
        HashSet<AddressLayout> addressLayouts = new HashSet<AddressLayout>();
        functions.stream().flatMap(Method::referencedTypes).forEach(it -> AddressLayout.addLayout(it, addressLayouts));
        return AddressLayout.filteredAndSorted(addressLayouts);
    }

    private static List<AddressLayout> filteredAndSorted(Collection<AddressLayout> addressLayouts) {
        return addressLayouts.stream().filter(it -> it != AddressLayout.pointerToVoid(true) && it != AddressLayout.pointerToVoid(false)).distinct().sorted().toList();
    }

    static List<AddressLayout> requiredLayouts(Method function) {
        return AddressLayout.requiredLayouts(List.of(function));
    }

    static List<AddressLayout> requiredLayouts(ComInterface comInterface) {
        ArrayList<ComInterface> allInterfaces = new ArrayList<ComInterface>();
        for (ComInterface intf = comInterface; intf != null; intf = intf.implementedInterface()) {
            allInterfaces.add(intf);
        }
        List<Method> methods = allInterfaces.stream().flatMap(it -> it.methods().stream()).toList();
        return AddressLayout.requiredLayouts(methods);
    }

    private static void addLayout(Type type, Set<AddressLayout> addressLayouts) {
        Type type2 = type;
        Objects.requireNonNull(type2);
        Type type3 = type2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{TypeAlias.class, Pointer.class, Delegate.class, ComInterface.class}, (Object)type3, n)) {
            case 0: {
                TypeAlias typeAlias = (TypeAlias)type3;
                AddressLayout.addLayout(typeAlias.aliasedType(), addressLayouts);
                break;
            }
            case 1: {
                Pointer pointer = (Pointer)type3;
                addressLayouts.add(AddressLayout.getAddressLayout(pointer.referencedType(), true));
                break;
            }
            case 2: {
                Delegate ignored = (Delegate)type3;
                addressLayouts.add(AddressLayout.pointerToAddress(true));
                break;
            }
            case 3: {
                ComInterface ignored = (ComInterface)type3;
                addressLayouts.add(AddressLayout.pointerToAddress(true));
                break;
            }
        }
    }

    private static void addLayoutsRecursively(Type type, int packageSize, Set<AddressLayout> addressLayouts) {
        boolean aligned = packageSize >= 8;
        Type type2 = type;
        Objects.requireNonNull(type2);
        Type type3 = type2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Struct.class, Array.class, TypeAlias.class, Pointer.class, Delegate.class, ComInterface.class}, (Object)type3, n)) {
            case 0: {
                Struct struct = (Struct)type3;
                for (Member member : struct.members()) {
                    Type memberType = member.type();
                    if (memberType instanceof Struct) {
                        Struct structMember = (Struct)memberType;
                        if (!structMember.isNested()) continue;
                        AddressLayout.addLayoutsRecursively(memberType, packageSize, addressLayouts);
                        continue;
                    }
                    AddressLayout.addLayoutsRecursively(memberType, packageSize, addressLayouts);
                }
                break;
            }
            case 1: {
                Array arrayType = (Array)type3;
                AddressLayout.addLayoutsRecursively(arrayType.itemType(), packageSize, addressLayouts);
                break;
            }
            case 2: {
                TypeAlias typeAlias = (TypeAlias)type3;
                AddressLayout.addLayoutsRecursively(typeAlias.aliasedType(), packageSize, addressLayouts);
                break;
            }
            case 3: {
                Pointer pointer = (Pointer)type3;
                addressLayouts.add(AddressLayout.getAddressLayout(pointer.referencedType(), aligned));
                break;
            }
            case 4: {
                Delegate ignored = (Delegate)type3;
                addressLayouts.add(AddressLayout.pointerToAddress(aligned));
                break;
            }
            case 5: {
                ComInterface ignored = (ComInterface)type3;
                addressLayouts.add(AddressLayout.pointerToAddress(aligned));
                break;
            }
        }
    }

    static AddressLayout getAddressLayout(Type targetType, boolean aligned) {
        Type type = targetType;
        Objects.requireNonNull(type);
        Type type2 = type;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Primitive.class, EnumType.class, TypeAlias.class, Struct.class, Pointer.class, Delegate.class, ComInterface.class}, (Object)type2, n)) {
            case 0 -> {
                Primitive primitive = (Primitive)type2;
                if (primitive.kind() == PrimitiveKind.VOID) {
                    yield AddressLayout.pointerToVoid(aligned);
                }
                yield AddressLayout.pointerToUnknown(aligned);
            }
            case 1 -> {
                EnumType enumType = (EnumType)type2;
                yield AddressLayout.getAddressLayout(enumType.baseType(), aligned);
            }
            case 2 -> {
                TypeAlias typeAlias = (TypeAlias)type2;
                yield AddressLayout.getAddressLayout(typeAlias.aliasedType(), aligned);
            }
            case 3 -> {
                Struct struct = (Struct)type2;
                if (struct.namespace() != null && !struct.isArchitectureSpecific()) {
                    yield new AddressLayout(aligned, struct.structSize(), struct.packageSize(), null);
                }
                yield AddressLayout.pointerToUnknown(aligned);
            }
            case 4 -> {
                Pointer ignored = (Pointer)type2;
                yield AddressLayout.pointerToAddress(aligned);
            }
            case 5 -> {
                Delegate ignored = (Delegate)type2;
                yield AddressLayout.pointerToAddress(aligned);
            }
            case 6 -> {
                ComInterface ignored = (ComInterface)type2;
                yield AddressLayout.pointerToAddress(aligned);
            }
            default -> throw new AssertionError((Object)("Unexpected type: " + String.valueOf(targetType)));
        };
    }
}

