/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.windowsapi.winmd.tables;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;

public class TableRangeIterable<T>
implements Iterable<T> {
    private final Function<Integer, T> creator;
    private final int startIndex;
    private final int endIndex;

    public TableRangeIterable(int startIndex, int endIndex, Function<Integer, T> creator) {
        this.creator = creator;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int index;
            {
                this.index = TableRangeIterable.this.startIndex;
            }

            @Override
            public boolean hasNext() {
                return this.index <= TableRangeIterable.this.endIndex;
            }

            @Override
            public T next() {
                if (this.index > TableRangeIterable.this.endIndex) {
                    throw new NoSuchElementException();
                }
                Object row = TableRangeIterable.this.creator.apply(this.index);
                ++this.index;
                return row;
            }
        };
    }
}

