/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.windowsapi.winmd.tables;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.function.Function;
import net.codecrete.windowsapi.winmd.tables.Table;

public class RowKeyTableIterable<T>
implements Iterable<T> {
    private final Table table;
    private final Function<Integer, T> creator;
    private final int keyValue;
    private final int keyWidth;

    public RowKeyTableIterable(Table table, int keyValue, int keyWidth, Function<Integer, T> creator) {
        this.table = table;
        this.creator = creator;
        this.keyValue = keyValue;
        this.keyWidth = keyWidth;
    }

    @Override
    public Iterator<T> iterator() {
        final int startIndex = this.table.indexByPrimaryKey(this.keyValue, this.keyWidth, 0);
        return new Iterator<T>(this){
            private int index;
            private boolean hasElement;
            final /* synthetic */ RowKeyTableIterable this$0;
            {
                this.this$0 = this$0;
                this.index = startIndex;
                this.hasElement = startIndex != 0;
            }

            @Override
            public boolean hasNext() {
                return this.hasElement;
            }

            @Override
            public T next() {
                if (!this.hasElement) {
                    throw new NoSuchElementException();
                }
                Object row = this.this$0.creator.apply(this.index);
                this.hasElement = this.this$0.table.hasNext(this.index, this.this$0.keyValue, this.this$0.keyWidth);
                if (this.hasElement) {
                    ++this.index;
                }
                return row;
            }
        };
    }
}

