/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.windowsapi.winmd.tables;

public record CodedIndex(int table, int index) {
    public static CodedIndex decode(int rawIndex, int[] tables) {
        int numBitsTable = 32 - Integer.numberOfLeadingZeros(tables.length - 1);
        int tableMask = (1 << numBitsTable) - 1;
        return new CodedIndex(tables[rawIndex & tableMask], rawIndex >> numBitsTable);
    }

    public static int encode(int table, int index, int[] tables) {
        int numBitsTable = 32 - Integer.numberOfLeadingZeros(tables.length - 1);
        for (int i = 0; i < tables.length; ++i) {
            if (tables[i] != table) continue;
            return index << numBitsTable | i;
        }
        assert (false) : "Invalid table or table list";
        return 0;
    }

    public boolean isNull() {
        return this.index == 0;
    }
}

