/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.windowsapi.winmd;

import net.codecrete.windowsapi.metadata.Struct;
import net.codecrete.windowsapi.metadata.Type;
import net.codecrete.windowsapi.winmd.Blob;
import net.codecrete.windowsapi.winmd.Decoder;
import net.codecrete.windowsapi.winmd.MethodSignature;
import net.codecrete.windowsapi.winmd.TypeLookup;

class SignatureDecoder
extends Decoder {
    SignatureDecoder(TypeLookup typeLookup) {
        super(typeLookup);
    }

    MethodSignature decodeMethodDefSignature(Blob signature) {
        int flags = signature.readByte();
        int genericParamCount = 0;
        if ((flags & 0x10) != 0) {
            genericParamCount = signature.readCompressedUnsignedInt();
            assert (genericParamCount == 0);
        }
        int paramCount = signature.readCompressedUnsignedInt();
        Type returnType = this.decodeType(signature, null);
        Type[] params = new Type[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            params[i] = this.decodeType(signature, null);
        }
        assert (signature.isAtEnd());
        return new MethodSignature(returnType, params);
    }

    Type decodeFieldSignature(Blob signature, Struct parentType) {
        int field = signature.readByte();
        assert (field == 6);
        Type type = this.decodeType(signature, parentType);
        assert (signature.isAtEnd());
        return type;
    }
}

