/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.windowsapi.winmd;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;

public class LittleEndianDataInputStream {
    private final InputStream in;
    private int offset = 0;

    public LittleEndianDataInputStream(InputStream in) {
        this.in = in;
    }

    public long getOffset() {
        return this.offset;
    }

    public final void readFully(byte[] b) throws IOException {
        this.readFully(b, 0, b.length);
    }

    public final void readFully(byte[] b, int off, int len) throws IOException {
        int count;
        Objects.checkFromIndexSize(off, len, b.length);
        for (int n = 0; n < len; n += count) {
            count = this.in.read(b, off + n, len - n);
            if (count < 0) {
                throw new EOFException();
            }
            this.offset += count;
        }
    }

    public void skipNBytes(int n) throws IOException {
        if (n < 0) {
            throw new IOException("Cannot skip backwards");
        }
        while (n > 0) {
            long count = this.in.skip(n);
            if (count == 0L) {
                throw new EOFException();
            }
            n -= (int)count;
            this.offset += (int)count;
        }
    }

    public void skipTo(int offset) throws IOException {
        this.skipNBytes(offset - this.offset);
    }

    public final byte readByte() throws IOException {
        int ch = this.in.read();
        if (ch < 0) {
            throw new EOFException();
        }
        ++this.offset;
        return (byte)ch;
    }

    public final int readUnsignedShort() throws IOException {
        int ch2;
        int ch1 = this.in.read();
        if ((ch1 | (ch2 = this.in.read())) < 0) {
            throw new EOFException();
        }
        this.offset += 2;
        return ch1 + (ch2 << 8);
    }

    public final int readInt() throws IOException {
        byte[] bytes = new byte[4];
        this.readFully(bytes);
        int ch1 = bytes[0] & 0xFF;
        int ch2 = bytes[1] & 0xFF;
        int ch3 = bytes[2] & 0xFF;
        int ch4 = bytes[3] & 0xFF;
        return ch1 + (ch2 << 8) + (ch3 << 16) + (ch4 << 24);
    }

    public final long readLong() throws IOException {
        byte[] bytes = new byte[8];
        this.readFully(bytes);
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            result += (long)(bytes[i] & 0xFF) << 8 * i;
        }
        return result;
    }
}

