/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.windowsapi.winmd;

import net.codecrete.windowsapi.metadata.Array;
import net.codecrete.windowsapi.metadata.Struct;
import net.codecrete.windowsapi.metadata.Type;
import net.codecrete.windowsapi.winmd.Blob;
import net.codecrete.windowsapi.winmd.TypeLookup;
import net.codecrete.windowsapi.winmd.tables.CodedIndex;
import net.codecrete.windowsapi.winmd.tables.CodedIndexes;

class Decoder {
    protected final TypeLookup typeLookup;

    protected Decoder(TypeLookup typeLookup) {
        this.typeLookup = typeLookup;
    }

    protected Type decodeType(Blob signature, Struct parentType) {
        int elementType = signature.readByte();
        Type type = this.typeLookup.getPrimitiveType(elementType);
        if (type != null) {
            return type;
        }
        if (elementType == 15) {
            type = this.decodeType(signature, parentType);
            assert (type != null);
            return this.typeLookup.makePointerFor(type);
        }
        if (elementType == 17) {
            int typeDefOrRefOrSpecEncoded = signature.readCompressedUnsignedInt();
            CodedIndex typeDefOrRefIndex = CodedIndex.decode(typeDefOrRefOrSpecEncoded, CodedIndexes.TYPE_DEF_OR_REF_TABLES);
            Type valueType = typeDefOrRefIndex.table() == 1 ? this.typeLookup.getTypeByTypeRef(typeDefOrRefIndex.index(), parentType, false) : this.typeLookup.getTypeByTypeDef(typeDefOrRefIndex.index());
            assert (valueType != null);
            return valueType;
        }
        if (elementType == 18) {
            int typeDefOrRefOrSpecEncoded = signature.readCompressedUnsignedInt();
            CodedIndex typeDefOrRefIndex = CodedIndex.decode(typeDefOrRefOrSpecEncoded, CodedIndexes.TYPE_DEF_OR_REF_TABLES);
            Type classType = typeDefOrRefIndex.table() == 1 ? this.typeLookup.getTypeByTypeRef(typeDefOrRefIndex.index(), parentType, true) : this.typeLookup.getTypeByTypeDef(typeDefOrRefIndex.index());
            assert (classType != null);
            return classType;
        }
        if (elementType == 20) {
            return this.decodeArray(signature, parentType);
        }
        assert (false) : "Unknown element type: " + elementType;
        return null;
    }

    private Array decodeArray(Blob signature, Struct parentType) {
        Type arrayType = this.decodeType(signature, parentType);
        int rank = signature.readCompressedUnsignedInt();
        assert (rank == 1);
        int numSizes = signature.readCompressedUnsignedInt();
        assert (numSizes == 1);
        int size = signature.readCompressedUnsignedInt();
        int numLoBounds = signature.readCompressedUnsignedInt();
        assert (numLoBounds == 0 || numLoBounds == 1);
        if (numLoBounds == 1) {
            signature.readCompressedUnsignedInt();
        }
        return new Array(arrayType.name() + "[]", null, 0, arrayType, size);
    }

    protected static Object readPrimitiveVal(Blob blob, int elementType) {
        if (elementType == 14) {
            return blob.readUtf8String();
        }
        return Decoder.readValue(blob, elementType);
    }

    protected static Object readConstantVal(Blob blob, int elementType) {
        if (elementType == 14) {
            return blob.readUtf16String();
        }
        return Decoder.readValue(blob, elementType);
    }

    private static Object readValue(Blob blob, int elementType) {
        return switch (elementType) {
            case 4, 5 -> (byte)blob.readByte();
            case 6, 7 -> (short)blob.readUInt16();
            case 8, 9 -> blob.readInt32();
            case 12 -> Float.valueOf(Float.intBitsToFloat(blob.readInt32()));
            case 10, 11 -> blob.readInt64();
            case 13 -> Double.longBitsToDouble(blob.readInt64());
            default -> throw new AssertionError((Object)("Invalid primitive type " + elementType));
        };
    }
}

