/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.windowsapi.winmd;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.codecrete.windowsapi.metadata.ArgumentValue;
import net.codecrete.windowsapi.metadata.Array;
import net.codecrete.windowsapi.metadata.EnumType;
import net.codecrete.windowsapi.metadata.LazyString;
import net.codecrete.windowsapi.metadata.Primitive;
import net.codecrete.windowsapi.metadata.QualifiedName;
import net.codecrete.windowsapi.metadata.Type;
import net.codecrete.windowsapi.winmd.Blob;
import net.codecrete.windowsapi.winmd.CustomAttributeData;
import net.codecrete.windowsapi.winmd.CustomAttributeValue;
import net.codecrete.windowsapi.winmd.Decoder;
import net.codecrete.windowsapi.winmd.MetadataFile;
import net.codecrete.windowsapi.winmd.MethodSignature;
import net.codecrete.windowsapi.winmd.TypeLookup;
import net.codecrete.windowsapi.winmd.tables.CodedIndex;
import net.codecrete.windowsapi.winmd.tables.CodedIndexes;
import net.codecrete.windowsapi.winmd.tables.CustomAttribute;
import net.codecrete.windowsapi.winmd.tables.MemberRef;
import net.codecrete.windowsapi.winmd.tables.TypeRef;

class CustomAttributeDecoder
extends Decoder {
    private static final String SYSTEM = "System";
    private static final String METADATA = "Windows.Win32.Foundation.Metadata";
    private static final QualifiedName FLAGS_ATTRIBUTE = new QualifiedName("System", "FlagsAttribute");
    private static final QualifiedName OBSOLETE_ATTRIBUTE = new QualifiedName("System", "ObsoleteAttribute");
    private static final QualifiedName CONSTANT_ATTRIBUTE = new QualifiedName("Windows.Win32.Foundation.Metadata", "ConstantAttribute");
    private static final QualifiedName DOCUMENTATION_ATTRIBUTE = new QualifiedName("Windows.Win32.Foundation.Metadata", "DocumentationAttribute");
    private static final QualifiedName FLEXIBLE_ARRAY_ATTRIBUTE = new QualifiedName("Windows.Win32.Foundation.Metadata", "FlexibleArrayAttribute");
    private static final QualifiedName GUID_ATTRIBUTE = new QualifiedName("Windows.Win32.Foundation.Metadata", "GuidAttribute");
    private static final QualifiedName NATIVE_ENCODING_ATTRIBUTE = new QualifiedName("Windows.Win32.Foundation.Metadata", "NativeEncodingAttribute");
    private static final QualifiedName NATIVE_TYPEDEF_ATTRIBUTE = new QualifiedName("Windows.Win32.Foundation.Metadata", "NativeTypedefAttribute");
    private static final QualifiedName STRUCT_SIZE_FIELD_ATTRIBUTE = new QualifiedName("Windows.Win32.Foundation.Metadata", "StructSizeFieldAttribute");
    private static final QualifiedName SUPPORTED_ARCHITECTURE_ATTRIBUTE = new QualifiedName("Windows.Win32.Foundation.Metadata", "SupportedArchitectureAttribute");
    private static final Set<QualifiedName> relevantAttributes = Set.of(CONSTANT_ATTRIBUTE, FLAGS_ATTRIBUTE, OBSOLETE_ATTRIBUTE, DOCUMENTATION_ATTRIBUTE, FLEXIBLE_ARRAY_ATTRIBUTE, GUID_ATTRIBUTE, NATIVE_ENCODING_ATTRIBUTE, NATIVE_TYPEDEF_ATTRIBUTE, STRUCT_SIZE_FIELD_ATTRIBUTE, SUPPORTED_ARCHITECTURE_ATTRIBUTE);
    private static final Set<QualifiedName> ignoredAttributes = Set.of(new QualifiedName("System", "AttributeUsageAttribute"), new QualifiedName("System.Diagnostics.CodeAnalysis", "DoesNotReturnAttribute"), new QualifiedName("System.Runtime.InteropServices", "ComVisibleAttribute"), new QualifiedName("System.Runtime.InteropServices", "UnmanagedFunctionPointerAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "AgileAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "AlsoUsableForAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "AnsiAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "AssociatedConstantAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "AssociatedEnumAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "CanReturnErrorsAsSuccessAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "CanReturnMultipleSuccessValuesAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "ConstAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "InvalidHandleValueAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "MetadataTypedefAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "NativeArrayInfoAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "NativeBitfieldAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "NotNullTerminatedAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "NullNullTerminatedAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "RAIIFreeAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "ScopedEnumAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "SupportedOSPlatformAttribute"), new QualifiedName("Windows.Win32.Foundation.Metadata", "UnicodeAttribute"));
    private final MetadataFile metadataFile;
    private final Primitive stringType;

    CustomAttributeDecoder(TypeLookup typeLookup, MetadataFile metadataFile) {
        super(typeLookup);
        this.metadataFile = metadataFile;
        this.stringType = typeLookup.getPrimitiveType(14);
    }

    CustomAttributeData getTypeDefAttributes(int typeDef) {
        int typeDefIndex = CodedIndex.encode(2, typeDef, CodedIndexes.HAS_CUSTOM_ATTRIBUTE_TABLES);
        return this.getAttributes(typeDefIndex);
    }

    CustomAttributeData getMethodDefAttributes(int methodDef) {
        int methodDefIndex = CodedIndex.encode(6, methodDef, CodedIndexes.HAS_CUSTOM_ATTRIBUTE_TABLES);
        return this.getAttributes(methodDefIndex);
    }

    CustomAttributeData getFieldAttributes(int field) {
        int fieldIndex = CodedIndex.encode(4, field, CodedIndexes.HAS_CUSTOM_ATTRIBUTE_TABLES);
        return this.getAttributes(fieldIndex);
    }

    private CustomAttributeData getAttributes(int hasCustomAttributeIndex) {
        CustomAttributeData data = new CustomAttributeData();
        for (CustomAttribute customAttribute : this.metadataFile.getCustomAttributes(hasCustomAttributeIndex)) {
            CustomAttributeValue value;
            CodedIndex constructor = customAttribute.constructorIndex();
            assert (constructor.table() == 10);
            assert (constructor.index() != 0);
            MemberRef memberRef = this.metadataFile.getMemberRef(constructor.index());
            CodedIndex parent = memberRef.parentIndex();
            assert (parent.table() == 1);
            assert (parent.index() != 0);
            TypeRef typeRef = this.metadataFile.getTypeRef(parent.index());
            QualifiedName qualifiedName = new QualifiedName(this.metadataFile.getString(typeRef.typeNamespace()), this.metadataFile.getString(typeRef.typeName()));
            if (ignoredAttributes.contains(qualifiedName)) continue;
            assert (relevantAttributes.contains(qualifiedName));
            if (qualifiedName.equals(FLAGS_ATTRIBUTE)) {
                data.isEnumFlags = true;
                continue;
            }
            if (qualifiedName.equals(OBSOLETE_ATTRIBUTE)) {
                data.isObsolete = true;
                continue;
            }
            if (qualifiedName.equals(NATIVE_TYPEDEF_ATTRIBUTE)) {
                data.isTypedef = true;
                continue;
            }
            if (qualifiedName.equals(DOCUMENTATION_ATTRIBUTE)) {
                data.documentationUrl = this.getLazyString(customAttribute, memberRef);
                continue;
            }
            if (qualifiedName.equals(SUPPORTED_ARCHITECTURE_ATTRIBUTE)) {
                value = this.getValue(customAttribute, memberRef);
                data.supportedArchitecture = ((Number)value.fixedArguments()[0].value()).intValue();
                continue;
            }
            if (qualifiedName.equals(GUID_ATTRIBUTE)) {
                value = this.getValue(customAttribute, memberRef);
                data.guidConstant = CustomAttributeDecoder.createGuidConstant(value);
                continue;
            }
            if (qualifiedName.equals(CONSTANT_ATTRIBUTE)) {
                value = this.getValue(customAttribute, memberRef);
                data.constantValue = value.fixedArguments()[0].value();
                continue;
            }
            if (qualifiedName.equals(NATIVE_ENCODING_ATTRIBUTE)) {
                value = this.getValue(customAttribute, memberRef);
                data.isAnsiEncoding = value.fixedArguments()[0].value().equals("ansi");
                continue;
            }
            if (qualifiedName.equals(FLEXIBLE_ARRAY_ATTRIBUTE)) {
                data.isFlexibleArray = true;
                continue;
            }
            if (!qualifiedName.equals(STRUCT_SIZE_FIELD_ATTRIBUTE)) continue;
            value = this.getValue(customAttribute, memberRef);
            data.structSizeField = (String)value.fixedArguments()[0].value();
        }
        return data;
    }

    private CustomAttributeValue getValue(CustomAttribute customAttribute, MemberRef memberRef) {
        MethodSignature methodSignature = this.decodeMethodRefSignature(this.metadataFile.getBlob(memberRef.signature()));
        Blob valueBlob = this.metadataFile.getBlob(customAttribute.value());
        return this.decodeCustomAttributeValue(methodSignature, valueBlob);
    }

    private MethodSignature decodeMethodRefSignature(Blob signature) {
        signature.readByte();
        int paramCount = signature.readCompressedUnsignedInt();
        Type returnType = this.decodeType(signature, null);
        Type[] params = new Type[paramCount];
        for (int i = 0; i < paramCount; ++i) {
            params[i] = this.decodeType(signature, null);
            assert (params[i] != null);
        }
        assert (signature.isAtEnd());
        return new MethodSignature(returnType, params);
    }

    private LazyString getLazyString(CustomAttribute customAttribute, MemberRef memberRef) {
        MethodSignature methodSignature = this.decodeMethodRefSignature(this.metadataFile.getBlob(memberRef.signature()));
        assert (methodSignature.paramTypes().length == 1);
        assert (methodSignature.paramTypes()[0] == this.stringType);
        Blob valueBlob = this.metadataFile.getBlob(customAttribute.value());
        LazyString value = this.decodeSingleStringValue(valueBlob);
        int numNamedArgs = valueBlob.readUInt16();
        assert (numNamedArgs == 0);
        assert (valueBlob.isAtEnd());
        return value;
    }

    CustomAttributeValue decodeCustomAttributeValue(MethodSignature methodSignature, Blob valueBlob) {
        int prolog = valueBlob.readUInt16();
        assert (prolog == 1);
        Type[] fixedParamTypes = methodSignature.paramTypes();
        int numFixedArgs = fixedParamTypes.length;
        ArgumentValue[] fixedArguments = new ArgumentValue[numFixedArgs];
        for (int i = 0; i < numFixedArgs; ++i) {
            assert (!(fixedParamTypes[i] instanceof Array));
            fixedArguments[i] = new ArgumentValue(fixedParamTypes[i], null, this.readElem(valueBlob, fixedParamTypes[i]));
        }
        int numNamedArgs = valueBlob.readUInt16();
        assert (numNamedArgs == 0);
        assert (valueBlob.isAtEnd());
        return new CustomAttributeValue(fixedArguments);
    }

    private LazyString decodeSingleStringValue(Blob valueBlob) {
        int prolog = valueBlob.readUInt16();
        assert (prolog == 1);
        int len = valueBlob.readCompressedUnsignedInt();
        int offset = valueBlob.offset();
        valueBlob.skip(len);
        return new LazyString(valueBlob.data(), offset, len);
    }

    private Object readElem(Blob blob, Type type) {
        Type type2 = type;
        Objects.requireNonNull(type2);
        Type type3 = type2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Primitive.class, EnumType.class}, (Object)type3, n)) {
            case 0 -> {
                Primitive primitive = (Primitive)type3;
                yield CustomAttributeDecoder.readPrimitiveVal(blob, this.typeLookup.getElementType(primitive));
            }
            case 1 -> {
                EnumType enumType = (EnumType)type3;
                yield CustomAttributeDecoder.readPrimitiveVal(blob, this.typeLookup.getElementType(enumType.baseType()));
            }
            default -> throw new IllegalArgumentException("Unsupported element type: " + type.getClass().getSimpleName());
        };
    }

    private static UUID createGuidConstant(CustomAttributeValue value) {
        ArgumentValue[] fixedArguments = value.fixedArguments();
        long a = 0xFFFFFFFFL & (long)((Integer)fixedArguments[0].value()).intValue();
        long b = 0xFFFFL & (long)((Short)fixedArguments[1].value()).shortValue();
        long c = 0xFFFFL & (long)((Short)fixedArguments[2].value()).shortValue();
        long mostSigBits = a << 32 | b << 16 | c;
        long leastSigBits = 0L;
        for (int i = 0; i < 8; ++i) {
            long v = 0xFFL & (long)((Byte)fixedArguments[i + 3].value()).byteValue();
            leastSigBits |= v << 56 - i * 8;
        }
        return new UUID(mostSigBits, leastSigBits);
    }
}

