/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.windowsapi.winmd;

import java.nio.charset.StandardCharsets;

public class Blob {
    private final byte[] data;
    private int offset;
    private final int end;

    Blob(byte[] data, int offset, int length) {
        this.data = data;
        this.offset = offset;
        this.end = offset + length;
    }

    byte[] data() {
        return this.data;
    }

    int offset() {
        return this.offset;
    }

    boolean isAtEnd() {
        return this.offset == this.end;
    }

    int readByte() {
        assert (this.offset < this.end);
        int result = this.data[this.offset] & 0xFF;
        ++this.offset;
        return result;
    }

    int readUInt16() {
        assert (this.offset + 2 <= this.end);
        int byte1 = this.data[this.offset] & 0xFF;
        int byte2 = this.data[this.offset + 1] & 0xFF;
        this.offset += 2;
        return (byte2 << 8) + byte1;
    }

    int readInt32() {
        assert (this.offset + 4 <= this.end);
        int byte1 = this.data[this.offset] & 0xFF;
        int byte2 = this.data[this.offset + 1] & 0xFF;
        int byte3 = this.data[this.offset + 2] & 0xFF;
        int byte4 = this.data[this.offset + 3] & 0xFF;
        this.offset += 4;
        return (byte4 << 24) + (byte3 << 16) + (byte2 << 8) + byte1;
    }

    long readInt64() {
        assert (this.offset + 8 <= this.end);
        long result = 0L;
        for (int i = 0; i < 8; ++i) {
            result |= (long)(this.data[this.offset + i] & 0xFF) << i * 8;
        }
        this.offset += 8;
        return result;
    }

    String readUtf8String() {
        int len = this.readCompressedUnsignedInt();
        assert (this.offset + len <= this.end);
        this.offset += len;
        return new String(this.data, this.offset - len, len, StandardCharsets.UTF_8);
    }

    String readUtf16String() {
        int len = this.end - this.offset;
        assert ((len & 1) == 0);
        this.offset = this.end;
        return new String(this.data, this.offset - len, len, StandardCharsets.UTF_16LE);
    }

    int readCompressedUnsignedInt() {
        int byte1 = this.readByte();
        if (byte1 <= 127) {
            return byte1;
        }
        int byte2 = this.readByte();
        if ((byte1 & 0xC0) == 128) {
            return ((byte1 & 0x3F) << 8) + byte2;
        }
        if ((byte1 & 0xE0) == 192) {
            int byte3 = this.readByte();
            int byte4 = this.readByte();
            return ((byte1 & 0x1F) << 24) + (byte2 << 16) + (byte3 << 8) + byte4;
        }
        assert (false) : "Invalid compressed integer";
        return 0;
    }

    void skip(int bytes) {
        this.offset += bytes;
    }
}

