/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.windowsapi.metadata;

import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.codecrete.windowsapi.metadata.Array;
import net.codecrete.windowsapi.metadata.ComInterface;
import net.codecrete.windowsapi.metadata.Delegate;
import net.codecrete.windowsapi.metadata.EnumType;
import net.codecrete.windowsapi.metadata.LazyString;
import net.codecrete.windowsapi.metadata.Namespace;
import net.codecrete.windowsapi.metadata.Pointer;
import net.codecrete.windowsapi.metadata.Primitive;
import net.codecrete.windowsapi.metadata.Struct;
import net.codecrete.windowsapi.metadata.TypeAlias;

public abstract sealed class Type
permits Struct, Delegate, Primitive, Pointer, Array, TypeAlias, EnumType, ComInterface {
    protected String name;
    protected final String nativeName;
    protected final Namespace namespace;
    protected final int typeDefIndex;
    protected LazyString documentationUrl;
    private static final Pattern ANONYMOUS_NAME_PATTERN = Pattern.compile("anonymous", 2);

    protected Type(String name, Namespace namespace, int typeDefIndex) {
        this.name = name;
        this.nativeName = name;
        this.namespace = namespace;
        this.typeDefIndex = typeDefIndex;
    }

    public final String name() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final String nativeName() {
        return this.nativeName;
    }

    public final Namespace namespace() {
        return this.namespace;
    }

    public final int typeDefIndex() {
        return this.typeDefIndex;
    }

    public final boolean isAnonymous() {
        return this.namespace() == null && ANONYMOUS_NAME_PATTERN.matcher(this.name()).find();
    }

    public final LazyString documentationUrl() {
        return this.documentationUrl;
    }

    public final void setDocumentationUrl(LazyString documentationUrl) {
        this.documentationUrl = documentationUrl;
    }

    public Stream<Type> referencedTypes() {
        return Stream.empty();
    }

    public void replaceTypes(UnaryOperator<Type> typeReplacement) {
    }
}

