/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.windowsapi.metadata;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.codecrete.windowsapi.metadata.Member;
import net.codecrete.windowsapi.metadata.Namespace;
import net.codecrete.windowsapi.metadata.Type;

public final class Struct
extends Type {
    private final boolean isUnion;
    private int packageSize;
    private int structSize;
    private final Struct enclosingType;
    private Map<String, Type> nestedTypes;
    private List<Member> members;
    private boolean isLayoutDone;
    private boolean isArchitectureSpecific;
    private Member flexibleArrayMember;
    private final String structSizeMember;
    private final UUID guid;

    public Struct(String name, Namespace namespace, int typeDefIndex, boolean isUnion, int packageSize, int structSize, Struct enclosingType, String structSizeMember, UUID guid) {
        super(name, namespace, typeDefIndex);
        assert (namespace != null || enclosingType != null);
        this.isUnion = isUnion;
        this.enclosingType = enclosingType;
        this.packageSize = packageSize;
        this.structSize = structSize;
        this.structSizeMember = structSizeMember;
        this.guid = guid;
    }

    public boolean isUnion() {
        return this.isUnion;
    }

    public int packageSize() {
        return this.packageSize;
    }

    public void setPackageSize(int packageSize) {
        this.packageSize = packageSize;
    }

    public int structSize() {
        return this.structSize;
    }

    public void setStructSize(int structSize) {
        this.structSize = structSize;
    }

    public boolean isLayoutDone() {
        return this.isLayoutDone;
    }

    public void setLayoutDone() {
        this.isLayoutDone = true;
    }

    public Struct enclosingType() {
        return this.enclosingType;
    }

    public void addNestedType(Type nestedType) {
        if (this.nestedTypes == null) {
            this.nestedTypes = new HashMap<String, Type>();
        }
        assert (!this.nestedTypes.containsKey(nestedType.name()));
        this.nestedTypes.put(nestedType.name(), nestedType);
    }

    public Type getNestedType(String name) {
        assert (this.nestedTypes != null);
        Type type = this.nestedTypes.get(name);
        assert (type != null);
        return type;
    }

    public boolean hasNestedTypes() {
        return this.nestedTypes != null;
    }

    public Collection<Type> nestedTypes() {
        assert (this.nestedTypes != null);
        return this.nestedTypes.values();
    }

    public List<Member> members() {
        return this.members;
    }

    public void setMembers(List<Member> members) {
        this.members = members;
    }

    public boolean isNested() {
        return this.namespace == null;
    }

    public boolean hasFixedSize() {
        return this.flexibleArrayMember == null;
    }

    public Member flexibleArrayMember() {
        return this.flexibleArrayMember;
    }

    public void setFlexibleArrayMember(Member flexibleArrayMember) {
        this.flexibleArrayMember = flexibleArrayMember;
    }

    public String structSizeMember() {
        return this.structSizeMember;
    }

    public boolean isArchitectureSpecific() {
        return this.isArchitectureSpecific;
    }

    public void setArchitectureSpecific(boolean isArchitectureSpecific) {
        this.isArchitectureSpecific = isArchitectureSpecific;
    }

    public UUID guid() {
        return this.guid;
    }

    @Override
    public Stream<Type> referencedTypes() {
        return Stream.concat(this.members.stream().map(Member::type), this.nestedTypes != null ? this.nestedTypes.values().stream() : Stream.empty());
    }

    public Struct duplicate(int newTypeDefIndex) {
        Struct struct = new Struct(this.name, this.namespace, newTypeDefIndex, this.isUnion, this.packageSize, this.structSize, this.enclosingType, this.structSizeMember, this.guid);
        struct.nestedTypes = this.nestedTypes;
        struct.members = this.members;
        struct.flexibleArrayMember = this.flexibleArrayMember;
        return struct;
    }

    @Override
    public void replaceTypes(UnaryOperator<Type> typeReplacement) {
        if (this.nestedTypes != null) {
            this.nestedTypes = this.nestedTypes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, it -> (Type)typeReplacement.apply((Type)it.getValue())));
        }
        this.members = this.members.stream().map(member -> member.duplicate(typeReplacement)).toList();
    }
}

