/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.windowsapi.metadata;

import java.util.Arrays;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.codecrete.windowsapi.metadata.LazyString;
import net.codecrete.windowsapi.metadata.Namespace;
import net.codecrete.windowsapi.metadata.Parameter;
import net.codecrete.windowsapi.metadata.Primitive;
import net.codecrete.windowsapi.metadata.PrimitiveKind;
import net.codecrete.windowsapi.metadata.Type;

public class Method {
    private String name;
    private final String nativeName;
    private final Namespace namespace;
    private final int methodDefIndex;
    private Type returnType;
    private Parameter[] parameters;
    private String dll;
    private boolean supportsLastError;
    private Object constantValue;
    private LazyString documentationUrl;

    public Method(String name, Namespace namespace, int methodDefIndex) {
        this.name = name;
        this.nativeName = name;
        this.namespace = namespace;
        this.methodDefIndex = methodDefIndex;
    }

    public String name() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String nativeName() {
        return this.nativeName;
    }

    public Namespace namespace() {
        return this.namespace;
    }

    public int methodDefIndex() {
        return this.methodDefIndex;
    }

    public void replaceTypes(UnaryOperator<Type> typeReplacer) {
        this.returnType = (Type)typeReplacer.apply(this.returnType);
        Parameter[] newParameters = new Parameter[this.parameters.length];
        for (int i = 0; i < newParameters.length; ++i) {
            newParameters[i] = new Parameter(this.parameters[i].name(), (Type)typeReplacer.apply(this.parameters[i].type()));
        }
        this.parameters = newParameters;
    }

    public Type returnType() {
        return this.returnType;
    }

    public void setReturnType(Type returnType) {
        this.returnType = returnType;
    }

    public Parameter[] parameters() {
        assert (this.parameters != null);
        return this.parameters;
    }

    public void setParameters(Parameter[] parameters) {
        this.parameters = parameters;
    }

    public Stream<Type> referencedTypes() {
        return Stream.concat(Stream.of(this.returnType), Arrays.stream(this.parameters).map(Parameter::type));
    }

    public String dll() {
        return this.dll;
    }

    public void setDll(String dll) {
        this.dll = dll;
    }

    public boolean hasReturnType() {
        Primitive primitive;
        assert (this.returnType != null);
        Type type = this.returnType;
        return !(type instanceof Primitive && (primitive = (Primitive)type).kind() == PrimitiveKind.VOID);
    }

    public boolean supportsLastError() {
        return this.supportsLastError;
    }

    public void setSupportsLastError(boolean supportsLastError) {
        this.supportsLastError = supportsLastError;
    }

    public Object constantValue() {
        return this.constantValue;
    }

    public void setConstantValue(Object constantValue) {
        this.constantValue = constantValue;
    }

    public final LazyString documentationUrl() {
        return this.documentationUrl;
    }

    public final void setDocumentationUrl(LazyString documentationUrl) {
        this.documentationUrl = documentationUrl;
    }
}

