/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.windowsapi.metadata;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.codecrete.windowsapi.metadata.Array;
import net.codecrete.windowsapi.metadata.ComInterface;
import net.codecrete.windowsapi.metadata.ConstantValue;
import net.codecrete.windowsapi.metadata.Delegate;
import net.codecrete.windowsapi.metadata.EnumType;
import net.codecrete.windowsapi.metadata.Member;
import net.codecrete.windowsapi.metadata.Method;
import net.codecrete.windowsapi.metadata.Namespace;
import net.codecrete.windowsapi.metadata.Pointer;
import net.codecrete.windowsapi.metadata.Primitive;
import net.codecrete.windowsapi.metadata.PrimitiveKind;
import net.codecrete.windowsapi.metadata.Struct;
import net.codecrete.windowsapi.metadata.Type;
import net.codecrete.windowsapi.metadata.TypeAlias;

public class Metadata {
    private final Map<String, Namespace> namespaces = new HashMap<String, Namespace>();
    private final Namespace unnamedNamespace = new Namespace(null);
    private final Map<Integer, Type> typesByDefinitionIndex = new HashMap<Integer, Type>();
    private final Map<Integer, Method> methodsByMethodDefIndex = new HashMap<Integer, Method>();
    private final Map<PrimitiveKind, Primitive> primitivesByKind = Metadata.buildPrimitiveTypes(this.unnamedNamespace);
    private final Map<Type, Pointer> pointersByType = new HashMap<Type, Pointer>();
    private final Map<Integer, TypeAlias> aliasesByTypeDefIndex = new HashMap<Integer, TypeAlias>();

    public Metadata() {
        this.addSystemGuid();
    }

    public Map<String, Namespace> namespaces() {
        return this.namespaces;
    }

    public Namespace createNamespace(String name) {
        assert (name != null);
        assert (!this.namespaces.containsKey(name));
        Namespace namespace = new Namespace(name);
        this.namespaces.put(name, namespace);
        return namespace;
    }

    public Namespace getOrCreateNamespace(String name) {
        assert (name != null);
        Namespace namespace = this.namespaces.get(name);
        if (namespace == null) {
            namespace = this.createNamespace(name);
        }
        return namespace;
    }

    public Stream<Type> types() {
        return this.typesByDefinitionIndex.values().stream();
    }

    public Type getType(String namespace, String name) {
        Namespace ns;
        if (namespace != null) {
            ns = this.namespaces.get(namespace);
            if (ns == null) {
                return null;
            }
        } else {
            ns = this.unnamedNamespace;
        }
        return ns.types().get(name);
    }

    public Primitive getPrimitive(PrimitiveKind kind) {
        return this.primitivesByKind.get((Object)kind);
    }

    public Type getTypeByTypeDefIndex(int typeDefIndex) {
        return this.typesByDefinitionIndex.get(typeDefIndex);
    }

    public void addType(Type type, boolean nameIsUnique) {
        Struct struct;
        assert (type.typeDefIndex() != 0);
        assert (!this.typesByDefinitionIndex.containsKey(type.typeDefIndex()));
        this.typesByDefinitionIndex.put(type.typeDefIndex(), type);
        if (type instanceof Struct && (struct = (Struct)type).enclosingType() != null) {
            struct.enclosingType().addNestedType(type);
        } else {
            assert (!nameIsUnique || !type.namespace().types().containsKey(type.name()));
            type.namespace().addType(type);
        }
    }

    public void removeType(Type type, boolean nameExists) {
        Struct struct;
        assert (type.typeDefIndex() != 0);
        assert (this.typesByDefinitionIndex.containsKey(type.typeDefIndex()));
        Type removed = this.typesByDefinitionIndex.remove(type.typeDefIndex());
        assert (removed != null);
        assert (!(type instanceof Struct && (struct = (Struct)type).enclosingType() != null));
        if (nameExists || type.namespace().types().containsKey(type.name())) {
            type.namespace().removeType(type);
        }
    }

    public Stream<Method> methods() {
        return this.methodsByMethodDefIndex.values().stream();
    }

    public void addMethod(Method method) {
        assert (!method.namespace().methods().containsKey(method.name()));
        method.namespace().addMethod(method);
        assert (method.methodDefIndex() != 0);
        assert (!this.methodsByMethodDefIndex.containsKey(method.methodDefIndex()));
        this.methodsByMethodDefIndex.put(method.methodDefIndex(), method);
    }

    public Stream<ConstantValue> constants() {
        return this.namespaces.values().stream().flatMap(namespace -> namespace.constants().values().stream());
    }

    public Pointer makePointerFor(Type type) {
        return this.pointersByType.computeIfAbsent(type, it -> new Pointer(it.name() + "*", (Type)it));
    }

    public TypeAlias makeAliasFor(int typeDefIndex, String name, Namespace namespace) {
        return this.aliasesByTypeDefIndex.computeIfAbsent(typeDefIndex, it -> new TypeAlias(name, namespace, (int)it));
    }

    public List<Type> findStructs(Set<String> names) {
        return this.types().filter(type -> type instanceof Struct && names.contains(type.nativeName())).toList();
    }

    public List<Type> findEnums(Set<String> names) {
        return this.types().filter(type -> type instanceof EnumType && names.contains(type.nativeName())).toList();
    }

    public List<EnumType> findEnumWithMember(String memberName) {
        return this.types().filter(type -> {
            EnumType enumType;
            return type instanceof EnumType && (enumType = (EnumType)type).getMember(memberName) != null;
        }).map(EnumType.class::cast).toList();
    }

    public List<Type> findDelegates(Set<String> names) {
        return this.types().filter(type -> type instanceof Delegate && names.contains(type.nativeName())).toList();
    }

    public List<Type> findComInterfaces(Set<String> names) {
        return this.types().filter(type -> type instanceof ComInterface && names.contains(type.nativeName())).toList();
    }

    public List<Method> findFunctions(Set<String> names) {
        return this.methods().filter(method -> names.contains(method.nativeName())).toList();
    }

    public List<ConstantValue> findConstants(Set<String> names) {
        return this.constants().filter(constant -> names.contains(constant.name())).toList();
    }

    private void addSystemGuid() {
        Namespace systemNamespace = this.createNamespace("System");
        Struct guidType = new Struct("GUID", systemNamespace, 9999999, false, 0, 0, null, null, null);
        ArrayList<Member> members = new ArrayList<Member>();
        members.add(new Member("Data1", 0, this.getPrimitive(PrimitiveKind.UINT32), null));
        members.add(new Member("Data2", 0, this.getPrimitive(PrimitiveKind.UINT16), null));
        members.add(new Member("Data3", 0, this.getPrimitive(PrimitiveKind.UINT16), null));
        members.add(new Member("Data4", 0, new Array("Data4[]", null, 0, this.getPrimitive(PrimitiveKind.BYTE), 8), null));
        guidType.setMembers(members);
        guidType.setName("Guid");
        this.addType(guidType, true);
    }

    private static Map<PrimitiveKind, Primitive> buildPrimitiveTypes(Namespace namespace) {
        List<Primitive> primitives = Arrays.stream(PrimitiveKind.values()).map(kind -> new Primitive((PrimitiveKind)((Object)kind), namespace)).toList();
        primitives.forEach(namespace::addType);
        return primitives.stream().collect(Collectors.toMap(Primitive::kind, Function.identity()));
    }
}

