/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.windowsapi;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.HashSet;
import java.util.Set;
import net.codecrete.windowsapi.WindowsApiException;
import net.codecrete.windowsapi.events.Event;
import net.codecrete.windowsapi.events.EventListener;
import net.codecrete.windowsapi.metadata.Metadata;
import net.codecrete.windowsapi.winmd.MetadataBuilder;
import net.codecrete.windowsapi.writer.CodeWriter;
import net.codecrete.windowsapi.writer.GenerationException;
import net.codecrete.windowsapi.writer.Scope;

public class WindowsApiRun {
    private Path outputDirectory;
    private String basePackage = "";
    private EventListener eventListener = new NullEventListener();
    private Set<String> structs = new HashSet<String>();
    private Set<String> functions = new HashSet<String>();
    private Set<String> enumerations = new HashSet<String>();
    private Set<String> callbackFunctions = new HashSet<String>();
    private Set<String> comInterfaces = new HashSet<String>();
    private Set<String> constants = new HashSet<String>();

    public Path getOutputDirectory() {
        return this.outputDirectory;
    }

    public void setOutputDirectory(Path outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public Set<String> getStructs() {
        return this.structs;
    }

    public void setStructs(Set<String> structs) {
        this.structs = structs;
    }

    public Set<String> getFunctions() {
        return this.functions;
    }

    public void setFunctions(Set<String> functions) {
        this.functions = functions;
    }

    public Set<String> getEnumerations() {
        return this.enumerations;
    }

    public void setEnumerations(Set<String> enumerations) {
        this.enumerations = enumerations;
    }

    public Set<String> getCallbackFunctions() {
        return this.callbackFunctions;
    }

    public void setCallbackFunctions(Set<String> callbackFunctions) {
        this.callbackFunctions = callbackFunctions;
    }

    public Set<String> getComInterfaces() {
        return this.comInterfaces;
    }

    public void setComInterfaces(Set<String> comInterfaces) {
        this.comInterfaces = comInterfaces;
    }

    public Set<String> getConstants() {
        return this.constants;
    }

    public void setConstants(Set<String> constants) {
        this.constants = constants;
    }

    public EventListener getEventListener() {
        return this.eventListener;
    }

    public void setEventListener(EventListener eventListener) {
        this.eventListener = eventListener;
    }

    public void generateCode() {
        this.generate(false);
    }

    public void dryRun() {
        this.generate(true);
    }

    private void generate(boolean isDryRun) {
        if (!this.isAnyWork()) {
            return;
        }
        Metadata metadata = MetadataBuilder.load();
        Scope scope = new Scope(metadata, this.eventListener);
        scope.addStructs(this.structs);
        scope.addEnums(this.enumerations);
        scope.addFunctions(this.functions);
        scope.addCallbackFunctions(this.callbackFunctions);
        scope.addComInterfaces(this.comInterfaces);
        scope.addConstants(this.constants);
        if (scope.hasInvalidArguments()) {
            throw new WindowsApiException("Invalid arguments specified for Windows API code generation");
        }
        scope.buildTransitiveScope();
        CodeWriter writer = new CodeWriter(metadata, this.outputDirectory, this.eventListener);
        writer.setDryRun(isDryRun);
        writer.setBasePackage(this.basePackage);
        writer.write(scope);
    }

    private boolean isAnyWork() {
        return !this.functions.isEmpty() || !this.structs.isEmpty() || !this.constants.isEmpty() || !this.enumerations.isEmpty() || !this.callbackFunctions.isEmpty() || !this.comInterfaces.isEmpty();
    }

    public void createDirectory(Path path) {
        File directory = path.toFile();
        if (directory.exists()) {
            return;
        }
        if (!directory.mkdirs()) {
            throw new GenerationException("Unable to create directory " + String.valueOf(path));
        }
        this.eventListener.onEvent(new Event.DirectoryCreated(path));
    }

    public void cleanOutputDirectory() {
        if (!this.outputDirectory.toFile().exists()) {
            return;
        }
        try {
            Files.walkFileTree(this.outputDirectory, (FileVisitor<? super Path>)new FileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) {
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                    Files.delete(file);
                    return FileVisitResult.CONTINUE;
                }

                @Override
                public FileVisitResult visitFileFailed(Path file, IOException exc) {
                    throw new UncheckedIOException("Unable to clean output directory " + String.valueOf(WindowsApiRun.this.outputDirectory), exc);
                }

                @Override
                public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                    if (!dir.equals(WindowsApiRun.this.outputDirectory)) {
                        Files.delete(dir);
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
            this.eventListener.onEvent(new Event.DirectoryCleaned(this.outputDirectory));
        }
        catch (IOException exc) {
            throw new UncheckedIOException("Unable to clean output directory " + String.valueOf(this.outputDirectory), exc);
        }
    }

    static class NullEventListener
    implements EventListener {
        NullEventListener() {
        }

        @Override
        public void onEvent(Event event) {
        }
    }
}

