/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.qrbill.canvas;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import net.codecrete.qrbill.canvas.AbstractCanvas;
import net.codecrete.qrbill.canvas.ByteArrayResult;
import net.codecrete.qrbill.canvas.Canvas;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.util.Matrix;

public class PDFCanvas
extends AbstractCanvas
implements ByteArrayResult {
    public static final int LAST_PAGE = -1;
    public static final int NEW_PAGE_AT_END = -2;
    private static final String PDF_FONT = "Helvetica";
    private PDDocument document;
    private PDPageContentStream contentStream;
    private final boolean isContentStreamOwned;
    private int lastStrokingColor = 0;
    private int lastNonStrokingColor = 0;
    private double lastLineWidth = 1.0;
    private Canvas.LineStyle lastLineStyle = Canvas.LineStyle.Solid;

    public PDFCanvas(double width, double height) throws IOException {
        this.setupFontMetrics(PDF_FONT);
        this.document = new PDDocument();
        this.document.getDocumentInformation().setTitle("Swiss QR Bill");
        PDPage page = new PDPage(new PDRectangle((float)(width * 2.834645669291339), (float)(height * 2.834645669291339)));
        this.document.addPage(page);
        this.contentStream = new PDPageContentStream(this.document, page, PDPageContentStream.AppendMode.OVERWRITE, true);
        this.isContentStreamOwned = true;
        this.initGraphicsState();
    }

    public PDFCanvas(Path path, int pageNo) throws IOException {
        this.setupFontMetrics(PDF_FONT);
        this.document = PDDocument.load((InputStream)Files.newInputStream(path, new OpenOption[0]));
        this.preparePage(this.document, pageNo);
        this.isContentStreamOwned = true;
        this.initGraphicsState();
    }

    public PDFCanvas(byte[] pdfDocument, int pageNo) throws IOException {
        this.setupFontMetrics(PDF_FONT);
        this.document = PDDocument.load((byte[])pdfDocument);
        this.preparePage(this.document, pageNo);
        this.isContentStreamOwned = true;
        this.initGraphicsState();
    }

    public PDFCanvas(PDDocument pdfDocument, int pageNo) throws IOException {
        this.setupFontMetrics(PDF_FONT);
        this.preparePage(pdfDocument, pageNo);
        this.isContentStreamOwned = true;
        this.initGraphicsState();
    }

    public PDFCanvas(PDPageContentStream contentStream) {
        this.setupFontMetrics(PDF_FONT);
        this.contentStream = contentStream;
        this.isContentStreamOwned = false;
        try {
            this.initGraphicsState();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void preparePage(PDDocument doc, int pageNo) throws IOException {
        if (pageNo == -2) {
            PDPage page = new PDPage(new PDRectangle(595.2756f, 841.8898f));
            doc.addPage(page);
            this.contentStream = new PDPageContentStream(doc, page, PDPageContentStream.AppendMode.OVERWRITE, true, true);
        } else {
            if (pageNo == -1) {
                pageNo = doc.getNumberOfPages() - 1;
            }
            PDPage page = doc.getPage(pageNo);
            this.contentStream = new PDPageContentStream(doc, page, PDPageContentStream.AppendMode.APPEND, true, true);
        }
    }

    private void initGraphicsState() throws IOException {
        if (!this.isContentStreamOwned) {
            this.contentStream.saveGraphicsState();
            this.contentStream.setStrokingColor(0.0f, 0.0f, 0.0f);
            this.contentStream.setNonStrokingColor(0.0f, 0.0f, 0.0f);
            this.contentStream.setLineWidth(1.0f);
            this.contentStream.setLineJoinStyle(0);
            this.contentStream.setLineCapStyle(0);
            this.contentStream.setLineDashPattern(new float[0], 0.0f);
            this.contentStream.setMiterLimit(10.0f);
        }
        this.contentStream.saveGraphicsState();
    }

    @Override
    public void setTransformation(double translateX, double translateY, double rotate, double scaleX, double scaleY) throws IOException {
        translateX *= 2.834645669291339;
        translateY *= 2.834645669291339;
        this.contentStream.restoreGraphicsState();
        this.lastStrokingColor = 0;
        this.lastNonStrokingColor = 0;
        this.lastLineWidth = 1.0;
        this.contentStream.saveGraphicsState();
        Matrix matrix = new Matrix();
        matrix.translate((float)translateX, (float)translateY);
        if (rotate != 0.0) {
            matrix.rotate(rotate);
        }
        if (scaleX != 1.0 || scaleY != 1.0) {
            matrix.scale((float)scaleX, (float)scaleY);
        }
        this.contentStream.transform(matrix);
    }

    @Override
    public void putText(String text, double x, double y, int fontSize, boolean isBold) throws IOException {
        this.contentStream.setFont((PDFont)(isBold ? PDType1Font.HELVETICA_BOLD : PDType1Font.HELVETICA), (float)fontSize);
        this.contentStream.beginText();
        this.contentStream.newLineAtOffset((float)(x *= 2.834645669291339), (float)(y *= 2.834645669291339));
        this.contentStream.showText(text);
        this.contentStream.endText();
    }

    @Override
    public void putTextLines(String[] lines, double x, double y, int fontSize, double leading) throws IOException {
        float lineHeight = (float)((this.fontMetrics.getLineHeight(fontSize) + leading) * 2.834645669291339);
        this.contentStream.setFont((PDFont)PDType1Font.HELVETICA, (float)fontSize);
        this.contentStream.beginText();
        this.contentStream.newLineAtOffset((float)(x *= 2.834645669291339), (float)(y *= 2.834645669291339));
        boolean isFirstLine = true;
        for (String line : lines) {
            if (isFirstLine) {
                isFirstLine = false;
            } else {
                this.contentStream.newLineAtOffset(0.0f, -lineHeight);
            }
            this.contentStream.showText(line);
        }
        this.contentStream.endText();
    }

    @Override
    public void startPath() {
    }

    @Override
    public void moveTo(double x, double y) throws IOException {
        this.contentStream.moveTo((float)(x *= 2.834645669291339), (float)(y *= 2.834645669291339));
    }

    @Override
    public void lineTo(double x, double y) throws IOException {
        this.contentStream.lineTo((float)(x *= 2.834645669291339), (float)(y *= 2.834645669291339));
    }

    @Override
    public void cubicCurveTo(double x1, double y1, double x2, double y2, double x, double y) throws IOException {
        this.contentStream.curveTo((float)(x1 *= 2.834645669291339), (float)(y1 *= 2.834645669291339), (float)(x2 *= 2.834645669291339), (float)(y2 *= 2.834645669291339), (float)(x *= 2.834645669291339), (float)(y *= 2.834645669291339));
    }

    @Override
    public void addRectangle(double x, double y, double width, double height) throws IOException {
        this.contentStream.addRect((float)(x *= 2.834645669291339), (float)(y *= 2.834645669291339), (float)(width *= 2.834645669291339), (float)(height *= 2.834645669291339));
    }

    @Override
    public void closeSubpath() throws IOException {
        this.contentStream.closePath();
    }

    @Override
    public void fillPath(int color, boolean smoothing) throws IOException {
        if (color != this.lastNonStrokingColor) {
            this.lastNonStrokingColor = color;
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            this.contentStream.setNonStrokingColor((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
        }
        this.contentStream.fill();
    }

    @Override
    public void strokePath(double strokeWidth, int color, Canvas.LineStyle lineStyle, boolean smoothing) throws IOException {
        if (color != this.lastStrokingColor) {
            this.lastStrokingColor = color;
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color & 0xFF;
            this.contentStream.setStrokingColor((float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f);
        }
        if (lineStyle != this.lastLineStyle || lineStyle != Canvas.LineStyle.Solid && strokeWidth != this.lastLineWidth) {
            float[] pattern;
            this.lastLineStyle = lineStyle;
            switch (lineStyle) {
                case Dashed: {
                    pattern = new float[]{4.0f * (float)strokeWidth};
                    break;
                }
                case Dotted: {
                    pattern = new float[]{0.0f, 3.0f * (float)strokeWidth};
                    break;
                }
                default: {
                    pattern = new float[]{};
                }
            }
            this.contentStream.setLineCapStyle(lineStyle == Canvas.LineStyle.Dotted ? 1 : 0);
            this.contentStream.setLineDashPattern(pattern, 0.0f);
        }
        if (strokeWidth != this.lastLineWidth) {
            this.lastLineWidth = strokeWidth;
            this.contentStream.setLineWidth((float)strokeWidth);
        }
        this.contentStream.stroke();
    }

    @Override
    public byte[] toByteArray() throws IOException {
        if (this.document == null) {
            throw new IllegalStateException("toByteArray() may only be called if the PDF document has been opened/created by this instance. Use PDFBox methods instead to save the PDF document.");
        }
        this.closeContentStream();
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            this.document.save((OutputStream)os);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
    }

    public void writeTo(OutputStream os) throws IOException {
        if (this.document == null) {
            throw new IllegalStateException("writeTo() may only be called if the PDF document has been opened/created by this instance. Use PDFBox methods instead to save the PDF document.");
        }
        this.closeContentStream();
        this.document.save(os);
    }

    public void saveAs(Path path) throws IOException {
        if (this.document == null) {
            throw new IllegalStateException("saveAs() may only be called if the PDF document has been opened/created by this instance. Use PDFBox methods instead to save the PDF document.");
        }
        this.closeContentStream();
        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
            this.document.save(os);
        }
    }

    @Override
    public void close() throws IOException {
        this.closeContentStream();
        if (this.document != null) {
            this.document.close();
            this.document = null;
        }
    }

    private void closeContentStream() throws IOException {
        if (this.contentStream != null) {
            this.contentStream.restoreGraphicsState();
            if (this.isContentStreamOwned) {
                this.contentStream.close();
            } else {
                this.contentStream.restoreGraphicsState();
                this.contentStream.restoreGraphicsState();
            }
            this.contentStream = null;
        }
    }
}

