/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.qrbill.generator;

import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import net.codecrete.qrbill.canvas.Canvas;
import net.codecrete.qrbill.generator.Address;
import net.codecrete.qrbill.generator.AlternativeScheme;
import net.codecrete.qrbill.generator.Bill;
import net.codecrete.qrbill.generator.MultilingualText;
import net.codecrete.qrbill.generator.OutputSize;
import net.codecrete.qrbill.generator.Payments;
import net.codecrete.qrbill.generator.QRCode;
import net.codecrete.qrbill.generator.SeparatorType;

class BillLayout {
    private static final double PT_TO_MM = 0.35277777777777775;
    private static final double MM_TO_PT = 2.834645669291339;
    private static final int FONT_SIZE_TITLE = 11;
    private static final double SLIP_WIDTH = 210.0;
    private static final double SLIP_HEIGHT = 105.0;
    private static final double MARGIN = 5.0;
    private static final double RECEIPT_WIDTH = 62.0;
    private static final double RECEIPT_TEXT_WIDTH = 52.0;
    private static final double PAYMENT_PART_WIDTH = 148.0;
    private static final double PP_AMOUNT_SECTION_WIDTH = 46.0;
    private static final double PP_INFO_SECTION_WIDTH = 87.0;
    private static final double AMOUNT_SECTION_TOP = 37.0;
    private static final double BOX_TOP_PADDING = 0.7055555555555555;
    private static final double DEBTOR_BOX_WIDTH_PP = 65.0;
    private static final double DEBTOR_BOX_HEIGHT_PP = 25.0;
    private static final double DEBTOR_BOX_WIDTH_RC = 52.0;
    private static final double DEBTOR_BOX_HEIGHT_RC = 20.0;
    private final Bill bill;
    private final QRCode qrCode;
    private final Canvas graphics;
    private final double additionalLeftMargin;
    private final double additionalRightMargin;
    private String accountPayableTo;
    private String reference;
    private String additionalInfo;
    private String payableBy;
    private String amount;
    private String[] accountPayableToLines;
    private String[] additionalInfoLines;
    private String[] payableByLines;
    private double yPos;
    private int labelFontSize;
    private double labelAscender;
    private int textFontSize;
    private double textAscender;
    private double lineSpacing;
    private double extraSpacing;
    private static final double CORNER_STROKE_WIDTH = 0.75;
    private static final DecimalFormat amountDisplayFormat = new DecimalFormat("###,##0.00");

    BillLayout(Bill bill, Canvas graphics) {
        this.bill = bill;
        this.qrCode = new QRCode(bill);
        this.graphics = graphics;
        this.additionalLeftMargin = Math.min(Math.max(bill.getFormat().getMarginLeft(), 5.0), 12.0) - 5.0;
        this.additionalRightMargin = Math.min(Math.max(bill.getFormat().getMarginRight(), 5.0), 12.0) - 5.0;
    }

    void draw() throws IOException {
        boolean isTooTight;
        this.prepareText();
        int PP_LABEL_PREF_FONT_SIZE = 8;
        int PP_TEXT_PREF_FONT_SIZE = 10;
        int PP_TEXT_MIN_FONT_SIZE = 8;
        this.labelFontSize = 8;
        this.textFontSize = 10;
        while (true) {
            this.breakLines(87.0 - this.additionalRightMargin);
            isTooTight = this.computePaymentPartSpacing();
            if (!isTooTight || this.textFontSize == 8) break;
            --this.labelFontSize;
            --this.textFontSize;
        }
        this.drawPaymentPart();
        int RC_LABEL_PREF_FONT_SIZE = 6;
        int RC_TEXT_PREF_FONT_SIZE = 8;
        this.labelFontSize = 6;
        this.textFontSize = 8;
        double receiptTextWidthAdapted = 52.0 - this.additionalLeftMargin;
        this.breakLines(receiptTextWidthAdapted);
        isTooTight = this.computeReceiptSpacing();
        if (isTooTight) {
            this.prepareReducedReceiptText(false);
            this.breakLines(receiptTextWidthAdapted);
            isTooTight = this.computeReceiptSpacing();
        }
        if (isTooTight) {
            this.prepareReducedReceiptText(true);
            this.breakLines(receiptTextWidthAdapted);
            this.computeReceiptSpacing();
        }
        this.drawReceipt();
        this.drawBorder();
    }

    private void drawPaymentPart() throws IOException {
        double QR_CODE_BOTTOM = 42.0;
        this.graphics.setTransformation(67.0, 0.0, 0.0, 1.0, 1.0);
        this.yPos = 100.0 - this.graphics.getAscender(11);
        this.graphics.putText(this.getText("payment_part"), 0.0, this.yPos, 11, true);
        this.qrCode.draw(this.graphics, 67.0, 42.0);
        this.drawPaymentPartAmountSection();
        this.drawPaymentPartInformationSection();
        this.drawFurtherInformationSection();
    }

    private void drawPaymentPartAmountSection() throws IOException {
        double CURRENCY_WIDTH_PP = 15.0;
        double AMOUNT_BOX_WIDTH_PP = 40.0;
        double AMOUNT_BOX_HEIGHT_PP = 15.0;
        this.graphics.setTransformation(67.0, 0.0, 0.0, 1.0, 1.0);
        double y = 37.0 - this.labelAscender;
        String label = this.getText("currency");
        this.graphics.putText(label, 0.0, y, this.labelFontSize, true);
        this.graphics.putText(this.bill.getCurrency(), 0.0, y -= (double)(this.textFontSize + 3) * 0.35277777777777775, this.textFontSize, false);
        y = 37.0 - this.labelAscender;
        label = this.getText("amount");
        this.graphics.putText(label, 15.0, y, this.labelFontSize, true);
        y -= (double)(this.textFontSize + 3) * 0.35277777777777775;
        if (this.amount != null) {
            this.graphics.putText(this.amount, 15.0, y, this.textFontSize, false);
        } else {
            this.drawCorners(11.0, y -= -this.textAscender + 15.0, 40.0, 15.0);
        }
    }

    private void drawPaymentPartInformationSection() throws IOException {
        this.graphics.setTransformation(118.0, 0.0, 0.0, 1.0, 1.0);
        this.yPos = 100.0 - this.labelAscender;
        this.drawLabelAndTextLines("account_payable_to", this.accountPayableToLines);
        if (this.reference != null) {
            this.drawLabelAndText("reference", this.reference);
        }
        if (this.additionalInfo != null) {
            this.drawLabelAndTextLines("additional_info", this.additionalInfoLines);
        }
        if (this.payableBy != null) {
            this.drawLabelAndTextLines("payable_by", this.payableByLines);
        } else {
            this.drawLabel("payable_by_name_addr");
            this.yPos -= -this.textAscender + 0.7055555555555555;
            this.yPos -= 25.0;
            this.drawCorners(0.0, this.yPos, 65.0, 25.0);
        }
    }

    private void drawFurtherInformationSection() throws IOException {
        int FONT_SIZE = 7;
        int LINE_SPACING = 8;
        double FURTHER_INFORMATION_SECTION_TOP = 15.0;
        if (this.bill.getAlternativeSchemes() == null || this.bill.getAlternativeSchemes().length == 0) {
            return;
        }
        this.graphics.setTransformation(67.0, 0.0, 0.0, 1.0, 1.0);
        double y = 15.0 - this.graphics.getAscender(7);
        double maxWidth = 138.0 - this.additionalRightMargin;
        for (AlternativeScheme scheme : this.bill.getAlternativeSchemes()) {
            String boldText = String.format("%s: ", scheme.getName());
            double boldTextWidth = this.graphics.getTextWidth(boldText, 7, true);
            this.graphics.putText(boldText, 0.0, y, 7, true);
            String normalText = this.truncateText(scheme.getInstruction(), maxWidth - boldTextWidth, 7);
            this.graphics.putText(normalText, boldTextWidth, y, 7, false);
            y -= 2.822222222222222;
        }
    }

    private void drawReceipt() throws IOException {
        this.graphics.setTransformation(5.0 + this.additionalLeftMargin, 0.0, 0.0, 1.0, 1.0);
        this.yPos = 100.0 - this.graphics.getAscender(11);
        this.graphics.putText(this.getText("receipt"), 0.0, this.yPos, 11, true);
        this.drawReceiptInformationSection();
        this.drawReceiptAmountSection();
        this.drawReceiptAcceptancePointSection();
    }

    private void drawReceiptInformationSection() throws IOException {
        double TITLE_HEIGHT = 7.0;
        this.yPos = 93.0 - this.labelAscender;
        this.drawLabelAndTextLines("account_payable_to", this.accountPayableToLines);
        if (this.reference != null) {
            this.drawLabelAndText("reference", this.reference);
        }
        if (this.payableBy != null) {
            this.drawLabelAndTextLines("payable_by", this.payableByLines);
        } else {
            this.drawLabel("payable_by_name_addr");
            this.yPos -= -this.textAscender + 0.7055555555555555;
            this.yPos -= 20.0;
            this.drawCorners(0.0, this.yPos, 52.0 - this.additionalLeftMargin, 20.0);
        }
    }

    private void drawReceiptAmountSection() throws IOException {
        double CURRENCY_WIDTH_RC = 12.0;
        double AMOUNT_BOX_WIDTH_RC = 30.0;
        double AMOUNT_BOX_HEIGHT_RC = 10.0;
        double y = 37.0 - this.labelAscender;
        String label = this.getText("currency");
        this.graphics.putText(label, 0.0, y, this.labelFontSize, true);
        this.graphics.putText(this.bill.getCurrency(), 0.0, y -= (double)(this.textFontSize + 3) * 0.35277777777777775, this.textFontSize, false);
        y = 37.0 - this.labelAscender;
        label = this.getText("amount");
        this.graphics.putText(label, 12.0, y, this.labelFontSize, true);
        if (this.amount != null) {
            this.graphics.putText(this.amount, 12.0, y -= (double)(this.textFontSize + 3) * 0.35277777777777775, this.textFontSize, false);
        } else {
            this.drawCorners(22.0, 27.0, 30.0 - this.additionalLeftMargin, 10.0);
        }
    }

    private void drawReceiptAcceptancePointSection() throws IOException {
        double ACCEPTANCE_POINT_SECTION_TOP = 23.0;
        String label = this.getText("acceptance_point");
        double y = 23.0 - this.labelAscender;
        double w = this.graphics.getTextWidth(label, this.labelFontSize, true);
        this.graphics.putText(label, 52.0 - this.additionalLeftMargin - w, y, this.labelFontSize, true);
    }

    private boolean computePaymentPartSpacing() {
        double PP_INFO_SECTION_MAX_HEIGHT = 85.0;
        int numTextLines = 0;
        int numExtraLines = 0;
        double fixedHeight = 0.0;
        numTextLines += 1 + this.accountPayableToLines.length;
        if (this.reference != null) {
            ++numExtraLines;
            numTextLines += 2;
        }
        if (this.additionalInfo != null) {
            ++numExtraLines;
            numTextLines += 1 + this.additionalInfoLines.length;
        }
        ++numExtraLines;
        if (this.payableBy != null) {
            numTextLines += 1 + this.payableByLines.length;
        } else {
            ++numTextLines;
            fixedHeight += 25.0;
        }
        if (this.bill.getAlternativeSchemes() != null && this.bill.getAlternativeSchemes().length > 0) {
            ++numExtraLines;
        }
        return this.computeSpacing(85.0, fixedHeight, numTextLines, numExtraLines);
    }

    private boolean computeReceiptSpacing() {
        double RECEIPT_MAX_HEIGHT = 56.0;
        int numTextLines = 0;
        int numExtraLines = 0;
        double fixedHeight = 0.0;
        numTextLines += 1 + this.accountPayableToLines.length;
        if (this.reference != null) {
            ++numExtraLines;
            numTextLines += 2;
        }
        ++numExtraLines;
        if (this.payableBy != null) {
            numTextLines += 1 + this.payableByLines.length;
        } else {
            ++numTextLines;
            fixedHeight += 20.0;
        }
        return this.computeSpacing(56.0, fixedHeight, numTextLines, ++numExtraLines);
    }

    private boolean computeSpacing(double maxHeight, double fixedHeight, int numTextLines, int numExtraLines) {
        this.lineSpacing = (double)(this.textFontSize + 1) * 0.35277777777777775;
        this.extraSpacing = (maxHeight - fixedHeight - (double)numTextLines * this.lineSpacing) / (double)numExtraLines;
        this.extraSpacing = Math.min(Math.max(this.extraSpacing, 0.0), this.lineSpacing);
        this.labelAscender = this.graphics.getAscender(this.labelFontSize);
        this.textAscender = this.graphics.getAscender(this.textFontSize);
        return this.extraSpacing / this.lineSpacing < 0.8;
    }

    void drawBorder() throws IOException {
        double lineWidth;
        Canvas.LineStyle lineStyle;
        SeparatorType separatorType = this.bill.getFormat().getSeparatorType();
        OutputSize outputSize = this.bill.getFormat().getOutputSize();
        if (separatorType == SeparatorType.NONE) {
            return;
        }
        boolean hasScissors = separatorType == SeparatorType.SOLID_LINE_WITH_SCISSORS || separatorType == SeparatorType.DASHED_LINE_WITH_SCISSORS || separatorType == SeparatorType.DOTTED_LINE_WITH_SCISSORS;
        switch (separatorType) {
            case DASHED_LINE: 
            case DASHED_LINE_WITH_SCISSORS: {
                lineStyle = Canvas.LineStyle.Dashed;
                lineWidth = 0.6;
                break;
            }
            case DOTTED_LINE: 
            case DOTTED_LINE_WITH_SCISSORS: {
                lineStyle = Canvas.LineStyle.Dotted;
                lineWidth = 0.75;
                break;
            }
            default: {
                lineStyle = Canvas.LineStyle.Solid;
                lineWidth = 0.5;
            }
        }
        this.graphics.setTransformation(0.0, 0.0, 0.0, 1.0, 1.0);
        this.graphics.startPath();
        this.graphics.moveTo(62.0, 0.0);
        if (hasScissors) {
            this.graphics.lineTo(62.0, 97.0);
            this.graphics.moveTo(62.0, 100.0);
        }
        this.graphics.lineTo(62.0, 105.0);
        if (outputSize != OutputSize.QR_BILL_ONLY) {
            this.graphics.moveTo(0.0, 105.0);
            if (hasScissors) {
                this.graphics.lineTo(5.0, 105.0);
                this.graphics.moveTo(8.0, 105.0);
            }
            this.graphics.lineTo(210.0, 105.0);
        }
        this.graphics.strokePath(lineWidth, 0, lineStyle, false);
        if (hasScissors) {
            this.drawScissors(62.0, 100.0, 0.0);
            if (outputSize != OutputSize.QR_BILL_ONLY) {
                this.drawScissors(5.0, 105.0, 1.5707963267948966);
            }
        }
    }

    private void drawScissors(double x, double y, double angle) throws IOException {
        this.drawScissorsBlade(x, y, 3.0, angle, false);
        this.drawScissorsBlade(x, y, 3.0, angle, true);
    }

    private void drawScissorsBlade(double x, double y, double size, double angle, boolean mirrored) throws IOException {
        double scale = size / 476.0;
        double xOffset = 0.36 * size;
        double yOffset = -1.05 * size;
        AffineTransform transform = new AffineTransform();
        transform.translate(x, y);
        transform.rotate(angle);
        transform.translate(mirrored ? xOffset : -xOffset, yOffset);
        transform.scale(mirrored ? -scale : scale, scale);
        this.graphics.setTransformation(transform.getTranslateX(), transform.getTranslateY(), angle, mirrored ? -scale : scale, scale);
        this.graphics.startPath();
        this.graphics.moveTo(46.48, 126.784);
        this.graphics.cubicCurveTo(34.824, 107.544, 28.0, 87.924, 28.0, 59.0);
        this.graphics.cubicCurveTo(28.0, 36.88, 33.387, 16.436, 42.507, -0.124);
        this.graphics.lineTo(242.743, 326.63);
        this.graphics.cubicCurveTo(246.359, 332.53, 254.836, 334.776, 265.31, 328.678);
        this.graphics.cubicCurveTo(276.973, 321.89, 290.532, 318.0, 305.0, 318.0);
        this.graphics.cubicCurveTo(348.63, 318.0, 384.0, 353.37, 384.0, 397.0);
        this.graphics.cubicCurveTo(384.0, 440.63, 348.63, 476.0, 305.0, 476.0);
        this.graphics.cubicCurveTo(278.066, 476.0, 254.28, 462.521, 240.02, 441.94);
        this.graphics.lineTo(46.48, 126.785);
        this.graphics.closeSubpath();
        this.graphics.moveTo(303.5, 446.0);
        this.graphics.cubicCurveTo(330.286, 446.0, 352.0, 424.286, 352.0, 397.5);
        this.graphics.cubicCurveTo(352.0, 370.714, 330.286, 349.0, 303.5, 349.0);
        this.graphics.cubicCurveTo(276.714, 349.0, 255.0, 370.714, 255.0, 397.5);
        this.graphics.cubicCurveTo(255.0, 424.286, 276.714, 446.0, 303.5, 446.0);
        this.graphics.closeSubpath();
        this.graphics.fillPath(0, true);
    }

    private void drawLabel(String labelKey) throws IOException {
        this.graphics.putText(this.getText(labelKey), 0.0, this.yPos, this.labelFontSize, true);
        this.yPos -= this.lineSpacing;
    }

    private void drawLabelAndText(String labelKey, String text) throws IOException {
        this.drawLabel(labelKey);
        this.graphics.putText(text, 0.0, this.yPos, this.textFontSize, false);
        this.yPos -= this.lineSpacing + this.extraSpacing;
    }

    private void drawLabelAndTextLines(String labelKey, String[] textLines) throws IOException {
        this.drawLabel(labelKey);
        double leading = this.lineSpacing - this.graphics.getLineHeight(this.textFontSize);
        this.graphics.putTextLines(textLines, 0.0, this.yPos, this.textFontSize, leading);
        this.yPos -= (double)textLines.length * this.lineSpacing + this.extraSpacing;
    }

    private void prepareText() {
        String account = Payments.formatIBAN(this.bill.getAccount());
        this.accountPayableTo = account + "\n" + BillLayout.formatAddressForDisplay(this.bill.getCreditor(), this.isCreditorWithCountryCode());
        this.reference = BillLayout.formatReferenceNumber(this.bill.getReference());
        String info = this.bill.getUnstructuredMessage();
        if (this.bill.getBillInformation() != null) {
            info = info == null ? this.bill.getBillInformation() : info + "\n" + this.bill.getBillInformation();
        }
        if (info != null) {
            this.additionalInfo = info;
        }
        if (this.bill.getDebtor() != null) {
            this.payableBy = BillLayout.formatAddressForDisplay(this.bill.getDebtor(), this.isDebtorWithCountryCode());
        }
        if (this.bill.getAmount() != null) {
            this.amount = BillLayout.formatAmountForDisplay(this.bill.getAmount());
        }
    }

    private void prepareReducedReceiptText(boolean reduceBoth) {
        if (reduceBoth) {
            String account = Payments.formatIBAN(this.bill.getAccount());
            this.accountPayableTo = account + "\n" + BillLayout.formatAddressForDisplay(this.createReducedAddress(this.bill.getCreditor()), this.isCreditorWithCountryCode());
        }
        if (this.bill.getDebtor() != null) {
            this.payableBy = BillLayout.formatAddressForDisplay(this.createReducedAddress(this.bill.getDebtor()), this.isDebtorWithCountryCode());
        }
    }

    private Address createReducedAddress(Address address) {
        Address reducedAddress = new Address();
        reducedAddress.setName(address.getName());
        reducedAddress.setCountryCode(address.getCountryCode());
        if (address.getType() == Address.Type.STRUCTURED) {
            reducedAddress.setPostalCode(address.getPostalCode());
            reducedAddress.setTown(address.getTown());
        } else if (address.getType() == Address.Type.COMBINED_ELEMENTS) {
            reducedAddress.setAddressLine2(address.getAddressLine2());
        }
        return reducedAddress;
    }

    private void breakLines(double maxWidth) {
        this.accountPayableToLines = this.graphics.splitLines(this.accountPayableTo, maxWidth * 2.834645669291339, this.textFontSize);
        if (this.additionalInfo != null) {
            this.additionalInfoLines = this.graphics.splitLines(this.additionalInfo, maxWidth * 2.834645669291339, this.textFontSize);
        }
        if (this.payableBy != null) {
            this.payableByLines = this.graphics.splitLines(this.payableBy, maxWidth * 2.834645669291339, this.textFontSize);
        }
    }

    private void drawCorners(double x, double y, double width, double height) throws IOException {
        double lwh = 0.13229166666666664;
        double s = 3.0;
        this.graphics.startPath();
        this.graphics.moveTo(x + 0.13229166666666664, y + 3.0);
        this.graphics.lineTo(x + 0.13229166666666664, y + 0.13229166666666664);
        this.graphics.lineTo(x + 3.0, y + 0.13229166666666664);
        this.graphics.moveTo(x + width - 3.0, y + 0.13229166666666664);
        this.graphics.lineTo(x + width - 0.13229166666666664, y + 0.13229166666666664);
        this.graphics.lineTo(x + width - 0.13229166666666664, y + 3.0);
        this.graphics.moveTo(x + width - 0.13229166666666664, y + height - 3.0);
        this.graphics.lineTo(x + width - 0.13229166666666664, y + height - 0.13229166666666664);
        this.graphics.lineTo(x + width - 3.0, y + height - 0.13229166666666664);
        this.graphics.moveTo(x + 3.0, y + height - 0.13229166666666664);
        this.graphics.lineTo(x + 0.13229166666666664, y + height - 0.13229166666666664);
        this.graphics.lineTo(x + 0.13229166666666664, y + height - 3.0);
        this.graphics.strokePath(0.75, 0, Canvas.LineStyle.Solid, false);
    }

    private static String formatAmountForDisplay(BigDecimal amount) {
        return amountDisplayFormat.format(amount);
    }

    private static String formatAddressForDisplay(Address address, boolean withCountryCode) {
        StringBuilder sb = new StringBuilder();
        sb.append(address.getName());
        if (address.getType() == Address.Type.STRUCTURED) {
            String houseNo;
            String street = address.getStreet();
            if (street != null) {
                sb.append("\n");
                sb.append(street);
            }
            if ((houseNo = address.getHouseNo()) != null) {
                sb.append(street != null ? " " : "\n");
                sb.append(houseNo);
            }
            sb.append("\n");
            if (withCountryCode) {
                sb.append(address.getCountryCode());
                sb.append(" \u2013 ");
            }
            sb.append(address.getPostalCode());
            sb.append(" ");
            sb.append(address.getTown());
        } else if (address.getType() == Address.Type.COMBINED_ELEMENTS) {
            if (address.getAddressLine1() != null) {
                sb.append("\n");
                sb.append(address.getAddressLine1());
            }
            sb.append("\n");
            if (withCountryCode) {
                sb.append(address.getCountryCode());
                sb.append(" \u2013 ");
            }
            sb.append(address.getAddressLine2());
        }
        return sb.toString();
    }

    private static String formatReferenceNumber(String refNo) {
        if (refNo == null) {
            return null;
        }
        int len = (refNo = refNo.trim()).length();
        if (len == 0) {
            return null;
        }
        if (refNo.startsWith("RF")) {
            return Payments.formatIBAN(refNo);
        }
        return Payments.formatQRReferenceNumber(refNo);
    }

    private String truncateText(String text, double maxWidth, int fontSize) {
        double ELLIPSIS_WIDTH = 0.3528;
        if (this.graphics.getTextWidth(text, fontSize, false) < maxWidth) {
            return text;
        }
        String[] lines = this.graphics.splitLines(text, maxWidth - (double)fontSize * 0.3528, fontSize);
        return lines[0] + "\u2026";
    }

    private String getText(String textKey) {
        return MultilingualText.getText(textKey, this.bill.getFormat().getLanguage());
    }

    private boolean isCreditorWithCountryCode() {
        return BillLayout.isForeignAddress(this.bill.getCreditor()) || BillLayout.isForeignAddress(this.bill.getDebtor());
    }

    private boolean isDebtorWithCountryCode() {
        return BillLayout.isForeignAddress(this.bill.getDebtor());
    }

    private static boolean isForeignAddress(Address address) {
        return address != null && !"CH".equals(address.getCountryCode());
    }

    static {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.US);
        symbols.setDecimalSeparator('.');
        symbols.setGroupingSeparator(' ');
        amountDisplayFormat.setDecimalFormatSymbols(symbols);
    }
}

