/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.qrbill.canvas;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.metadata.IIOMetadataNode;
import javax.imageio.stream.ImageOutputStream;
import net.codecrete.qrbill.canvas.AbstractCanvas;
import net.codecrete.qrbill.canvas.ByteArrayResult;
import net.codecrete.qrbill.canvas.Canvas;
import net.codecrete.qrbill.generator.QRBillGenerationException;

public class PNGCanvas
extends AbstractCanvas
implements ByteArrayResult {
    private static final String METADATA_KEY_VALUE = "value";
    private static final String METADATA_KEY_KEYWORD = "keyword";
    private final int resolution;
    private final float coordinateScale;
    private final float fontScale;
    private BufferedImage image;
    private Graphics2D graphics;
    private Path2D.Double currentPath;
    private static final Pattern QUOTED_SPLITTER = Pattern.compile("(?:^|,)(\"[^\"]+\"|[^,]*)");
    private static final String PNG_STANDARD_METADATA_FORMAT = "javax_imageio_1.0";

    public PNGCanvas(double width, double height, int resolution, String fontFamilyList) {
        this.resolution = resolution;
        this.coordinateScale = (float)((double)resolution / 25.4);
        this.fontScale = (float)((double)resolution / 72.0);
        this.setupFontMetrics(this.findFontFamily(fontFamilyList));
        int w = (int)(width * (double)this.coordinateScale + 0.5);
        int h = (int)(height * (double)this.coordinateScale + 0.5);
        this.image = new BufferedImage(w, h, 10);
        this.graphics = this.image.createGraphics();
        this.graphics.setColor(new Color(0xFFFFFF));
        this.graphics.fillRect(0, 0, w, h);
        this.graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        this.graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        this.graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        this.graphics.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        this.setTransformation(0.0, 0.0, 0.0, 1.0, 1.0);
    }

    private String findFontFamily(String fontFamilyList) {
        for (String family : PNGCanvas.splitCommaSeparated(fontFamilyList)) {
            Font font = new Font(family, 0, 12);
            if (!font.getFamily().toLowerCase(Locale.US).contains(family.toLowerCase(Locale.US))) continue;
            return family;
        }
        return fontFamilyList;
    }

    private static List<String> splitCommaSeparated(String input) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher matcher = QUOTED_SPLITTER.matcher(input);
        while (matcher.find()) {
            String match = matcher.group(1).trim();
            if (match.charAt(0) == '\"' && match.charAt(match.length() - 1) == '\"') {
                match = match.substring(1, match.length() - 1);
            }
            result.add(match);
        }
        return result;
    }

    @Override
    public void setTransformation(double translateX, double translateY, double rotate, double scaleX, double scaleY) {
        AffineTransform at = new AffineTransform();
        at.translate(translateX *= (double)this.coordinateScale, (double)this.image.getHeight() - (translateY *= (double)this.coordinateScale));
        if (rotate != 0.0) {
            at.rotate(-rotate);
        }
        if (scaleX != 1.0 || scaleY != 1.0) {
            at.scale(scaleX, scaleY);
        }
        this.graphics.setTransform(at);
    }

    @Override
    public void putText(String text, double x, double y, int fontSize, boolean isBold) {
        this.graphics.setColor(new Color(0));
        Font font = new Font(this.fontMetrics.getFirstFontFamily(), isBold ? 1 : 0, (int)((double)((float)fontSize * this.fontScale) + 0.5));
        this.graphics.setFont(font);
        this.graphics.drawString(text, (float)(x *= (double)this.coordinateScale), (float)(y *= (double)(-this.coordinateScale)));
    }

    @Override
    public void startPath() {
        this.currentPath = new Path2D.Double(1);
    }

    @Override
    public void moveTo(double x, double y) {
        this.currentPath.moveTo(x *= (double)this.coordinateScale, y *= (double)(-this.coordinateScale));
    }

    @Override
    public void lineTo(double x, double y) {
        this.currentPath.lineTo(x *= (double)this.coordinateScale, y *= (double)(-this.coordinateScale));
    }

    @Override
    public void cubicCurveTo(double x1, double y1, double x2, double y2, double x, double y) {
        this.currentPath.curveTo(x1 *= (double)this.coordinateScale, y1 *= (double)(-this.coordinateScale), x2 *= (double)this.coordinateScale, y2 *= (double)(-this.coordinateScale), x *= (double)this.coordinateScale, y *= (double)(-this.coordinateScale));
    }

    @Override
    public void addRectangle(double x, double y, double width, double height) {
        this.currentPath.moveTo(x *= (double)this.coordinateScale, y *= (double)(-this.coordinateScale));
        this.currentPath.lineTo(x, y + (height *= (double)(-this.coordinateScale)));
        this.currentPath.lineTo(x + (width *= (double)this.coordinateScale), y + height);
        this.currentPath.lineTo(x + width, y);
        this.currentPath.closePath();
    }

    @Override
    public void closeSubpath() {
        this.currentPath.closePath();
    }

    @Override
    public void fillPath(int color, boolean smoothing) {
        if (!smoothing) {
            this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            this.graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        }
        this.graphics.setColor(new Color(color));
        this.graphics.fill(this.currentPath);
        if (!smoothing) {
            this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        }
    }

    @Override
    public void strokePath(double strokeWidth, int color, Canvas.LineStyle lineStyle, boolean smoothing) {
        BasicStroke stroke;
        this.graphics.setColor(new Color(color));
        switch (lineStyle) {
            case Dashed: {
                stroke = new BasicStroke((float)(strokeWidth * (double)this.fontScale), 0, 0, 10.0f, new float[]{4.0f * (float)strokeWidth * this.fontScale}, 0.0f);
                break;
            }
            case Dotted: {
                stroke = new BasicStroke((float)(strokeWidth * (double)this.fontScale), 1, 0, 10.0f, new float[]{0.0f, 3.0f * (float)strokeWidth * this.fontScale}, 0.0f);
                break;
            }
            default: {
                stroke = new BasicStroke((float)(strokeWidth * (double)this.fontScale), 0, 0);
            }
        }
        this.graphics.setStroke(stroke);
        if (!smoothing) {
            this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            this.graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        }
        this.graphics.draw(this.currentPath);
        if (!smoothing) {
            this.graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            this.graphics.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        }
    }

    @Override
    public byte[] toByteArray() throws IOException {
        this.graphics.dispose();
        this.graphics = null;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        PNGCanvas.createPNG(this.image, os, this.resolution);
        return os.toByteArray();
    }

    public void writeTo(OutputStream os) throws IOException {
        this.graphics.dispose();
        this.graphics = null;
        PNGCanvas.createPNG(this.image, os, this.resolution);
    }

    public void saveAs(Path path) throws IOException {
        this.graphics.dispose();
        this.graphics = null;
        try (OutputStream os = Files.newOutputStream(path, new OpenOption[0]);){
            PNGCanvas.createPNG(this.image, os, this.resolution);
        }
    }

    @Override
    public void close() {
        if (this.graphics != null) {
            this.graphics.dispose();
            this.graphics = null;
        }
        this.image = null;
    }

    private static void createPNG(BufferedImage image, OutputStream os, int resolution) throws IOException {
        ImageWriter writer = null;
        ImageWriteParam writeParam = null;
        IIOMetadata metadata = null;
        Iterator<ImageWriter> iw = ImageIO.getImageWritersByFormatName("png");
        while (iw.hasNext()) {
            writer = iw.next();
            writeParam = writer.getDefaultWriteParam();
            ImageTypeSpecifier typeSpecifier = ImageTypeSpecifier.createFromBufferedImageType(image.getType());
            metadata = writer.getDefaultImageMetadata(typeSpecifier, writeParam);
            if (metadata.isReadOnly() || !metadata.isStandardMetadataFormatSupported()) continue;
            break;
        }
        if (writer == null || writeParam == null) {
            throw new QRBillGenerationException("No valid PNG writer found");
        }
        PNGCanvas.addDpiMetadata(metadata, resolution);
        PNGCanvas.addTextMetadata(metadata);
        try (ImageOutputStream stream = ImageIO.createImageOutputStream(os);){
            writer.setOutput(stream);
            writer.write(metadata, new IIOImage(image, null, metadata), writeParam);
        }
    }

    private static void addDpiMetadata(IIOMetadata metadata, int dpi) throws IIOInvalidTreeException {
        double pixelsPerMeter = (double)dpi / 25.4 * 1000.0;
        String pixelsPerMeterString = Integer.toString((int)(pixelsPerMeter + 0.5));
        IIOMetadataNode physNode = new IIOMetadataNode("pHYs");
        physNode.setAttribute("pixelsPerUnitXAxis", pixelsPerMeterString);
        physNode.setAttribute("pixelsPerUnitYAxis", pixelsPerMeterString);
        physNode.setAttribute("unitSpecifier", "meter");
        IIOMetadataNode root = new IIOMetadataNode(metadata.getNativeMetadataFormatName());
        root.appendChild(physNode);
        metadata.mergeTree(metadata.getNativeMetadataFormatName(), root);
        double pixelsPerMM = (double)dpi / 25.4;
        String pixelsPerMMString = Double.toString(pixelsPerMM);
        IIOMetadataNode horizontalPixelSize = new IIOMetadataNode("HorizontalPixelSize");
        horizontalPixelSize.setAttribute(METADATA_KEY_VALUE, pixelsPerMMString);
        IIOMetadataNode verticalPixelSize = new IIOMetadataNode("VerticalPixelSize");
        verticalPixelSize.setAttribute(METADATA_KEY_VALUE, pixelsPerMMString);
        IIOMetadataNode dimension = new IIOMetadataNode("Dimension");
        dimension.appendChild(horizontalPixelSize);
        dimension.appendChild(verticalPixelSize);
        root = new IIOMetadataNode(PNG_STANDARD_METADATA_FORMAT);
        root.appendChild(dimension);
        metadata.mergeTree(PNG_STANDARD_METADATA_FORMAT, root);
    }

    private static void addTextMetadata(IIOMetadata metadata) throws IIOInvalidTreeException {
        IIOMetadataNode textEntry = new IIOMetadataNode("tEXtEntry");
        textEntry.setAttribute(METADATA_KEY_KEYWORD, "Title");
        textEntry.setAttribute(METADATA_KEY_VALUE, "Swiss QR Bill");
        IIOMetadataNode text = new IIOMetadataNode("tEXt");
        text.appendChild(textEntry);
        IIOMetadataNode commentMetadata = new IIOMetadataNode(metadata.getNativeMetadataFormatName());
        commentMetadata.appendChild(text);
        metadata.mergeTree(metadata.getNativeMetadataFormatName(), commentMetadata);
    }
}

