/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.qrbill.generator;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.ParsePosition;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.codecrete.qrbill.generator.SwicoBillInformation;

public class SwicoS1Decoder {
    private static final int INVOICE_NUMBER_TAG = 10;
    private static final int INVOICE_DATE_TAG = 11;
    private static final int CUSTOMER_REFERENCE_TAG = 20;
    private static final int VAT_NUMBER_TAG = 30;
    private static final int VAT_DATE_TAG = 31;
    private static final int VAT_RATE_DETAILS_TAG = 32;
    private static final int VAT_IMPORT_TAXES_TAG = 33;
    private static final int PAYMENT_CONDITIONS_TAG = 40;
    private static final DateTimeFormatter SWICO_DATE_FORMAT_SPECIFICATION = DateTimeFormatter.ofPattern("yyMMdd", Locale.UK);
    private static final DateTimeFormatter SWICO_DATE_FORMAT_WILDERNESS_1 = DateTimeFormatter.ofPattern("yyMMddHHmmss", Locale.UK);
    private static final DateTimeFormatter SWICO_DATE_FORMAT_WILDERNESS_2 = DateTimeFormatter.ofPattern("yyMMddHHmm", Locale.UK);
    private static final DecimalFormat SWICO_NUMBER_FORMAT = new DecimalFormat("0.###", new DecimalFormatSymbols(Locale.UK));

    private SwicoS1Decoder() {
    }

    static SwicoBillInformation decode(String billInfoText) {
        if (billInfoText == null || !billInfoText.startsWith("//S1/")) {
            return null;
        }
        String[] parts = SwicoS1Decoder.split(billInfoText.substring(5));
        ArrayList<InfoTuple> tuples = new ArrayList<InfoTuple>();
        int len = parts.length;
        for (int i = 0; i < len - 1; i += 2) {
            try {
                int tag = Integer.parseInt(parts[i]);
                tuples.add(new InfoTuple(tag, parts[i + 1]));
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        SwicoBillInformation billInformation = new SwicoBillInformation();
        for (InfoTuple tuple : tuples) {
            SwicoS1Decoder.decodeElement(billInformation, tuple.tag, tuple.value);
        }
        return billInformation;
    }

    private static void decodeElement(SwicoBillInformation billInformation, int tag, String value) {
        if (value.length() == 0) {
            return;
        }
        switch (tag) {
            case 10: {
                billInformation.setInvoiceNumber(value);
                break;
            }
            case 11: {
                billInformation.setInvoiceDate(SwicoS1Decoder.getDateValue(value));
                break;
            }
            case 20: {
                billInformation.setCustomerReference(value);
                break;
            }
            case 30: {
                billInformation.setVatNumber(value);
                break;
            }
            case 31: {
                SwicoS1Decoder.setVatDates(billInformation, value);
                break;
            }
            case 32: {
                SwicoS1Decoder.setVatRateDetails(billInformation, value);
                break;
            }
            case 33: {
                billInformation.setVatImportTaxes(SwicoS1Decoder.parseDetailList(value));
                break;
            }
            case 40: {
                SwicoS1Decoder.setPaymentConditions(billInformation, value);
                break;
            }
        }
    }

    private static void setVatDates(SwicoBillInformation billInformation, String value) {
        if (value.length() != 6 && value.length() != 12) {
            return;
        }
        if (value.length() == 6) {
            LocalDate date = SwicoS1Decoder.getDateValue(value);
            if (date != null) {
                billInformation.setVatDate(date);
                billInformation.setVatStartDate(null);
                billInformation.setVatEndDate(null);
            }
        } else {
            LocalDate startDate = SwicoS1Decoder.getDateValue(value.substring(0, 6));
            LocalDate endDate = SwicoS1Decoder.getDateValue(value.substring(6, 12));
            if (startDate != null && endDate != null) {
                billInformation.setVatStartDate(startDate);
                billInformation.setVatEndDate(endDate);
                billInformation.setVatDate(null);
            }
        }
    }

    private static void setVatRateDetails(SwicoBillInformation billInformation, String value) {
        if (!value.contains(":") && !value.contains(";")) {
            billInformation.setVatRate(SwicoS1Decoder.getDecimalValue(value));
            billInformation.setVatRateDetails(null);
        } else {
            billInformation.setVatRateDetails(SwicoS1Decoder.parseDetailList(value));
            billInformation.setVatRate(null);
        }
    }

    private static void setPaymentConditions(SwicoBillInformation billInformation, String value) {
        String[] tuples = value.split(";");
        ArrayList<SwicoBillInformation.PaymentCondition> list = new ArrayList<SwicoBillInformation.PaymentCondition>();
        for (String listEntry : tuples) {
            String[] detail = listEntry.split(":");
            if (detail.length != 2) continue;
            BigDecimal discount = SwicoS1Decoder.getDecimalValue(detail[0]);
            Integer days = SwicoS1Decoder.getIntValue(detail[1]);
            if (discount == null || days == null) continue;
            list.add(new SwicoBillInformation.PaymentCondition(discount, days));
        }
        if (!list.isEmpty()) {
            billInformation.setPaymentConditions(list);
        }
    }

    private static List<SwicoBillInformation.RateDetail> parseDetailList(String text) {
        String[] tuples = text.split(";");
        ArrayList<SwicoBillInformation.RateDetail> list = new ArrayList<SwicoBillInformation.RateDetail>();
        for (String vatEntry : tuples) {
            String[] vatDetails = vatEntry.split(":");
            if (vatDetails.length != 2) continue;
            BigDecimal vatRate = SwicoS1Decoder.getDecimalValue(vatDetails[0]);
            BigDecimal vatAmount = SwicoS1Decoder.getDecimalValue(vatDetails[1]);
            if (vatRate == null || vatAmount == null) continue;
            list.add(new SwicoBillInformation.RateDetail(vatRate, vatAmount));
        }
        return list.isEmpty() ? null : list;
    }

    private static LocalDate getDateValue(String dateText) {
        if (dateText.length() == 6) {
            try {
                return LocalDate.parse(dateText, SWICO_DATE_FORMAT_SPECIFICATION);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        } else if (dateText.length() == 12) {
            try {
                return LocalDate.parse(dateText, SWICO_DATE_FORMAT_WILDERNESS_1);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        } else if (dateText.length() == 10) {
            try {
                return LocalDate.parse(dateText, SWICO_DATE_FORMAT_WILDERNESS_2);
            }
            catch (DateTimeParseException dateTimeParseException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Integer getIntValue(String intText) {
        try {
            return Integer.parseInt(intText);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    private static BigDecimal getDecimalValue(String decimalText) {
        ParsePosition position = new ParsePosition(0);
        BigDecimal decimal = (BigDecimal)SWICO_NUMBER_FORMAT.parse(decimalText, position);
        return position.getIndex() == decimalText.length() ? decimal : null;
    }

    private static String[] split(String text) {
        text = text.replace("\\\\", "\u2601").replace("\\/", "\u2605");
        String[] parts = text.split("/");
        for (int i = 0; i < parts.length; ++i) {
            parts[i] = parts[i].replace('\u2605', '/').replace('\u2601', '\\');
        }
        return parts;
    }

    static {
        SWICO_NUMBER_FORMAT.setParseBigDecimal(true);
    }

    static class InfoTuple {
        int tag;
        String value;

        InfoTuple(int tag, String value) {
            this.tag = tag;
            this.value = value;
        }
    }
}

