/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.qrbill.generator;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Objects;
import net.codecrete.qrbill.generator.Address;
import net.codecrete.qrbill.generator.AlternativeScheme;
import net.codecrete.qrbill.generator.BillFormat;
import net.codecrete.qrbill.generator.Payments;
import net.codecrete.qrbill.generator.Strings;

public class Bill
implements Serializable {
    private static final long serialVersionUID = -8104086304378262190L;
    public static final String REFERENCE_TYPE_NO_REF = "NON";
    public static final String REFERENCE_TYPE_QR_REF = "QRR";
    public static final String REFERENCE_TYPE_CRED_REF = "SCOR";
    private Version version = Version.V2_0;
    private BigDecimal amount = null;
    private String currency = "CHF";
    private String account = null;
    private Address creditor = new Address();
    private String referenceType = "NON";
    private String reference = null;
    private Address debtor = null;
    private String unstructuredMessage = null;
    private String billInformation = null;
    private AlternativeScheme[] alternativeSchemes = null;
    private BillFormat format = new BillFormat();

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public Double getAmountAsDouble() {
        if (this.amount != null) {
            return this.amount.doubleValue();
        }
        return null;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public void setAmountFromDouble(Double amount) {
        this.amount = amount != null ? BigDecimal.valueOf((long)(amount * 100.0 + 0.5), 2) : null;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public Address getCreditor() {
        return this.creditor;
    }

    public void setCreditor(Address creditor) {
        this.creditor = creditor;
    }

    public String getReferenceType() {
        return this.referenceType;
    }

    public void setReferenceType(String referenceType) {
        this.referenceType = referenceType;
    }

    public void updateReferenceType() {
        String ref = Strings.trimmed(this.reference);
        this.referenceType = ref != null ? (ref.startsWith("RF") ? REFERENCE_TYPE_CRED_REF : (ref.length() > 0 ? REFERENCE_TYPE_QR_REF : REFERENCE_TYPE_NO_REF)) : REFERENCE_TYPE_NO_REF;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
        this.updateReferenceType();
    }

    public void createAndSetCreditorReference(String rawReference) {
        this.setReference(Payments.createISO11649Reference(rawReference));
    }

    public Address getDebtor() {
        return this.debtor;
    }

    public void setDebtor(Address debtor) {
        this.debtor = debtor;
    }

    public String getUnstructuredMessage() {
        return this.unstructuredMessage;
    }

    public void setUnstructuredMessage(String unstructuredMessage) {
        this.unstructuredMessage = unstructuredMessage;
    }

    public String getBillInformation() {
        return this.billInformation;
    }

    public void setBillInformation(String billInformation) {
        this.billInformation = billInformation;
    }

    public AlternativeScheme[] getAlternativeSchemes() {
        return this.alternativeSchemes;
    }

    public void setAlternativeSchemes(AlternativeScheme[] alternativeSchemes) {
        this.alternativeSchemes = alternativeSchemes;
    }

    public BillFormat getFormat() {
        return this.format;
    }

    public void setFormat(BillFormat format) {
        this.format = format;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bill bill = (Bill)o;
        return this.version == bill.version && Objects.equals(this.amount, bill.amount) && Objects.equals(this.currency, bill.currency) && Objects.equals(this.account, bill.account) && Objects.equals(this.creditor, bill.creditor) && Objects.equals(this.referenceType, bill.referenceType) && Objects.equals(this.reference, bill.reference) && Objects.equals(this.debtor, bill.debtor) && Objects.equals(this.unstructuredMessage, bill.unstructuredMessage) && Objects.equals(this.billInformation, bill.billInformation) && Arrays.equals(this.alternativeSchemes, bill.alternativeSchemes) && Objects.equals(this.format, bill.format);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.version, this.amount, this.currency, this.account, this.creditor, this.referenceType, this.reference, this.debtor, this.unstructuredMessage, this.billInformation, this.format});
        result = 31 * result + Arrays.hashCode(this.alternativeSchemes);
        return result;
    }

    public String toString() {
        return "Bill{version=" + (Object)((Object)this.version) + ", amount=" + this.amount + ", currency='" + this.currency + '\'' + ", account='" + this.account + '\'' + ", creditor=" + this.creditor + ", referenceType='" + this.referenceType + '\'' + ", reference='" + this.reference + '\'' + ", debtor=" + this.debtor + ", unstructuredMessage='" + this.unstructuredMessage + '\'' + ", billInformation='" + this.billInformation + '\'' + ", alternativeSchemes=" + Arrays.toString(this.alternativeSchemes) + ", format=" + this.format + '}';
    }

    public static enum Version {
        V2_0;

    }
}

