/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.qrbill.generator;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import net.codecrete.qrbill.generator.SwicoS1Decoder;
import net.codecrete.qrbill.generator.SwicoS1Encoder;

public class SwicoBillInformation {
    private String invoiceNumber;
    private LocalDate invoiceDate;
    private String customerReference;
    private String vatNumber;
    private LocalDate vatDate;
    private LocalDate vatStartDate;
    private LocalDate vatEndDate;
    private BigDecimal vatRate;
    private List<RateDetail> vatRateDetails;
    private List<RateDetail> vatImportTaxes;
    private List<PaymentCondition> paymentConditions;

    public String getInvoiceNumber() {
        return this.invoiceNumber;
    }

    public void setInvoiceNumber(String invoiceNumber) {
        this.invoiceNumber = invoiceNumber;
    }

    public LocalDate getInvoiceDate() {
        return this.invoiceDate;
    }

    public void setInvoiceDate(LocalDate invoiceDate) {
        this.invoiceDate = invoiceDate;
    }

    public String getCustomerReference() {
        return this.customerReference;
    }

    public void setCustomerReference(String customerReference) {
        this.customerReference = customerReference;
    }

    public String getVatNumber() {
        return this.vatNumber;
    }

    public void setVatNumber(String vatNumber) {
        this.vatNumber = vatNumber;
    }

    public LocalDate getVatDate() {
        return this.vatDate;
    }

    public void setVatDate(LocalDate vatDate) {
        this.vatDate = vatDate;
    }

    public LocalDate getVatStartDate() {
        return this.vatStartDate;
    }

    public void setVatStartDate(LocalDate vatStartDate) {
        this.vatStartDate = vatStartDate;
    }

    public LocalDate getVatEndDate() {
        return this.vatEndDate;
    }

    public void setVatEndDate(LocalDate vatEndDate) {
        this.vatEndDate = vatEndDate;
    }

    public BigDecimal getVatRate() {
        return this.vatRate;
    }

    public void setVatRate(BigDecimal vatRate) {
        this.vatRate = vatRate;
    }

    public List<RateDetail> getVatRateDetails() {
        return this.vatRateDetails;
    }

    public void setVatRateDetails(List<RateDetail> vatRateDetails) {
        this.vatRateDetails = vatRateDetails;
    }

    public List<RateDetail> getVatImportTaxes() {
        return this.vatImportTaxes;
    }

    public void setVatImportTaxes(List<RateDetail> vatImportTaxes) {
        this.vatImportTaxes = vatImportTaxes;
    }

    public List<PaymentCondition> getPaymentConditions() {
        return this.paymentConditions;
    }

    public void setPaymentConditions(List<PaymentCondition> paymentConditions) {
        this.paymentConditions = paymentConditions;
    }

    public LocalDate getDueDate() {
        if (this.invoiceDate == null || this.paymentConditions == null) {
            return null;
        }
        for (PaymentCondition cond : this.paymentConditions) {
            if (BigDecimal.ZERO.compareTo(cond.getDiscount()) != 0) continue;
            return this.invoiceDate.plusDays(cond.getDays());
        }
        return null;
    }

    public String encodeAsText() {
        return SwicoS1Encoder.encode(this);
    }

    public static SwicoBillInformation decodeText(String text) {
        return SwicoS1Decoder.decode(text);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SwicoBillInformation that = (SwicoBillInformation)o;
        return Objects.equals(this.invoiceNumber, that.invoiceNumber) && Objects.equals(this.invoiceDate, that.invoiceDate) && Objects.equals(this.customerReference, that.customerReference) && Objects.equals(this.vatNumber, that.vatNumber) && Objects.equals(this.vatDate, that.vatDate) && Objects.equals(this.vatStartDate, that.vatStartDate) && Objects.equals(this.vatEndDate, that.vatEndDate) && Objects.equals(this.vatRate, that.vatRate) && Objects.equals(this.vatRateDetails, that.vatRateDetails) && Objects.equals(this.vatImportTaxes, that.vatImportTaxes) && Objects.equals(this.paymentConditions, that.paymentConditions);
    }

    public int hashCode() {
        return Objects.hash(this.invoiceNumber, this.invoiceDate, this.customerReference, this.vatNumber, this.vatDate, this.vatStartDate, this.vatEndDate, this.vatRate, this.vatRateDetails, this.vatImportTaxes, this.paymentConditions);
    }

    public static class PaymentCondition {
        private BigDecimal discount;
        private int days;

        public PaymentCondition() {
        }

        public PaymentCondition(BigDecimal discount, int days) {
            this.discount = discount;
            this.days = days;
        }

        public BigDecimal getDiscount() {
            return this.discount;
        }

        public void setDiscount(BigDecimal discount) {
            this.discount = discount;
        }

        public int getDays() {
            return this.days;
        }

        public void setDays(int days) {
            this.days = days;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            PaymentCondition that = (PaymentCondition)o;
            return this.days == that.days && Objects.equals(this.discount, that.discount);
        }

        public int hashCode() {
            return Objects.hash(this.discount, this.days);
        }
    }

    public static class RateDetail {
        private BigDecimal rate;
        private BigDecimal amount;

        public RateDetail() {
        }

        public RateDetail(BigDecimal rate, BigDecimal amount) {
            this.rate = rate;
            this.amount = amount;
        }

        public BigDecimal getRate() {
            return this.rate;
        }

        public void setRate(BigDecimal rate) {
            this.rate = rate;
        }

        public BigDecimal getAmount() {
            return this.amount;
        }

        public void setAmount(BigDecimal amount) {
            this.amount = amount;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            RateDetail that = (RateDetail)o;
            return Objects.equals(this.rate, that.rate) && Objects.equals(this.amount, that.amount);
        }

        public int hashCode() {
            return Objects.hash(this.rate, this.amount);
        }
    }
}

