/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.qrbill.generator;

import java.io.IOException;
import net.codecrete.qrbill.canvas.AbstractCanvas;
import net.codecrete.qrbill.canvas.ByteArrayResult;
import net.codecrete.qrbill.canvas.Canvas;
import net.codecrete.qrbill.canvas.PDFCanvas;
import net.codecrete.qrbill.canvas.PNGCanvas;
import net.codecrete.qrbill.canvas.SVGCanvas;
import net.codecrete.qrbill.generator.Bill;
import net.codecrete.qrbill.generator.BillFormat;
import net.codecrete.qrbill.generator.BillLayout;
import net.codecrete.qrbill.generator.OutputSize;
import net.codecrete.qrbill.generator.QRBillGenerationException;
import net.codecrete.qrbill.generator.QRBillValidationError;
import net.codecrete.qrbill.generator.QRCode;
import net.codecrete.qrbill.generator.QRCodeText;
import net.codecrete.qrbill.generator.SeparatorType;
import net.codecrete.qrbill.generator.ValidationResult;
import net.codecrete.qrbill.generator.Validator;

public class QRBill {
    public static final double A4_PORTRAIT_WIDTH = 210.0;
    public static final double A4_PORTRAIT_HEIGHT = 297.0;
    public static final double QR_BILL_WIDTH = 210.0;
    public static final double QR_BILL_HEIGHT = 105.0;
    public static final double QR_BILL_WITH_HORI_LINE_WIDTH = 210.0;
    public static final double QR_BILL_WITH_HORI_LINE_HEIGHT = 110.0;
    public static final double QR_CODE_WIDTH = 46.0;
    public static final double QR_CODE_HEIGHT = 46.0;

    private QRBill() {
    }

    public static ValidationResult validate(Bill bill) {
        return Validator.validate(bill);
    }

    public static byte[] generate(Bill bill) {
        byte[] byArray;
        block8: {
            Canvas canvas = QRBill.createCanvas(bill.getFormat());
            try {
                QRBill.validateAndGenerate(bill, canvas);
                byArray = ((ByteArrayResult)((Object)canvas)).toByteArray();
                if (canvas == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (canvas != null) {
                        try {
                            canvas.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new QRBillGenerationException(e);
                }
            }
            canvas.close();
        }
        return byArray;
    }

    public static void draw(Bill bill, Canvas canvas) {
        try {
            QRBill.validateAndGenerate(bill, canvas);
        }
        catch (IOException e) {
            throw new QRBillGenerationException(e);
        }
    }

    public static void drawSeparators(SeparatorType separatorType, boolean withHorizontalLine, Canvas canvas) {
        BillFormat format = new BillFormat();
        format.setSeparatorType(separatorType);
        format.setOutputSize(withHorizontalLine ? OutputSize.QR_BILL_WITH_HORIZONTAL_LINE : OutputSize.QR_BILL_ONLY);
        Bill bill = new Bill();
        bill.setFormat(format);
        BillLayout layout = new BillLayout(bill, canvas);
        try {
            layout.drawBorder();
        }
        catch (IOException e) {
            throw new QRBillGenerationException(e);
        }
    }

    private static void validateAndGenerate(Bill bill, Canvas canvas) throws IOException {
        ValidationResult result = Validator.validate(bill);
        Bill cleanedBill = result.getCleanedBill();
        if (result.hasErrors()) {
            throw new QRBillValidationError(result);
        }
        if (bill.getFormat().getOutputSize() == OutputSize.QR_CODE_ONLY) {
            QRCode qrCode = new QRCode(cleanedBill);
            qrCode.draw(canvas, 0.0, 0.0);
        } else {
            BillLayout layout = new BillLayout(cleanedBill, canvas);
            layout.draw();
        }
    }

    public static String encodeQrCodeText(Bill bill) {
        ValidationResult result = Validator.validate(bill);
        Bill cleanedBill = result.getCleanedBill();
        if (result.hasErrors()) {
            throw new QRBillValidationError(result);
        }
        return QRCodeText.create(cleanedBill);
    }

    public static Bill decodeQrCodeText(String text) {
        return QRCodeText.decode(text);
    }

    private static Canvas createCanvas(BillFormat format) throws IOException {
        AbstractCanvas canvas;
        double drawingHeight;
        double drawingWidth;
        switch (format.getOutputSize()) {
            case QR_BILL_ONLY: {
                drawingWidth = 210.0;
                drawingHeight = 105.0;
                break;
            }
            case QR_BILL_WITH_HORIZONTAL_LINE: {
                drawingWidth = 210.0;
                drawingHeight = 110.0;
                break;
            }
            case QR_CODE_ONLY: {
                drawingWidth = 46.0;
                drawingHeight = 46.0;
                break;
            }
            default: {
                drawingWidth = 210.0;
                drawingHeight = 297.0;
            }
        }
        switch (format.getGraphicsFormat()) {
            case SVG: {
                canvas = new SVGCanvas(drawingWidth, drawingHeight, format.getFontFamily());
                break;
            }
            case PDF: {
                canvas = new PDFCanvas(drawingWidth, drawingHeight);
                break;
            }
            case PNG: {
                canvas = new PNGCanvas(drawingWidth, drawingHeight, format.getResolution(), format.getFontFamily());
                break;
            }
            default: {
                throw new QRBillGenerationException("Invalid graphics format specified");
            }
        }
        return canvas;
    }
}

