/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.qrbill.generator;

import java.io.Serializable;
import java.util.Objects;

public class Address
implements Serializable {
    private static final long serialVersionUID = -8833174154173397772L;
    private Type type = Type.UNDETERMINED;
    private String name;
    private String addressLine1;
    private String addressLine2;
    private String street;
    private String houseNo;
    private String postalCode;
    private String town;
    private String countryCode;

    public Type getType() {
        return this.type;
    }

    private void changeType(Type desiredType) {
        if (this.type == desiredType) {
            return;
        }
        this.type = this.type == Type.UNDETERMINED ? desiredType : Type.CONFLICTING;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getAddressLine1() {
        return this.addressLine1;
    }

    public void setAddressLine1(String addressLine1) {
        this.addressLine1 = addressLine1;
        this.changeType(Type.COMBINED_ELEMENTS);
    }

    public String getAddressLine2() {
        return this.addressLine2;
    }

    public void setAddressLine2(String addressLine2) {
        this.addressLine2 = addressLine2;
        this.changeType(Type.COMBINED_ELEMENTS);
    }

    public String getStreet() {
        return this.street;
    }

    public void setStreet(String street) {
        this.street = street;
        this.changeType(Type.STRUCTURED);
    }

    public String getHouseNo() {
        return this.houseNo;
    }

    public void setHouseNo(String houseNo) {
        this.houseNo = houseNo;
        this.changeType(Type.STRUCTURED);
    }

    public String getPostalCode() {
        return this.postalCode;
    }

    public void setPostalCode(String postalCode) {
        this.postalCode = postalCode;
        this.changeType(Type.STRUCTURED);
    }

    public String getTown() {
        return this.town;
    }

    public void setTown(String town) {
        this.town = town;
        this.changeType(Type.STRUCTURED);
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    public void setCountryCode(String countryCode) {
        this.countryCode = countryCode;
    }

    public void clear() {
        this.type = Type.UNDETERMINED;
        this.name = null;
        this.addressLine1 = null;
        this.addressLine2 = null;
        this.street = null;
        this.houseNo = null;
        this.postalCode = null;
        this.town = null;
        this.countryCode = null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Address address = (Address)o;
        return Objects.equals(this.name, address.name) && this.type == address.type && Objects.equals(this.street, address.street) && Objects.equals(this.houseNo, address.houseNo) && Objects.equals(this.addressLine1, address.addressLine1) && Objects.equals(this.addressLine2, address.addressLine2) && Objects.equals(this.postalCode, address.postalCode) && Objects.equals(this.town, address.town) && Objects.equals(this.countryCode, address.countryCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.type, this.street, this.houseNo, this.addressLine1, this.addressLine2, this.postalCode, this.town, this.countryCode});
    }

    public String toString() {
        return "Address{type=" + (Object)((Object)this.type) + ", name='" + this.name + '\'' + ", addressLine1='" + this.addressLine1 + '\'' + ", addressLine2='" + this.addressLine2 + '\'' + ", street='" + this.street + '\'' + ", houseNo='" + this.houseNo + '\'' + ", postalCode='" + this.postalCode + '\'' + ", town='" + this.town + '\'' + ", countryCode='" + this.countryCode + '\'' + '}';
    }

    public static enum Type {
        UNDETERMINED,
        STRUCTURED,
        COMBINED_ELEMENTS,
        CONFLICTING;

    }
}

