/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.qrbill.generator;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Locale;
import net.codecrete.qrbill.generator.Address;
import net.codecrete.qrbill.generator.AlternativeScheme;
import net.codecrete.qrbill.generator.Bill;
import net.codecrete.qrbill.generator.Payments;
import net.codecrete.qrbill.generator.Strings;
import net.codecrete.qrbill.generator.ValidationMessage;
import net.codecrete.qrbill.generator.ValidationResult;

class Validator {
    private final Bill billIn;
    private final Bill billOut;
    private final ValidationResult validationResult;
    private static final BigDecimal AMOUNT_MIN = new BigDecimal(1).movePointLeft(2);
    private static final BigDecimal AMOUNT_MAX = new BigDecimal(99999999999L).movePointLeft(2);

    static ValidationResult validate(Bill bill) {
        Validator validator = new Validator(bill);
        return validator.validateBill();
    }

    private Validator(Bill bill) {
        this.billIn = bill;
        this.billOut = new Bill();
        this.validationResult = new ValidationResult();
    }

    private ValidationResult validateBill() {
        this.billOut.setFormat(this.billIn.getFormat() != null ? this.billIn.getFormat().cloneInstance() : null);
        this.billOut.setVersion(this.billIn.getVersion());
        this.validateCurrency();
        this.validateAmount();
        this.validateAccountNumber();
        this.validateCreditor();
        this.validateReference();
        this.validateUnstructuredMessage();
        this.validateDebtor();
        this.validateBillInformation();
        this.validateAlternativeSchemes();
        this.validationResult.setCleanedBill(this.billOut);
        return this.validationResult;
    }

    private void validateCurrency() {
        String currency = Strings.trimmed(this.billIn.getCurrency());
        if (this.validateMandatory(currency, "currency")) {
            if (!"CHF".equals(currency = currency.toUpperCase(Locale.US)) && !"EUR".equals(currency)) {
                this.validationResult.addMessage(ValidationMessage.Type.ERROR, "currency", "currency_is_chf_or_eur");
            } else {
                this.billOut.setCurrency(currency);
            }
        }
    }

    private void validateAmount() {
        BigDecimal amount = this.billIn.getAmount();
        if (amount == null) {
            this.billOut.setAmount(null);
        } else if (AMOUNT_MIN.compareTo(amount = amount.setScale(2, RoundingMode.HALF_UP)) > 0 || AMOUNT_MAX.compareTo(amount) < 0) {
            this.validationResult.addMessage(ValidationMessage.Type.ERROR, "amount", "amount_in_valid_range");
        } else {
            this.billOut.setAmount(amount);
        }
    }

    private void validateAccountNumber() {
        String account = Strings.trimmed(this.billIn.getAccount());
        if (this.validateMandatory(account, "account") && this.validateIBAN(account = Strings.whiteSpaceRemoved(account).toUpperCase(Locale.US))) {
            if (!account.startsWith("CH") && !account.startsWith("LI")) {
                this.validationResult.addMessage(ValidationMessage.Type.ERROR, "account", "account_is_ch_li_iban");
            } else if (account.length() != 21) {
                this.validationResult.addMessage(ValidationMessage.Type.ERROR, "account", "account_is_valid_iban");
            } else {
                this.billOut.setAccount(account);
            }
        }
    }

    private void validateCreditor() {
        Address creditor = this.validatePerson(this.billIn.getCreditor(), "creditor", true);
        this.billOut.setCreditor(creditor);
    }

    private void validateReference() {
        String account = this.billOut.getAccount();
        boolean isValidAccount = account != null;
        boolean isQRBillIBAN = account != null && account.charAt(4) == '3' && (account.charAt(5) == '0' || account.charAt(5) == '1');
        String reference = Strings.trimmed(this.billIn.getReference());
        if (reference != null) {
            reference = Strings.whiteSpaceRemoved(reference);
        }
        if (isQRBillIBAN) {
            if (reference == null) {
                this.validationResult.addMessage(ValidationMessage.Type.ERROR, "reference", "mandatory_for_qr_iban");
                return;
            }
            if (reference.length() < 27) {
                reference = "00000000000000000000000000".substring(0, 27 - reference.length()) + reference;
            }
            if (!Payments.isValidQRReference(reference)) {
                this.validationResult.addMessage(ValidationMessage.Type.ERROR, "reference", "valid_qr_ref_no");
            } else {
                this.billOut.setReference(reference);
            }
        } else if (isValidAccount && reference != null) {
            if (!Payments.isValidISO11649Reference(reference)) {
                this.validationResult.addMessage(ValidationMessage.Type.ERROR, "reference", "valid_iso11649_creditor_ref");
            } else {
                this.billOut.setReference(reference);
            }
        } else {
            this.billOut.setReference(null);
        }
    }

    private void validateUnstructuredMessage() {
        String unstructuredMessage = Strings.trimmed(this.billIn.getUnstructuredMessage());
        unstructuredMessage = this.clippedValue(unstructuredMessage, 140, "unstructuredMessage");
        this.billOut.setUnstructuredMessage(unstructuredMessage);
    }

    private void validateBillInformation() {
        String billInformation = Strings.trimmed(this.billIn.getBillInformation());
        billInformation = this.clippedValue(billInformation, 140, "billInformation");
        this.billOut.setBillInformation(billInformation);
    }

    private void validateAlternativeSchemes() {
        AlternativeScheme[] schemesOut = null;
        if (this.billIn.getAlternativeSchemes() != null) {
            int len = this.billIn.getAlternativeSchemes().length;
            ArrayList<AlternativeScheme> schemeList = new ArrayList<AlternativeScheme>(len);
            for (AlternativeScheme schemeIn : this.billIn.getAlternativeSchemes()) {
                AlternativeScheme schemeOut = new AlternativeScheme();
                schemeOut.setName(Strings.trimmed(schemeIn.getName()));
                schemeOut.setInstruction(Strings.trimmed(schemeIn.getInstruction()));
                if (schemeOut.getName() == null && schemeOut.getInstruction() == null) continue;
                if (schemeList.size() == 2) {
                    this.validationResult.addMessage(ValidationMessage.Type.ERROR, "altSchemes", "alt_scheme_max_exceed");
                    continue;
                }
                schemeList.add(schemeOut);
            }
            if (schemeList.size() > 0) {
                schemesOut = schemeList.toArray(new AlternativeScheme[0]);
            }
        }
        this.billOut.setAlternativeSchemes(schemesOut);
    }

    private void validateDebtor() {
        Address debtor = this.validatePerson(this.billIn.getDebtor(), "debtor", false);
        this.billOut.setDebtor(debtor);
    }

    private Address validatePerson(Address addressIn, String fieldRoot, boolean mandatory) {
        Address addressOut = this.cleanedPerson(addressIn, fieldRoot);
        if (addressOut == null) {
            if (mandatory) {
                this.validationResult.addMessage(ValidationMessage.Type.ERROR, fieldRoot + ".name", "field_is_mandatory");
                this.validationResult.addMessage(ValidationMessage.Type.ERROR, fieldRoot + ".postalCode", "field_is_mandatory");
                this.validationResult.addMessage(ValidationMessage.Type.ERROR, fieldRoot + ".addressLine2", "field_is_mandatory");
                this.validationResult.addMessage(ValidationMessage.Type.ERROR, fieldRoot + ".town", "field_is_mandatory");
                this.validationResult.addMessage(ValidationMessage.Type.ERROR, fieldRoot + ".countryCode", "field_is_mandatory");
            }
            return null;
        }
        if (addressOut.getType() == Address.Type.CONFLICTING) {
            if (addressOut.getAddressLine1() != null) {
                this.validationResult.addMessage(ValidationMessage.Type.ERROR, fieldRoot + ".addressLine1", "adress_type_conflict");
            }
            if (addressOut.getAddressLine2() != null) {
                this.validationResult.addMessage(ValidationMessage.Type.ERROR, fieldRoot + ".addressLine2", "adress_type_conflict");
            }
            if (addressOut.getStreet() != null) {
                this.validationResult.addMessage(ValidationMessage.Type.ERROR, fieldRoot + ".street", "adress_type_conflict");
            }
            if (addressOut.getHouseNo() != null) {
                this.validationResult.addMessage(ValidationMessage.Type.ERROR, fieldRoot + ".houseNo", "adress_type_conflict");
            }
            if (addressOut.getPostalCode() != null) {
                this.validationResult.addMessage(ValidationMessage.Type.ERROR, fieldRoot + ".postalCode", "adress_type_conflict");
            }
            if (addressOut.getTown() != null) {
                this.validationResult.addMessage(ValidationMessage.Type.ERROR, fieldRoot + ".town", "adress_type_conflict");
            }
        }
        if (addressOut.getCountryCode() != null) {
            addressOut.setCountryCode(addressOut.getCountryCode().toUpperCase(Locale.US));
        }
        this.validateMandatory(addressOut.getName(), fieldRoot, ".name");
        if (addressOut.getType() == Address.Type.STRUCTURED || addressOut.getType() == Address.Type.UNDETERMINED) {
            this.validateMandatory(addressOut.getPostalCode(), fieldRoot, ".postalCode");
            this.validateMandatory(addressOut.getTown(), fieldRoot, ".town");
        }
        if (addressOut.getType() == Address.Type.COMBINED_ELEMENTS || addressOut.getType() == Address.Type.UNDETERMINED) {
            this.validateMandatory(addressOut.getAddressLine2(), fieldRoot, ".addressLine2");
        }
        this.validateMandatory(addressOut.getCountryCode(), fieldRoot, ".countryCode");
        addressOut.setName(this.clippedValue(addressOut.getName(), 70, fieldRoot, ".name"));
        if (addressOut.getType() == Address.Type.STRUCTURED) {
            addressOut.setStreet(this.clippedValue(addressOut.getStreet(), 70, fieldRoot, ".street"));
            addressOut.setHouseNo(this.clippedValue(addressOut.getHouseNo(), 16, fieldRoot, ".houseNo"));
            addressOut.setPostalCode(this.clippedValue(addressOut.getPostalCode(), 16, fieldRoot, ".postalCode"));
            addressOut.setTown(this.clippedValue(addressOut.getTown(), 35, fieldRoot, ".town"));
        }
        if (addressOut.getType() == Address.Type.COMBINED_ELEMENTS) {
            addressOut.setAddressLine1(this.clippedValue(addressOut.getAddressLine1(), 70, fieldRoot, ".addressLine1"));
            addressOut.setAddressLine2(this.clippedValue(addressOut.getAddressLine2(), 70, fieldRoot, ".addressLine2"));
        }
        if (!(addressOut.getCountryCode() == null || addressOut.getCountryCode().length() == 2 && Payments.isAlphaNumeric(addressOut.getCountryCode()))) {
            this.validationResult.addMessage(ValidationMessage.Type.ERROR, fieldRoot + ".countryCode", "valid_country_code");
        }
        return addressOut;
    }

    private boolean validateIBAN(String iban) {
        if (!Payments.isValidIBAN(iban)) {
            this.validationResult.addMessage(ValidationMessage.Type.ERROR, "account", "account_is_valid_iban");
            return false;
        }
        return true;
    }

    private Address cleanedPerson(Address addressIn, String fieldRoot) {
        if (addressIn == null) {
            return null;
        }
        Address addressOut = new Address();
        addressOut.setName(this.cleanedValue(addressIn.getName(), fieldRoot, ".name"));
        String value = this.cleanedValue(addressIn.getAddressLine1(), fieldRoot, ".addressLine1");
        if (value != null) {
            addressOut.setAddressLine1(value);
        }
        if ((value = this.cleanedValue(addressIn.getAddressLine2(), fieldRoot, ".addressLine2")) != null) {
            addressOut.setAddressLine2(value);
        }
        if ((value = this.cleanedValue(addressIn.getStreet(), fieldRoot, ".street")) != null) {
            addressOut.setStreet(value);
        }
        if ((value = this.cleanedValue(addressIn.getHouseNo(), fieldRoot, ".houseNo")) != null) {
            addressOut.setHouseNo(value);
        }
        if ((value = this.cleanedValue(addressIn.getPostalCode(), fieldRoot, ".postalCode")) != null) {
            addressOut.setPostalCode(value);
        }
        if ((value = this.cleanedValue(addressIn.getTown(), fieldRoot, ".town")) != null) {
            addressOut.setTown(value);
        }
        addressOut.setCountryCode(Strings.trimmed(addressIn.getCountryCode()));
        if (addressOut.getName() == null && addressOut.getCountryCode() == null && addressOut.getType() == Address.Type.UNDETERMINED) {
            return null;
        }
        return addressOut;
    }

    private boolean validateMandatory(String value, String field) {
        if (Strings.isNullOrEmpty(value)) {
            this.validationResult.addMessage(ValidationMessage.Type.ERROR, field, "field_is_mandatory");
            return false;
        }
        return true;
    }

    private void validateMandatory(String value, String fieldRoot, String subfield) {
        if (Strings.isNullOrEmpty(value)) {
            this.validationResult.addMessage(ValidationMessage.Type.ERROR, fieldRoot + subfield, "field_is_mandatory");
        }
    }

    private String clippedValue(String value, int maxLength, String field) {
        if (value != null && value.length() > maxLength) {
            this.validationResult.addMessage(ValidationMessage.Type.WARNING, field, "field_clipped", new String[]{Integer.toString(maxLength)});
            return value.substring(0, maxLength);
        }
        return value;
    }

    private String clippedValue(String value, int maxLength, String fieldRoot, String subfield) {
        if (value != null && value.length() > maxLength) {
            this.validationResult.addMessage(ValidationMessage.Type.WARNING, fieldRoot + subfield, "field_clipped", new String[]{Integer.toString(maxLength)});
            return value.substring(0, maxLength);
        }
        return value;
    }

    private String cleanedValue(String value, String fieldRoot, String subfield) {
        Payments.CleaningResult result = new Payments.CleaningResult();
        Payments.cleanValue(value, result);
        if (result.replacedUnsupportedChars) {
            this.validationResult.addMessage(ValidationMessage.Type.WARNING, fieldRoot + subfield, "replaced_unsupported_characters");
        }
        return result.cleanedString;
    }
}

