/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.qrbill.generator;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.codecrete.qrbill.generator.Bill;
import net.codecrete.qrbill.generator.ValidationMessage;

public class ValidationResult
implements Serializable {
    private static final long serialVersionUID = -791181851684443602L;
    private static final List<ValidationMessage> EMPTY_LIST = Collections.emptyList();
    private List<ValidationMessage> validationMessages;
    private Bill cleanedBill;

    public List<ValidationMessage> getValidationMessages() {
        if (this.validationMessages == null) {
            return EMPTY_LIST;
        }
        return this.validationMessages;
    }

    public boolean hasMessages() {
        return this.validationMessages != null;
    }

    public boolean hasWarnings() {
        if (this.validationMessages == null) {
            return false;
        }
        for (ValidationMessage message : this.validationMessages) {
            if (message.getType() != ValidationMessage.Type.WARNING) continue;
            return true;
        }
        return false;
    }

    public boolean hasErrors() {
        if (this.validationMessages == null) {
            return false;
        }
        for (ValidationMessage message : this.validationMessages) {
            if (message.getType() != ValidationMessage.Type.ERROR) continue;
            return true;
        }
        return false;
    }

    public boolean isValid() {
        return !this.hasErrors();
    }

    public void addMessage(ValidationMessage.Type type, String field, String messageKey) {
        ValidationMessage message = new ValidationMessage(type, field, messageKey);
        if (this.validationMessages == null) {
            this.validationMessages = new ArrayList<ValidationMessage>();
        }
        this.validationMessages.add(message);
    }

    public void addMessage(ValidationMessage.Type type, String field, String messageKey, String[] messageParameters) {
        ValidationMessage message = new ValidationMessage(type, field, messageKey, messageParameters);
        if (this.validationMessages == null) {
            this.validationMessages = new ArrayList<ValidationMessage>();
        }
        this.validationMessages.add(message);
    }

    public Bill getCleanedBill() {
        return this.cleanedBill;
    }

    public void setCleanedBill(Bill cleanedBill) {
        this.cleanedBill = cleanedBill;
    }
}

