/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.qrbill.generator;

import java.awt.geom.AffineTransform;
import java.io.IOException;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import net.codecrete.qrbill.canvas.Canvas;
import net.codecrete.qrbill.generator.Address;
import net.codecrete.qrbill.generator.AlternativeScheme;
import net.codecrete.qrbill.generator.Bill;
import net.codecrete.qrbill.generator.MultilingualText;
import net.codecrete.qrbill.generator.OutputSize;
import net.codecrete.qrbill.generator.Payments;
import net.codecrete.qrbill.generator.QRCode;
import net.codecrete.qrbill.generator.SeparatorType;

class BillLayout {
    private static final double PT_TO_MM = 0.35277777777777775;
    private static final double MM_TO_PT = 2.834645669291339;
    private static final int FONT_SIZE_TITLE = 11;
    private static final int PP_LABEL_PREF_FONT_SIZE = 8;
    private static final int PP_TEXT_PREF_FONT_SIZE = 10;
    private static final int PP_TEXT_MIN_FONT_SIZE = 8;
    private static final int RC_LABEL_PREF_FONT_SIZE = 6;
    private static final int RC_TEXT_PREF_FONT_SIZE = 8;
    private static final double SLIP_WIDTH = 210.22;
    private static final double SLIP_HEIGHT = 105.11;
    private static final double PAYMEMT_PART_WIDTH = 148.65;
    private static final double RECEIPT_WIDTH = 61.56999999999999;
    private static final double MARGIN = 5.0;
    private static final double QR_CODE_SIZE = 46.0;
    private static final double INFO_SECTION_WIDTH = 81.0;
    private static final double CURRENCY_AMOUNT_BASE_LINE = 32.0;
    private static final double CURRENCY_WIDTH_PP = 15.0;
    private static final double CURRENCY_WIDTH_RC = 13.0;
    private static final double AMOUNT_BOX_WIDTH_PP = 40.0;
    private static final double AMOUNT_BOX_HEIGHT_PP = 15.0;
    private static final double AMOUNT_BOX_WIDTH_RC = 30.0;
    private static final double AMOUNT_BOX_HEIGHT_RC = 10.0;
    private static final double DEBTOR_BOX_HEIGHT_PP = 25.0;
    private static final double DEBTOR_BOX_HEIGHT_RC = 25.0;
    private static final double ALTERNATIVE_SCHEMES_HEIGHT = 6.0;
    private static final double INFO_SECTION_MAX_HEIGHT = 84.11;
    private static final double RECEIPT_MAX_HEIGHT = 60.61;
    private static final double LEADING_PREF = 0.2;
    private static final double PADDING_PREF = 0.5;
    private static final double PADDING_MIN = 0.2;
    private static final double ELLIPSIS_WIDTH = 0.3528;
    private Bill bill;
    private QRCode qrCode;
    private Canvas graphics;
    private String accountPayableTo;
    private String reference;
    private String additionalInfo;
    private String payableBy;
    private String amount;
    private String[] accountPayableToLines;
    private String[] additionalInfoLines;
    private String[] payableByLines;
    private double yPos;
    private int labelFontSize;
    private int textFontSize;
    private double labelLeading;
    private double textLeading;
    private double textBottomPadding;
    private static final double CORNER_STROKE_WIDTH = 0.75;
    private static final DecimalFormat amountDisplayFormat = new DecimalFormat("###,##0.00");

    BillLayout(Bill bill, Canvas graphics) {
        this.bill = bill;
        this.qrCode = new QRCode(bill);
        this.graphics = graphics;
    }

    void draw() throws IOException {
        this.prepareText();
        this.labelFontSize = 8;
        this.textFontSize = 10;
        while (true) {
            this.breakLines(81.0);
            boolean isTooTight = this.computePaymentPartLeading();
            if (!isTooTight || this.textFontSize == 8) break;
            --this.labelFontSize;
            --this.textFontSize;
        }
        this.drawPaymentPart();
        this.labelFontSize = 6;
        this.textFontSize = 8;
        this.breakLines(51.56999999999999);
        this.computeReceiptLeading();
        this.drawReceipt();
        this.drawBorder();
    }

    private void drawPaymentPart() throws IOException {
        this.qrCode.draw(this.graphics, 66.57, 42.11);
        this.graphics.setTransformation(66.57, 0.0, 0.0, 1.0, 1.0);
        this.yPos = 100.11 - this.graphics.getAscender(11);
        this.graphics.putText(MultilingualText.getText("payment_part", this.bill.getFormat().getLanguage()), 0.0, this.yPos, 11, true);
        this.yPos = 32.0 + this.graphics.getAscender(this.labelFontSize);
        this.drawLabelAndText("currency", this.bill.getCurrency());
        this.graphics.setTransformation(81.57, 0.0, 0.0, 1.0, 1.0);
        this.yPos = 32.0 + this.graphics.getAscender(this.labelFontSize);
        if (this.amount != null) {
            this.drawLabelAndText("amount", this.amount);
        } else {
            this.drawLabel("amount");
            this.drawCorners(0.0, this.yPos - 15.0, 40.0, 15.0);
        }
        this.graphics.setTransformation(124.22, 0.0, 0.0, 1.0, 1.0);
        this.yPos = 100.11;
        this.drawLabelAndTextLines("account_payable_to", this.accountPayableToLines);
        if (this.reference != null) {
            this.drawLabelAndText("reference", this.reference);
        }
        if (this.additionalInfo != null) {
            this.drawLabelAndTextLines("additional_info", this.additionalInfoLines);
        }
        if (this.payableBy != null) {
            this.drawLabelAndTextLines("payable_by", this.payableByLines);
        } else {
            this.drawLabel("payable_by_name_addr");
            this.yPos -= 25.0;
            this.drawCorners(0.0, this.yPos, 81.0, 25.0);
        }
        this.drawAlternativeSchemes();
    }

    private void drawReceipt() throws IOException {
        this.graphics.setTransformation(5.0, 0.0, 0.0, 1.0, 1.0);
        this.yPos = 100.11 - this.graphics.getAscender(11);
        this.graphics.putText(MultilingualText.getText("receipt", this.bill.getFormat().getLanguage()), 0.0, this.yPos, 11, true);
        this.yPos = 93.11;
        this.drawLabelAndTextLines("account_payable_to", this.accountPayableToLines);
        if (this.reference != null) {
            this.drawLabelAndText("reference", this.reference);
        }
        if (this.payableBy != null) {
            this.drawLabelAndTextLines("payable_by", this.payableByLines);
        } else {
            this.drawLabel("payable_by_name_addr");
            this.yPos -= 25.0;
            this.drawCorners(0.0, this.yPos, 51.56999999999999, 25.0);
        }
        this.yPos = 32.0 + this.graphics.getAscender(this.labelFontSize);
        this.drawLabelAndText("currency", this.bill.getCurrency());
        this.graphics.setTransformation(18.0, 0.0, 0.0, 1.0, 1.0);
        this.yPos = 32.0 + this.graphics.getAscender(this.labelFontSize);
        if (this.amount != null) {
            this.drawLabelAndText("amount", this.amount);
        } else {
            this.drawLabel("amount");
            this.graphics.setTransformation(0.0, 0.0, 0.0, 1.0, 1.0);
            this.drawCorners(26.569999999999993, 24.0, 30.0, 10.0);
        }
        this.graphics.setTransformation(0.0, 0.0, 0.0, 1.0, 1.0);
        String label = MultilingualText.getText("acceptance_point", this.bill.getFormat().getLanguage());
        double w = this.graphics.getTextWidth(label, this.labelFontSize, true);
        this.graphics.putText(label, 56.56999999999999 - w, 21.0, this.labelFontSize, true);
    }

    private void drawAlternativeSchemes() throws IOException {
        if (this.bill.getAlternativeSchemes() == null || this.bill.getAlternativeSchemes().length == 0) {
            return;
        }
        this.graphics.setTransformation(66.57, 0.0, 0.0, 1.0, 1.0);
        double y = 11.0 - this.graphics.getAscender(7);
        double maxWidth = 138.65;
        for (AlternativeScheme scheme : this.bill.getAlternativeSchemes()) {
            String boldText = String.format("%s: ", scheme.getName());
            double boldTextWidth = this.graphics.getTextWidth(boldText, 7, true);
            this.graphics.putText(boldText, 0.0, y, 7, true);
            String normalText = this.truncateText(scheme.getInstruction(), maxWidth - boldTextWidth, 7);
            this.graphics.putText(normalText, boldTextWidth, y, 7, false);
            y -= this.graphics.getLineHeight(7) * 1.2;
        }
    }

    private boolean computePaymentPartLeading() {
        int numTextLines = 0;
        int numPaddings = 0;
        double height = 0.0;
        numTextLines += 1 + this.accountPayableToLines.length;
        height -= this.graphics.getAscender(this.textFontSize) - this.graphics.getAscender(this.labelFontSize);
        if (this.reference != null) {
            ++numPaddings;
            numTextLines += 2;
        }
        if (this.additionalInfo != null) {
            ++numPaddings;
            numTextLines += 1 + this.additionalInfoLines.length;
        }
        ++numPaddings;
        if (this.payableBy != null) {
            numTextLines += 1 + this.payableByLines.length;
        } else {
            ++numTextLines;
            height += 25.0;
        }
        return this.computeLeading(height += (double)numTextLines * this.graphics.getLineHeight(this.textFontSize), 84.11, numTextLines, numPaddings);
    }

    private void computeReceiptLeading() {
        int numTextLines = 0;
        int numPaddings = 1;
        double height = 0.0;
        numTextLines += 1 + this.accountPayableToLines.length;
        height -= this.graphics.getAscender(this.textFontSize) - this.graphics.getAscender(this.labelFontSize);
        if (this.reference != null) {
            ++numPaddings;
            numTextLines += 2;
        }
        ++numPaddings;
        if (this.payableBy != null) {
            numTextLines += 1 + this.payableByLines.length;
        } else {
            ++numTextLines;
            height += 25.0;
        }
        this.computeLeading(height += (double)numTextLines * this.graphics.getLineHeight(this.textFontSize), 60.61, numTextLines, numPaddings);
    }

    private boolean computeLeading(double height, double maxHeight, int numTextLines, int numPaddings) {
        boolean isTooTight = false;
        this.textLeading = 0.2 * (double)this.textFontSize * 0.35277777777777775;
        if (height + (double)numTextLines * this.textLeading > maxHeight) {
            isTooTight = true;
            if (height > maxHeight) {
                this.textLeading = 0.0;
                this.labelLeading = 0.0;
            } else {
                this.textLeading = (maxHeight - height) / (double)numTextLines;
                this.labelLeading = this.textLeading + this.graphics.getDescender(this.textFontSize) - this.graphics.getDescender(this.labelFontSize);
            }
        } else {
            this.labelLeading = this.textLeading + this.graphics.getDescender(this.textFontSize) - this.graphics.getDescender(this.labelFontSize);
        }
        double prefPadding = (double)this.textFontSize * 0.5 * 0.35277777777777775;
        double minPadding = (double)this.textFontSize * 0.2 * 0.35277777777777775;
        this.textBottomPadding = (maxHeight - height - (double)numTextLines * this.textLeading) / (double)numPaddings;
        if (this.textBottomPadding > prefPadding) {
            this.textBottomPadding = prefPadding;
        } else if (this.textBottomPadding < minPadding) {
            isTooTight = true;
            if (this.textBottomPadding < 0.0) {
                this.textBottomPadding = 0.0;
            }
        }
        return isTooTight;
    }

    private void drawBorder() throws IOException {
        SeparatorType separatorType = this.bill.getFormat().getSeparatorType();
        OutputSize outputSize = this.bill.getFormat().getOutputSize();
        if (separatorType == SeparatorType.NONE) {
            return;
        }
        this.graphics.setTransformation(0.0, 0.0, 0.0, 1.0, 1.0);
        this.graphics.startPath();
        this.graphics.moveTo(61.56999999999999, 0.0);
        if (separatorType == SeparatorType.SOLID_LINE_WITH_SCISSORS) {
            this.graphics.lineTo(61.56999999999999, 97.11);
            this.graphics.moveTo(61.56999999999999, 100.11);
        }
        this.graphics.lineTo(61.56999999999999, 105.11);
        this.graphics.moveTo(0.0, 105.11);
        if (separatorType == SeparatorType.SOLID_LINE_WITH_SCISSORS && outputSize != OutputSize.QR_BILL_ONLY) {
            this.graphics.lineTo(5.0, 105.11);
            this.graphics.moveTo(8.0, 105.11);
        }
        this.graphics.lineTo(210.22, 105.11);
        this.graphics.strokePath(0.5, 0);
        if (separatorType == SeparatorType.SOLID_LINE_WITH_SCISSORS) {
            this.drawScissors(61.56999999999999, 100.11, 3.0, 0.0);
            if (outputSize != OutputSize.QR_BILL_ONLY) {
                this.drawScissors(5.0, 105.11, 3.0, 1.5707963267948966);
            }
        }
    }

    private void drawScissors(double x, double y, double size, double angle) throws IOException {
        this.drawScissorsBlade(x, y, size, angle, false);
        this.drawScissorsBlade(x, y, size, angle, true);
    }

    private void drawScissorsBlade(double x, double y, double size, double angle, boolean mirrored) throws IOException {
        double scale = size / 476.0;
        double xOffset = 0.36 * size;
        double yOffset = -1.05 * size;
        AffineTransform transform = new AffineTransform();
        transform.translate(x, y);
        transform.rotate(angle);
        transform.translate(mirrored ? xOffset : -xOffset, yOffset);
        transform.scale(mirrored ? -scale : scale, scale);
        this.graphics.setTransformation(transform.getTranslateX(), transform.getTranslateY(), angle, mirrored ? -scale : scale, scale);
        this.graphics.startPath();
        this.graphics.moveTo(46.48, 126.784);
        this.graphics.cubicCurveTo(34.824, 107.544, 28.0, 87.924, 28.0, 59.0);
        this.graphics.cubicCurveTo(28.0, 36.88, 33.387, 16.436, 42.507, -0.124);
        this.graphics.lineTo(242.743, 326.63);
        this.graphics.cubicCurveTo(246.359, 332.53, 254.836, 334.776, 265.31, 328.678);
        this.graphics.cubicCurveTo(276.973, 321.89, 290.532, 318.0, 305.0, 318.0);
        this.graphics.cubicCurveTo(348.63, 318.0, 384.0, 353.37, 384.0, 397.0);
        this.graphics.cubicCurveTo(384.0, 440.63, 348.63, 476.0, 305.0, 476.0);
        this.graphics.cubicCurveTo(278.066, 476.0, 254.28, 462.521, 240.02, 441.94);
        this.graphics.lineTo(46.48, 126.785);
        this.graphics.closeSubpath();
        this.graphics.moveTo(303.5, 446.0);
        this.graphics.cubicCurveTo(330.286, 446.0, 352.0, 424.286, 352.0, 397.5);
        this.graphics.cubicCurveTo(352.0, 370.714, 330.286, 349.0, 303.5, 349.0);
        this.graphics.cubicCurveTo(276.714, 349.0, 255.0, 370.714, 255.0, 397.5);
        this.graphics.cubicCurveTo(255.0, 424.286, 276.714, 446.0, 303.5, 446.0);
        this.graphics.closeSubpath();
        this.graphics.fillPath(0);
    }

    private void drawLabel(String labelKey) throws IOException {
        this.yPos -= this.graphics.getAscender(this.labelFontSize);
        this.graphics.putText(MultilingualText.getText(labelKey, this.bill.getFormat().getLanguage()), 0.0, this.yPos, this.labelFontSize, true);
        this.yPos -= this.graphics.getDescender(this.labelFontSize) + this.labelLeading;
    }

    private void drawLabelAndText(String labelKey, String text) throws IOException {
        this.drawLabel(labelKey);
        this.yPos -= this.graphics.getAscender(this.textFontSize);
        this.graphics.putText(text, 0.0, this.yPos, this.textFontSize, false);
        this.yPos -= this.graphics.getDescender(this.textFontSize) + this.textLeading + this.textBottomPadding;
    }

    private void drawLabelAndTextLines(String labelKey, String[] textLines) throws IOException {
        this.drawLabel(labelKey);
        this.yPos -= this.graphics.getAscender(this.textFontSize);
        this.graphics.putTextLines(textLines, 0.0, this.yPos, this.textFontSize, this.textLeading);
        this.yPos -= (double)textLines.length * (this.graphics.getLineHeight(this.textFontSize) + this.textLeading) - this.graphics.getAscender(this.textFontSize) + this.textBottomPadding;
    }

    private void prepareText() {
        String account = Payments.formatIBAN(this.bill.getAccount());
        this.accountPayableTo = account + "\n" + BillLayout.formatPersonForDisplay(this.bill.getCreditor());
        this.reference = BillLayout.formatReferenceNumber(this.bill.getReference());
        String info = this.bill.getUnstructuredMessage();
        if (this.bill.getBillInformation() != null) {
            info = info == null ? this.bill.getBillInformation() : info + "\n" + this.bill.getBillInformation();
        }
        if (info != null) {
            this.additionalInfo = info;
        }
        if (this.bill.getDebtor() != null) {
            this.payableBy = BillLayout.formatPersonForDisplay(this.bill.getDebtor());
        }
        if (this.bill.getAmount() != null) {
            this.amount = BillLayout.formatAmountForDisplay(this.bill.getAmount());
        }
    }

    private void breakLines(double maxWidth) {
        this.accountPayableToLines = this.graphics.splitLines(this.accountPayableTo, maxWidth * 2.834645669291339, this.textFontSize);
        if (this.additionalInfo != null) {
            this.additionalInfoLines = this.graphics.splitLines(this.additionalInfo, maxWidth * 2.834645669291339, this.textFontSize);
        }
        if (this.payableBy != null) {
            this.payableByLines = this.graphics.splitLines(this.payableBy, maxWidth * 2.834645669291339, this.textFontSize);
        }
    }

    private void drawCorners(double x, double y, double width, double height) throws IOException {
        double lwh = 0.13229166666666664;
        double s = 3.0;
        this.graphics.startPath();
        this.graphics.moveTo(x + 0.13229166666666664, y + 3.0);
        this.graphics.lineTo(x + 0.13229166666666664, y + 0.13229166666666664);
        this.graphics.lineTo(x + 3.0, y + 0.13229166666666664);
        this.graphics.moveTo(x + width - 3.0, y + 0.13229166666666664);
        this.graphics.lineTo(x + width - 0.13229166666666664, y + 0.13229166666666664);
        this.graphics.lineTo(x + width - 0.13229166666666664, y + 3.0);
        this.graphics.moveTo(x + width - 0.13229166666666664, y + height - 3.0);
        this.graphics.lineTo(x + width - 0.13229166666666664, y + height - 0.13229166666666664);
        this.graphics.lineTo(x + width - 3.0, y + height - 0.13229166666666664);
        this.graphics.moveTo(x + 3.0, y + height - 0.13229166666666664);
        this.graphics.lineTo(x + 0.13229166666666664, y + height - 0.13229166666666664);
        this.graphics.lineTo(x + 0.13229166666666664, y + height - 3.0);
        this.graphics.strokePath(0.75, 0);
    }

    private static String formatAmountForDisplay(BigDecimal amount) {
        return amountDisplayFormat.format(amount);
    }

    private static String formatPersonForDisplay(Address address) {
        StringBuilder sb = new StringBuilder();
        sb.append(address.getName());
        if (address.getType() == Address.Type.STRUCTURED) {
            String houseNo;
            String street = address.getStreet();
            if (street != null) {
                sb.append("\n");
                sb.append(street);
            }
            if ((houseNo = address.getHouseNo()) != null) {
                sb.append(street != null ? " " : "\n");
                sb.append(houseNo);
            }
            sb.append("\n");
            sb.append(address.getPostalCode());
            sb.append(" ");
            sb.append(address.getTown());
        } else if (address.getType() == Address.Type.COMBINED_ELEMENTS) {
            if (address.getAddressLine1() != null) {
                sb.append("\n");
                sb.append(address.getAddressLine1());
            }
            sb.append("\n");
            sb.append(address.getAddressLine2());
        }
        return sb.toString();
    }

    private static String formatReferenceNumber(String refNo) {
        if (refNo == null) {
            return null;
        }
        int len = (refNo = refNo.trim()).length();
        if (len == 0) {
            return null;
        }
        if (refNo.startsWith("RF")) {
            return Payments.formatIBAN(refNo);
        }
        return Payments.formatQRReferenceNumber(refNo);
    }

    private String truncateText(String text, double maxWidth, int fontSize) {
        if (this.graphics.getTextWidth(text, fontSize, false) < maxWidth) {
            return text;
        }
        String[] lines = this.graphics.splitLines(text, maxWidth - (double)fontSize * 0.3528, fontSize);
        return lines[0] + "\u2026";
    }

    static {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.US);
        symbols.setDecimalSeparator('.');
        symbols.setGroupingSeparator(' ');
        amountDisplayFormat.setDecimalFormatSymbols(symbols);
    }
}

