/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.qrbill.generator;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Objects;
import net.codecrete.qrbill.generator.Address;
import net.codecrete.qrbill.generator.AlternativeScheme;
import net.codecrete.qrbill.generator.BillFormat;
import net.codecrete.qrbill.generator.Payments;

public class Bill
implements Serializable {
    private static final long serialVersionUID = -8104086304378262190L;
    public static final String SUBFIELD_NAME = ".name";
    public static final String SUBFIELD_ADDRESS_LINE_1 = ".addressLine1";
    public static final String SUBFIELD_ADDRESS_LINE_2 = ".addressLine2";
    public static final String SUBFIELD_STREET = ".street";
    public static final String SUBFIELD_HOUSE_NO = ".houseNo";
    public static final String SUBFIELD_POSTAL_CODE = ".postalCode";
    public static final String SUBFIELD_TOWN = ".town";
    public static final String SUBFIELD_COUNTRY_CODE = ".countryCode";
    public static final String FIELD_QR_TYPE = "qrText";
    public static final String FIELD_VERSION = "version";
    public static final String FIELD_CODING_TYPE = "codingType";
    public static final String FIELD_LANGUAGE = "language";
    public static final String FIELD_CURRENCY = "currency";
    public static final String FIELD_AMOUNT = "amount";
    public static final String FIELD_ACCOUNT = "account";
    public static final String FIELD_REFERENCE = "reference";
    public static final String FIELDROOT_CREDITOR = "creditor";
    public static final String FIELD_CREDITOR_NAME = "creditor.name";
    public static final String FIELD_CREDITOR_STREET = "creditor.street";
    public static final String FIELD_CREDITOR_HOUSE_NO = "creditor.houseNo";
    public static final String FIELD_CREDITOR_POSTAL_CODE = "creditor.postalCode";
    public static final String FIELD_CREDITOR_TOWN = "creditor.town";
    public static final String FIELD_CREDITOR_COUNTRY_CODE = "creditor.countryCode";
    public static final String FIELD_UNSTRUCTURED_MESSAGE = "unstructuredMessage";
    public static final String FIELD_BILL_INFORMATION = "billInformation";
    public static final String FIELD_ALTERNATIVE_SCHEMES = "altSchemes";
    public static final String FIELDROOT_DEBTOR = "debtor";
    public static final String FIELD_DEBTOR_NAME = "debtor.name";
    public static final String FIELD_DEBTOR_STREET = "debtor.street";
    public static final String FIELD_DEBTOR_HOUSE_NO = "debtor.houseNo";
    public static final String FIELD_DEBTOR_POSTAL_CODE = "debtor.postalCode";
    public static final String FIELD_DEBTOR_TOWN = "debtor.town";
    public static final String FIELD_DEBTOR_COUNTRY_CODE = "debtor.countryCode";
    private Version version = Version.V2_0;
    private BigDecimal amount = null;
    private String currency = "CHF";
    private String account = null;
    private Address creditor = new Address();
    private String reference = null;
    private Address debtor = null;
    private String unstructuredMessage = null;
    private String billInformation = null;
    private AlternativeScheme[] alternativeSchemes = null;
    private BillFormat format = new BillFormat();

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public Double getAmountAsDouble() {
        if (this.amount != null) {
            return this.amount.doubleValue();
        }
        return null;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public void setAmountFromDouble(Double amount) {
        this.amount = amount != null ? new BigDecimal(amount).setScale(2, RoundingMode.HALF_UP) : null;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getAccount() {
        return this.account;
    }

    public void setAccount(String account) {
        this.account = account;
    }

    public Address getCreditor() {
        return this.creditor;
    }

    public void setCreditor(Address creditor) {
        this.creditor = creditor;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public void createAndSetCreditorReference(String rawReference) {
        this.setReference(Payments.createISO11649Reference(rawReference));
    }

    public Address getDebtor() {
        return this.debtor;
    }

    public void setDebtor(Address debtor) {
        this.debtor = debtor;
    }

    public String getUnstructuredMessage() {
        return this.unstructuredMessage;
    }

    public void setUnstructuredMessage(String unstructuredMessage) {
        this.unstructuredMessage = unstructuredMessage;
    }

    public String getBillInformation() {
        return this.billInformation;
    }

    public void setBillInformation(String billInformation) {
        this.billInformation = billInformation;
    }

    public AlternativeScheme[] getAlternativeSchemes() {
        return this.alternativeSchemes;
    }

    public void setAlternativeSchemes(AlternativeScheme[] alternativeSchemes) {
        this.alternativeSchemes = alternativeSchemes;
    }

    public BillFormat getFormat() {
        return this.format;
    }

    public void setFormat(BillFormat format) {
        this.format = format;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bill bill = (Bill)o;
        return this.version == bill.version && Objects.equals(this.amount, bill.amount) && Objects.equals(this.currency, bill.currency) && Objects.equals(this.account, bill.account) && Objects.equals(this.creditor, bill.creditor) && Objects.equals(this.reference, bill.reference) && Objects.equals(this.debtor, bill.debtor) && Objects.equals(this.unstructuredMessage, bill.unstructuredMessage) && Objects.equals(this.billInformation, bill.billInformation) && Arrays.equals(this.alternativeSchemes, bill.alternativeSchemes) && Objects.equals(this.format, bill.format);
    }

    public int hashCode() {
        int result = Objects.hash(new Object[]{this.version, this.amount, this.currency, this.account, this.creditor, this.reference, this.debtor, this.unstructuredMessage, this.billInformation, this.format});
        result = 31 * result + Arrays.hashCode(this.alternativeSchemes);
        return result;
    }

    public String toString() {
        return "Bill{version=" + (Object)((Object)this.version) + ", amount=" + this.amount + ", currency='" + this.currency + '\'' + ", account='" + this.account + '\'' + ", creditor=" + this.creditor + ", reference='" + this.reference + '\'' + ", debtor=" + this.debtor + ", unstructuredMessage='" + this.unstructuredMessage + '\'' + ", billInformation='" + this.billInformation + '\'' + ", alternativeSchemes=" + Arrays.toString(this.alternativeSchemes) + ", format=" + this.format + '}';
    }

    public static enum Version {
        V2_0;

    }
}

