/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.qrbill.canvas;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.codecrete.qrbill.canvas.AbstractCanvas;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType1Font;
import org.apache.pdfbox.util.Matrix;

public class PDFCanvas
extends AbstractCanvas {
    private PDDocument document;
    private PDPageContentStream contentStream;
    private int lastStrokingColor = 0;
    private int lastNonStrokingColor = 0;
    private double lastLineWidth = 1.0;
    private boolean hasSavedGraphicsState = false;

    @Override
    public void setupPage(double width, double height, String fontFamilyList) throws IOException {
        this.setupFontMetrics("Helvetica");
        this.document = new PDDocument();
        this.document.getDocumentInformation().setTitle("Swiss QR Bill");
        PDPage page = new PDPage(new PDRectangle((float)(width * 2.834645669291339), (float)(height * 2.834645669291339)));
        this.document.addPage(page);
        this.contentStream = new PDPageContentStream(this.document, page, PDPageContentStream.AppendMode.OVERWRITE, true);
    }

    @Override
    public void setTransformation(double translateX, double translateY, double rotate, double scaleX, double scaleY) throws IOException {
        translateX *= 2.834645669291339;
        translateY *= 2.834645669291339;
        if (this.hasSavedGraphicsState) {
            this.contentStream.restoreGraphicsState();
            this.lastStrokingColor = 0;
            this.lastNonStrokingColor = 0;
            this.lastLineWidth = 1.0;
        }
        this.contentStream.saveGraphicsState();
        this.hasSavedGraphicsState = true;
        Matrix matrix = new Matrix();
        matrix.translate((float)translateX, (float)translateY);
        if (rotate != 0.0) {
            matrix.rotate(rotate);
        }
        if (scaleX != 1.0 || scaleY != 1.0) {
            matrix.scale((float)scaleX, (float)scaleY);
        }
        this.contentStream.transform(matrix);
    }

    @Override
    public void putText(String text, double x, double y, int fontSize, boolean isBold) throws IOException {
        this.contentStream.setFont((PDFont)(isBold ? PDType1Font.HELVETICA_BOLD : PDType1Font.HELVETICA), (float)fontSize);
        this.contentStream.beginText();
        this.contentStream.newLineAtOffset((float)(x *= 2.834645669291339), (float)(y *= 2.834645669291339));
        this.contentStream.showText(text);
        this.contentStream.endText();
    }

    @Override
    public void putTextLines(String[] lines, double x, double y, int fontSize, double leading) throws IOException {
        float lineHeight = (float)((this.fontMetrics.getLineHeight(fontSize) + leading) * 2.834645669291339);
        this.contentStream.setFont((PDFont)PDType1Font.HELVETICA, (float)fontSize);
        this.contentStream.beginText();
        this.contentStream.newLineAtOffset((float)(x *= 2.834645669291339), (float)(y *= 2.834645669291339));
        boolean isFirstLine = true;
        for (String line : lines) {
            if (isFirstLine) {
                isFirstLine = false;
            } else {
                this.contentStream.newLineAtOffset(0.0f, -lineHeight);
            }
            this.contentStream.showText(line);
        }
        this.contentStream.endText();
    }

    @Override
    public void startPath() {
    }

    @Override
    public void moveTo(double x, double y) throws IOException {
        this.contentStream.moveTo((float)(x *= 2.834645669291339), (float)(y *= 2.834645669291339));
    }

    @Override
    public void lineTo(double x, double y) throws IOException {
        this.contentStream.lineTo((float)(x *= 2.834645669291339), (float)(y *= 2.834645669291339));
    }

    @Override
    public void cubicCurveTo(double x1, double y1, double x2, double y2, double x, double y) throws IOException {
        this.contentStream.curveTo((float)(x1 *= 2.834645669291339), (float)(y1 *= 2.834645669291339), (float)(x2 *= 2.834645669291339), (float)(y2 *= 2.834645669291339), (float)(x *= 2.834645669291339), (float)(y *= 2.834645669291339));
    }

    @Override
    public void addRectangle(double x, double y, double width, double height) throws IOException {
        this.contentStream.addRect((float)(x *= 2.834645669291339), (float)(y *= 2.834645669291339), (float)(width *= 2.834645669291339), (float)(height *= 2.834645669291339));
    }

    @Override
    public void closeSubpath() throws IOException {
        this.contentStream.closePath();
    }

    @Override
    public void fillPath(int color) throws IOException {
        if (color != this.lastNonStrokingColor) {
            this.lastNonStrokingColor = color;
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color >> 8 & 0xFF;
            this.contentStream.setNonStrokingColor(r, g, b);
        }
        this.contentStream.fill();
    }

    @Override
    public void strokePath(double strokeWidth, int color) throws IOException {
        if (color != this.lastStrokingColor) {
            this.lastStrokingColor = color;
            int r = color >> 16 & 0xFF;
            int g = color >> 8 & 0xFF;
            int b = color >> 8 & 0xFF;
            this.contentStream.setStrokingColor(r, g, b);
        }
        if (strokeWidth != this.lastLineWidth) {
            this.lastLineWidth = strokeWidth;
            this.contentStream.setLineWidth((float)strokeWidth);
        }
        this.contentStream.stroke();
    }

    @Override
    public byte[] getResult() throws IOException {
        if (this.contentStream != null) {
            this.contentStream.close();
            this.contentStream = null;
        }
        try (ByteArrayOutputStream os = new ByteArrayOutputStream();){
            this.document.save((OutputStream)os);
            byte[] byArray = os.toByteArray();
            return byArray;
        }
    }

    @Override
    public void close() throws IOException {
        if (this.contentStream != null) {
            this.contentStream.close();
            this.contentStream = null;
        }
        if (this.document != null) {
            this.document.close();
            this.document = null;
        }
    }
}

