/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.qrbill.generator;

import java.util.Locale;
import net.codecrete.qrbill.generator.Address;
import net.codecrete.qrbill.generator.Bill;
import net.codecrete.qrbill.generator.Payments;
import net.codecrete.qrbill.generator.Strings;
import net.codecrete.qrbill.generator.ValidationMessage;
import net.codecrete.qrbill.generator.ValidationResult;

class Validator {
    private final Bill billIn;
    private final Bill billOut;
    private final ValidationResult validationResult;

    static ValidationResult validate(Bill bill) {
        Validator validator = new Validator(bill);
        return validator.validateBill();
    }

    private Validator(Bill bill) {
        this.billIn = bill;
        this.billOut = new Bill();
        this.validationResult = new ValidationResult();
    }

    private ValidationResult validateBill() {
        this.billOut.setLanguage(this.billIn.getLanguage());
        this.billOut.setVersion(this.billIn.getVersion());
        this.validateCurrency();
        this.validateAmount();
        boolean isQRBillIBAN = this.validateAccountNumber();
        this.validateCreditor();
        this.validateFinalCreditor();
        this.validateReferenceNo(isQRBillIBAN);
        this.validateAdditionalInformation();
        this.validateDebtor();
        this.validateDueDate();
        this.validationResult.setCleanedBill(this.billOut);
        return this.validationResult;
    }

    private void validateCurrency() {
        String currency = Strings.trimmed(this.billIn.getCurrency());
        if (this.validateMandatory(currency, "currency")) {
            if (!"CHF".equals(currency = currency.toUpperCase(Locale.US)) && !"EUR".equals(currency)) {
                this.validationResult.addMessage(ValidationMessage.Type.ERROR, "currency", "currency_is_chf_or_eur");
            } else {
                this.billOut.setCurrency(currency);
            }
        }
    }

    private void validateAmount() {
        Double amount = this.billIn.getAmount();
        if (amount == null) {
            this.billOut.setAmount(null);
        } else if ((amount = Double.valueOf((double)Math.round(amount * 100.0) / 100.0)) < 0.01 || amount > 9.9999999999E8) {
            this.validationResult.addMessage(ValidationMessage.Type.ERROR, "amount", "amount_in_valid_range");
        } else {
            this.billOut.setAmount(amount);
        }
    }

    private boolean validateAccountNumber() {
        boolean isQRBillIBAN = false;
        String account = Strings.trimmed(this.billIn.getAccount());
        if (this.validateMandatory(account, "account") && this.validateIBAN(account = Strings.whiteSpaceRemoved(account).toUpperCase(Locale.US))) {
            if (!account.startsWith("CH") && !account.startsWith("LI")) {
                this.validationResult.addMessage(ValidationMessage.Type.ERROR, "account", "account_is_ch_li_iban");
            } else if (account.length() != 21) {
                this.validationResult.addMessage(ValidationMessage.Type.ERROR, "account", "account_is_valid_iban");
            } else {
                this.billOut.setAccount(account);
                isQRBillIBAN = account.charAt(4) == '3' && (account.charAt(5) == '0' || account.charAt(5) == '1');
            }
        }
        return isQRBillIBAN;
    }

    private void validateCreditor() {
        Address creditor = this.validatePerson(this.billIn.getCreditor(), "creditor", true);
        this.billOut.setCreditor(creditor);
    }

    private void validateFinalCreditor() {
        Address finalCreditor = this.validatePerson(this.billIn.getFinalCreditor(), "finalCreditor", false);
        this.billOut.setFinalCreditor(finalCreditor);
    }

    private void validateReferenceNo(boolean isQRBillIBAN) {
        String referenceNo = Strings.trimmed(this.billIn.getReferenceNo());
        if (referenceNo == null) {
            if (isQRBillIBAN) {
                this.validationResult.addMessage(ValidationMessage.Type.ERROR, "referenceNo", "mandatory_for_qr_iban");
            }
            return;
        }
        if ((referenceNo = Strings.whiteSpaceRemoved(referenceNo)).startsWith("RF")) {
            if (!Payments.isValidISO11649Reference(referenceNo)) {
                this.validationResult.addMessage(ValidationMessage.Type.ERROR, "referenceNo", "valid_iso11649_creditor_ref");
            } else {
                this.billOut.setReferenceNo(referenceNo);
            }
        } else {
            if (referenceNo.length() < 27) {
                referenceNo = "00000000000000000000000000".substring(0, 27 - referenceNo.length()) + referenceNo;
            }
            if (!Payments.isValidQRReferenceNo(referenceNo)) {
                this.validationResult.addMessage(ValidationMessage.Type.ERROR, "referenceNo", "valid_qr_ref_no");
            } else {
                this.billOut.setReferenceNo(referenceNo);
            }
        }
    }

    private void validateAdditionalInformation() {
        String additionalInfo = Strings.trimmed(this.billIn.getAdditionalInfo());
        additionalInfo = this.clippedValue(additionalInfo, 140, "additionalInfo");
        this.billOut.setAdditionalInfo(additionalInfo);
    }

    private void validateDebtor() {
        Address debtor = this.validatePerson(this.billIn.getDebtor(), "debtor", false);
        this.billOut.setDebtor(debtor);
    }

    private void validateDueDate() {
        this.billOut.setDueDate(this.billIn.getDueDate());
    }

    private Address validatePerson(Address addressIn, String fieldRoot, boolean mandatory) {
        Address addressOut = this.cleanedPerson(addressIn, fieldRoot);
        if (addressOut == null) {
            if (mandatory) {
                this.validationResult.addMessage(ValidationMessage.Type.ERROR, fieldRoot + ".name", "field_is_mandatory");
                this.validationResult.addMessage(ValidationMessage.Type.ERROR, fieldRoot + ".postalCode", "field_is_mandatory");
                this.validationResult.addMessage(ValidationMessage.Type.ERROR, fieldRoot + ".town", "field_is_mandatory");
                this.validationResult.addMessage(ValidationMessage.Type.ERROR, fieldRoot + ".countryCode", "field_is_mandatory");
            }
            return null;
        }
        if (addressOut.getCountryCode() != null) {
            addressOut.setCountryCode(addressOut.getCountryCode().toUpperCase(Locale.US));
        }
        this.validateMandatory(addressOut.getName(), fieldRoot, ".name");
        this.validateMandatory(addressOut.getPostalCode(), fieldRoot, ".postalCode");
        this.validateMandatory(addressOut.getTown(), fieldRoot, ".town");
        this.validateMandatory(addressOut.getCountryCode(), fieldRoot, ".countryCode");
        addressOut.setName(this.clippedValue(addressOut.getName(), 70, fieldRoot, ".name"));
        addressOut.setStreet(this.clippedValue(addressOut.getStreet(), 70, fieldRoot, ".street"));
        addressOut.setHouseNo(this.clippedValue(addressOut.getHouseNo(), 16, fieldRoot, ".houseNo"));
        addressOut.setPostalCode(this.clippedValue(addressOut.getPostalCode(), 16, fieldRoot, ".postalCode"));
        addressOut.setTown(this.clippedValue(addressOut.getTown(), 35, fieldRoot, ".town"));
        if (!(addressOut.getCountryCode() == null || addressOut.getCountryCode().length() == 2 && Payments.isAlphaNumeric(addressOut.getCountryCode()))) {
            this.validationResult.addMessage(ValidationMessage.Type.ERROR, fieldRoot + ".countryCode", "valid_country_code");
        }
        return addressOut;
    }

    private boolean validateIBAN(String iban) {
        if (!Payments.isValidIBAN(iban)) {
            this.validationResult.addMessage(ValidationMessage.Type.ERROR, "account", "account_is_valid_iban");
            return false;
        }
        return true;
    }

    private Address cleanedPerson(Address addressIn, String fieldRoot) {
        if (addressIn == null) {
            return null;
        }
        Address addressOut = new Address();
        addressOut.setName(this.cleanedValue(addressIn.getName(), fieldRoot, ".name"));
        addressOut.setStreet(this.cleanedValue(addressIn.getStreet(), fieldRoot, ".street"));
        addressOut.setHouseNo(this.cleanedValue(addressIn.getHouseNo(), fieldRoot, ".houseNo"));
        addressOut.setPostalCode(this.cleanedValue(addressIn.getPostalCode(), fieldRoot, ".postalCode"));
        addressOut.setTown(this.cleanedValue(addressIn.getTown(), fieldRoot, ".town"));
        addressOut.setCountryCode(Strings.trimmed(addressIn.getCountryCode()));
        if (addressOut.getName() == null && addressOut.getStreet() == null && addressOut.getHouseNo() == null && addressOut.getPostalCode() == null && addressOut.getTown() == null && addressOut.getCountryCode() == null) {
            return null;
        }
        return addressOut;
    }

    private boolean validateMandatory(String value, String field) {
        if (Strings.isNullOrEmpty(value)) {
            this.validationResult.addMessage(ValidationMessage.Type.ERROR, field, "field_is_mandatory");
            return false;
        }
        return true;
    }

    private void validateMandatory(String value, String fieldRoot, String subfield) {
        if (Strings.isNullOrEmpty(value)) {
            this.validationResult.addMessage(ValidationMessage.Type.ERROR, fieldRoot + subfield, "field_is_mandatory");
        }
    }

    private String clippedValue(String value, int maxLength, String field) {
        if (value != null && value.length() > maxLength) {
            this.validationResult.addMessage(ValidationMessage.Type.WARNING, field, "field_clipped", new String[]{Integer.toString(maxLength)});
            return value.substring(0, maxLength);
        }
        return value;
    }

    private String clippedValue(String value, int maxLength, String fieldRoot, String subfield) {
        if (value != null && value.length() > maxLength) {
            this.validationResult.addMessage(ValidationMessage.Type.WARNING, fieldRoot + subfield, "field_clipped", new String[]{Integer.toString(maxLength)});
            return value.substring(0, maxLength);
        }
        return value;
    }

    private String cleanedValue(String value, String fieldRoot, String subfield) {
        Payments.CleaningResult result = new Payments.CleaningResult();
        Payments.cleanValue(value, result);
        if (result.replacedUnsupportedChars) {
            this.validationResult.addMessage(ValidationMessage.Type.WARNING, fieldRoot + subfield, "replaced_unsupported_characters");
        }
        return result.cleanedString;
    }
}

