/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.qrbill.generator;

import java.io.IOException;
import net.codecrete.qrbill.canvas.AbstractCanvas;
import net.codecrete.qrbill.canvas.Canvas;
import net.codecrete.qrbill.canvas.PDFCanvas;
import net.codecrete.qrbill.canvas.SVGCanvas;
import net.codecrete.qrbill.generator.Bill;
import net.codecrete.qrbill.generator.PaymentPartLayout;
import net.codecrete.qrbill.generator.QRBillUnexpectedException;
import net.codecrete.qrbill.generator.QRBillValidationError;
import net.codecrete.qrbill.generator.QRCode;
import net.codecrete.qrbill.generator.ValidationResult;
import net.codecrete.qrbill.generator.Validator;

public class QRBill {
    public static final String KEY_CURRENCY_IS_CHF_OR_EUR = "currency_is_chf_or_eur";
    public static final String KEY_AMOUNT_IS_IN_VALID_RANGE = "amount_in_valid_range";
    public static final String KEY_ACCOUNT_IS_CH_LI_IBAN = "account_is_ch_li_iban";
    public static final String KEY_ACCOUNT_IS_VALID_IBAN = "account_is_valid_iban";
    public static final String KEY_VALID_ISO11649_CREDITOR_REF = "valid_iso11649_creditor_ref";
    public static final String KEY_VALID_QR_REF_NO = "valid_qr_ref_no";
    public static final String KEY_MANDATORY_FOR_QR_IBAN = "mandatory_for_qr_iban";
    public static final String KEY_FIELD_IS_MANDATORY = "field_is_mandatory";
    public static final String KEY_VALID_COUNTRY_CODE = "valid_country_code";
    public static final String KEY_FIELD_CLIPPED = "field_clipped";
    public static final String KEY_REPLACED_UNSUPPORTED_CHARACTERS = "replaced_unsupported_characters";
    public static final String KEY_VALID_DATA_STRUCTURE = "valid_data_structure";
    public static final String KEY_SUPPORTED_VERSION = "supported_version";
    public static final String KEY_SUPPORTED_CODING_TYPE = "supported_coding_type";
    public static final String KEY_VALID_NUMBER = "valid_number";
    public static final String KEY_VALID_DATE = "valid_date";

    public static ValidationResult validate(Bill bill) {
        return Validator.validate(bill);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] generate(Bill bill, BillFormat billFormat, GraphicsFormat graphicsFormat) {
        try (Canvas canvas = QRBill.createCanvas(graphicsFormat);){
            byte[] byArray = QRBill.validateAndGenerate(bill, billFormat, canvas);
            return byArray;
        }
        catch (IOException e) {
            throw new QRBillUnexpectedException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] generate(Bill bill, BillFormat billFormat, Canvas canvas) {
        try (Canvas c = canvas;){
            byte[] byArray = QRBill.validateAndGenerate(bill, billFormat, c);
            return byArray;
        }
        catch (IOException e) {
            throw new QRBillUnexpectedException(e);
        }
    }

    private static byte[] validateAndGenerate(Bill bill, BillFormat billFormat, Canvas canvas) throws IOException {
        ValidationResult result = Validator.validate(bill);
        Bill cleanedBill = result.getCleanedBill();
        if (result.hasErrors()) {
            throw new QRBillValidationError(result);
        }
        if (billFormat == BillFormat.QR_CODE_ONLY) {
            return QRBill.generateQRCode(cleanedBill, canvas);
        }
        return QRBill.generatePaymentPart(cleanedBill, billFormat, canvas);
    }

    public static String encodeQrCodeText(Bill bill) {
        ValidationResult result = Validator.validate(bill);
        Bill cleanedBill = result.getCleanedBill();
        if (result.hasErrors()) {
            throw new QRBillValidationError(result);
        }
        QRCode qrCode = new QRCode(cleanedBill);
        return qrCode.getText();
    }

    public static Bill decodeQrCodeText(String text) {
        return QRCode.decodeQRCodeText(text);
    }

    private static byte[] generatePaymentPart(Bill bill, BillFormat billFormat, Canvas canvas) throws IOException {
        double drawingHeight;
        double drawingWidth;
        switch (billFormat) {
            case A6_LANDSCAPE_SHEET: {
                drawingWidth = 148.5;
                drawingHeight = 105.0;
                break;
            }
            case A5_LANDSCAPE_SHEET: {
                drawingWidth = 210.0;
                drawingHeight = 148.5;
                break;
            }
            default: {
                drawingWidth = 210.0;
                drawingHeight = 297.0;
            }
        }
        canvas.setupPage(drawingWidth, drawingHeight);
        PaymentPartLayout layout = new PaymentPartLayout(bill, canvas);
        layout.draw(drawingWidth - 148.5, 0.0, drawingWidth > 148.5 || drawingHeight > 105.0);
        return canvas.getResult();
    }

    private static byte[] generateQRCode(Bill bill, Canvas canvas) throws IOException {
        canvas.setupPage(46.0, 46.0);
        QRCode qrCode = new QRCode(bill);
        qrCode.draw(canvas, 0.0, 0.0);
        return canvas.getResult();
    }

    private static Canvas createCanvas(GraphicsFormat graphicsFormat) {
        AbstractCanvas canvas;
        switch (graphicsFormat) {
            case SVG: {
                canvas = new SVGCanvas();
                break;
            }
            case PDF: {
                canvas = new PDFCanvas();
                break;
            }
            default: {
                throw new QRBillUnexpectedException("Invalid graphics format specified");
            }
        }
        return canvas;
    }

    public static enum BillFormat {
        A4_PORTRAIT_SHEET,
        A5_LANDSCAPE_SHEET,
        A6_LANDSCAPE_SHEET,
        QR_CODE_ONLY;

    }

    public static enum GraphicsFormat {
        PDF,
        SVG;

    }
}

