/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.qrbill.generator;

import java.text.Normalizer;
import net.codecrete.qrbill.generator.Strings;

public class Payments {
    private static final int[] MOD_10 = new int[]{0, 9, 4, 6, 8, 2, 7, 1, 3, 5};

    private Payments() {
    }

    static void cleanValue(String value, CleaningResult result) {
        result.cleanedString = null;
        result.replacedUnsupportedChars = false;
        Payments.cleanValue(value, result, false);
        if (result.cleanedString != null && result.cleanedString.length() == 0) {
            result.cleanedString = null;
        }
    }

    private static void cleanValue(String value, CleaningResult result, boolean isNormalized) {
        if (value == null) {
            return;
        }
        int len = value.length();
        boolean justProcessedSpace = false;
        StringBuilder sb = null;
        int lastCopiedPos = 0;
        int pos = 0;
        while (pos < len) {
            char ch = value.charAt(pos);
            if (Payments.isValidQRBillCharacter(ch)) {
                justProcessedSpace = ch == ' ';
                ++pos;
                continue;
            }
            if (ch > '\u00ff' && !isNormalized && !(isNormalized = Normalizer.isNormalized(value, Normalizer.Form.NFC))) {
                value = Normalizer.normalize(value, Normalizer.Form.NFC);
                Payments.cleanValue(value, result, true);
                return;
            }
            if (sb == null) {
                sb = new StringBuilder(value.length());
            }
            if (pos > lastCopiedPos) {
                sb.append(value, lastCopiedPos, pos);
            }
            if (Character.isHighSurrogate(ch)) {
                int codePoint = value.codePointAt(pos);
                if (Character.getType(codePoint) != 8) {
                    sb.append('.');
                }
                justProcessedSpace = false;
                ++pos;
            } else if (Character.isWhitespace(ch)) {
                if (!justProcessedSpace) {
                    sb.append(' ');
                }
                justProcessedSpace = true;
            } else {
                sb.append('.');
                justProcessedSpace = false;
            }
            lastCopiedPos = ++pos;
        }
        if (sb == null) {
            result.cleanedString = value.trim();
            return;
        }
        if (lastCopiedPos < len) {
            sb.append(value, lastCopiedPos, len);
        }
        result.cleanedString = sb.toString().trim();
        result.replacedUnsupportedChars = true;
    }

    public static boolean isValidIBAN(String iban) {
        if (iban.length() < 5) {
            return false;
        }
        if (!Payments.isAlphaNumeric(iban)) {
            return false;
        }
        if (!(Character.isLetter(iban.charAt(0)) && Character.isLetter(iban.charAt(1)) && Character.isDigit(iban.charAt(2)) && Character.isDigit(iban.charAt(3)))) {
            return false;
        }
        return Payments.hasValidMod97CheckDigits(iban);
    }

    public static String formatIBAN(String iban) {
        StringBuilder sb = new StringBuilder(25);
        int len = iban.length();
        for (int pos = 0; pos < len; pos += 4) {
            int endPos = pos + 4;
            if (endPos > len) {
                endPos = len;
            }
            sb.append(iban, pos, endPos);
            if (endPos == len) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    public static boolean isValidISO11649ReferenceNo(String referenceNo) {
        if (referenceNo.length() < 5 || referenceNo.length() > 25) {
            return false;
        }
        if (!Payments.isAlphaNumeric(referenceNo)) {
            return false;
        }
        if (!Character.isDigit(referenceNo.charAt(2)) || !Character.isDigit(referenceNo.charAt(3))) {
            return false;
        }
        return Payments.hasValidMod97CheckDigits(referenceNo);
    }

    public static String createISO11649Reference(String rawReference) {
        String whiteSpaceRemoved = Strings.whiteSpaceRemoved(rawReference);
        int modulo = Payments.calculateMod97("RF00" + whiteSpaceRemoved);
        return String.format("RF%02d", 98 - modulo) + whiteSpaceRemoved;
    }

    private static boolean hasValidMod97CheckDigits(String number) {
        try {
            return Payments.calculateMod97(number) == 1;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
    }

    public static int calculateMod97(String reference) {
        String rearranged = reference.substring(4) + reference.substring(0, 4);
        int len = rearranged.length();
        int sum = 0;
        for (int i = 0; i < len; ++i) {
            char ch = rearranged.charAt(i);
            if (ch >= '0' && ch <= '9') {
                sum = sum * 10 + (ch - 48);
            } else if (ch >= 'A' && ch <= 'Z') {
                sum = sum * 100 + (ch - 65 + 10);
            } else if (ch >= 'a' && ch <= 'z') {
                sum = sum * 100 + (ch - 97 + 10);
            } else {
                throw new IllegalArgumentException("Invalid character in reference: " + ch);
            }
            if (sum <= 9999999) continue;
            sum %= 97;
        }
        return sum %= 97;
    }

    public static boolean isValidQRReferenceNo(String referenceNo) {
        if (!Payments.isNumeric(referenceNo)) {
            return false;
        }
        int carry = 0;
        int len = referenceNo.length();
        if (len != 27) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            int digit = referenceNo.charAt(i) - 48;
            carry = MOD_10[(carry + digit) % 10];
        }
        return carry == 0;
    }

    public static String formatQRReferenceNumber(String refNo) {
        int len = refNo.length();
        StringBuilder sb = new StringBuilder();
        int t = 0;
        while (t < len) {
            int n = t + (len - t - 1) % 5 + 1;
            if (t != 0) {
                sb.append(" ");
            }
            sb.append(refNo, t, n);
            t = n;
        }
        return sb.toString();
    }

    private static boolean isNumeric(String value) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            if (ch >= '0' && ch <= '9') continue;
            return false;
        }
        return true;
    }

    static boolean isAlphaNumeric(String value) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            if (ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z') continue;
            return false;
        }
        return true;
    }

    private static boolean isValidQRBillCharacter(char ch) {
        if (ch < ' ') {
            return false;
        }
        if (ch == '^') {
            return false;
        }
        if (ch <= '~') {
            return true;
        }
        if (ch == '\u00a3' || ch == '\u00b4') {
            return true;
        }
        if (ch < '\u00c0' || ch > '\u00fd') {
            return false;
        }
        if (ch == '\u00c3' || ch == '\u00c5' || ch == '\u00c6') {
            return false;
        }
        if (ch == '\u00d0' || ch == '\u00d5' || ch == '\u00d7' || ch == '\u00d8') {
            return false;
        }
        if (ch == '\u00dd' || ch == '\u00de') {
            return false;
        }
        if (ch == '\u00e3' || ch == '\u00e5' || ch == '\u00e6') {
            return false;
        }
        return ch != '\u00f0' && ch != '\u00f5' && ch != '\u00f8';
    }

    static class CleaningResult {
        String cleanedString;
        boolean replacedUnsupportedChars;

        CleaningResult() {
        }
    }
}

