/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.qrbill.generator;

import java.text.Normalizer;

class PaymentValidation {
    private static final int[] MOD_10 = new int[]{0, 9, 4, 6, 8, 2, 7, 1, 3, 5};

    private PaymentValidation() {
    }

    static void cleanValue(String value, CleaningResult result) {
        result.cleanedString = null;
        result.replacedUnsupportedChars = false;
        PaymentValidation.cleanValue(value, result, false);
        if (result.cleanedString != null && result.cleanedString.length() == 0) {
            result.cleanedString = null;
        }
    }

    private static void cleanValue(String value, CleaningResult result, boolean isNormalized) {
        if (value == null) {
            return;
        }
        int len = value.length();
        boolean justProcessedSpace = false;
        StringBuilder sb = null;
        int lastCopiedPos = 0;
        int pos = 0;
        while (pos < len) {
            char ch = value.charAt(pos);
            if (PaymentValidation.isValidQRBillCharacter(ch)) {
                justProcessedSpace = ch == ' ';
                ++pos;
                continue;
            }
            if (ch > '\u00ff' && !isNormalized && !(isNormalized = Normalizer.isNormalized(value, Normalizer.Form.NFC))) {
                value = Normalizer.normalize(value, Normalizer.Form.NFC);
                PaymentValidation.cleanValue(value, result, true);
                return;
            }
            if (sb == null) {
                sb = new StringBuilder(value.length());
            }
            if (pos > lastCopiedPos) {
                sb.append(value, lastCopiedPos, pos);
            }
            if (Character.isHighSurrogate(ch)) {
                int codePoint = value.codePointAt(pos);
                if (Character.getType(codePoint) != 8) {
                    sb.append('.');
                }
                justProcessedSpace = false;
                ++pos;
            } else if (Character.isWhitespace(ch)) {
                if (!justProcessedSpace) {
                    sb.append(' ');
                }
                justProcessedSpace = true;
            } else {
                sb.append('.');
                justProcessedSpace = false;
            }
            lastCopiedPos = ++pos;
        }
        if (sb == null) {
            result.cleanedString = value.trim();
            return;
        }
        if (lastCopiedPos < len) {
            sb.append(value, lastCopiedPos, len);
        }
        result.cleanedString = sb.toString().trim();
        result.replacedUnsupportedChars = true;
    }

    static boolean isValidIBAN(String iban) {
        if (iban.length() < 5) {
            return false;
        }
        if (!PaymentValidation.isAlphaNumeric(iban)) {
            return false;
        }
        if (!(Character.isLetter(iban.charAt(0)) && Character.isLetter(iban.charAt(1)) && Character.isDigit(iban.charAt(2)) && Character.isDigit(iban.charAt(3)))) {
            return false;
        }
        return PaymentValidation.hasValidMod97CheckDigits(iban);
    }

    static boolean isValidQRReferenceNo(String referenceNo) {
        if (!PaymentValidation.isNumeric(referenceNo)) {
            return false;
        }
        int carry = 0;
        int len = referenceNo.length();
        if (len != 27) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            int digit = referenceNo.charAt(i) - 48;
            carry = MOD_10[(carry + digit) % 10];
        }
        return carry == 0;
    }

    static boolean isValidISO11649ReferenceNo(String referenceNo) {
        if (referenceNo.length() < 5 || referenceNo.length() > 25) {
            return false;
        }
        if (!PaymentValidation.isAlphaNumeric(referenceNo)) {
            return false;
        }
        if (!Character.isDigit(referenceNo.charAt(2)) || !Character.isDigit(referenceNo.charAt(3))) {
            return false;
        }
        return PaymentValidation.hasValidMod97CheckDigits(referenceNo);
    }

    private static boolean hasValidMod97CheckDigits(String number) {
        String rearranged = number.substring(4) + number.substring(0, 4);
        int len = rearranged.length();
        int sum = 0;
        for (int i = 0; i < len; ++i) {
            char ch = rearranged.charAt(i);
            if (ch >= '0' && ch <= '9') {
                sum = sum * 10 + (ch - 48);
            } else if (ch >= 'A' && ch <= 'Z') {
                sum = sum * 100 + (ch - 65 + 10);
            } else if (ch >= 'a' && ch <= 'z') {
                sum = sum * 100 + (ch - 97 + 10);
            } else {
                return false;
            }
            if (sum <= 9999999) continue;
            sum %= 97;
        }
        return (sum %= 97) == 1;
    }

    private static boolean isNumeric(String value) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            if (ch >= '0' && ch <= '9') continue;
            return false;
        }
        return true;
    }

    static boolean isAlphaNumeric(String value) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            if (ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z') continue;
            return false;
        }
        return true;
    }

    private static boolean isValidQRBillCharacter(char ch) {
        if (ch < ' ') {
            return false;
        }
        if (ch == '^') {
            return false;
        }
        if (ch <= '~') {
            return true;
        }
        if (ch == '\u00a3' || ch == '\u00b4') {
            return true;
        }
        if (ch < '\u00c0' || ch > '\u00fd') {
            return false;
        }
        if (ch == '\u00c3' || ch == '\u00c5' || ch == '\u00c6') {
            return false;
        }
        if (ch == '\u00d0' || ch == '\u00d5' || ch == '\u00d7' || ch == '\u00d8') {
            return false;
        }
        if (ch == '\u00dd' || ch == '\u00de') {
            return false;
        }
        if (ch == '\u00e3' || ch == '\u00e5' || ch == '\u00e6') {
            return false;
        }
        return ch != '\u00f0' && ch != '\u00f5' && ch != '\u00f8';
    }

    static class CleaningResult {
        String cleanedString;
        boolean replacedUnsupportedChars;

        CleaningResult() {
        }
    }
}

