/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.qrbill.generator;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import net.codecrete.qrbill.canvas.Canvas;
import net.codecrete.qrbill.canvas.FontMetrics;
import net.codecrete.qrbill.generator.Address;
import net.codecrete.qrbill.generator.Bill;
import net.codecrete.qrbill.generator.MultilingualText;
import net.codecrete.qrbill.generator.QRCode;

class PaymentPartLayout {
    private static final double PT_TO_MM = 0.35277777777777775;
    private static final double MM_TO_PT = 2.834645669291339;
    private static final int FONT_SIZE_TITLE = 11;
    private static final int FONT_SIZE_LABEL = 8;
    private static final int FONT_SIZE_TEXT = 10;
    private static final double SLIP_WIDTH = 148.5;
    private static final double SLIP_HEIGHT = 105.0;
    private static final double HORIZ_BORDER = 8.0;
    private static final double VERT_BORDER = 8.0;
    private static final double MIDDLE_SPACING = 5.0;
    private static final double LEFT_COLUMN_WIDTH = 56.0;
    private static final double AMOUNT_WIDTH = 40.0;
    private static final double AMOUNT_HEIGHT = 15.0;
    private static final double RIGHT_COLUMN_WIDTH = 71.5;
    private static final double DEBTOR_HEIGHT = 25.0;
    private static final double PREFERRED_LABEL_PADDING_TOP = 2.822222222222222;
    private static final double PREFERRED_TEXT_PADDING_TOP = 1.7638888888888888;
    private static final double PREFERRED_LEADING = 0.2;
    private Bill bill;
    private QRCode qrCode;
    private Canvas graphics;
    private String account;
    private String[] creditor;
    private String[] finalCreditor;
    private String refNo;
    private String[] additionalInfo;
    private String[] debtor;
    private String dueDate;
    private double yPos;
    private double labelPaddingTop;
    private double textPaddingTop;
    private double textLeading;
    private int fontSizeLabel;
    private int fontSizeText;
    private double rightColumnPaddingTop;
    private static DecimalFormat amountDisplayFormat;
    private static DateTimeFormatter dateDisplayFormat;

    PaymentPartLayout(Bill bill, Canvas graphics) {
        this.bill = bill;
        this.qrCode = new QRCode(bill);
        this.graphics = graphics;
    }

    void draw(double offsetX, double offsetY, boolean hasBorder) throws IOException {
        this.fontSizeLabel = 8;
        this.fontSizeText = 10;
        this.prepareRightColumnText();
        double factor = this.computeSpacing();
        if (factor < 0.6) {
            this.fontSizeLabel = 7;
            this.fontSizeText = 9;
            this.prepareRightColumnText();
            this.computeSpacing();
        }
        if (hasBorder) {
            this.graphics.setTransformation(offsetX, offsetY, 1.0);
            this.graphics.startPath();
            this.graphics.moveTo(0.0, 0.0);
            this.graphics.lineTo(0.0, 105.0);
            this.graphics.lineTo(148.5, 105.0);
            this.graphics.strokePath(0.5, 0);
        }
        this.graphics.setTransformation(offsetX + 8.0, offsetY, 1.0);
        this.yPos = 97.0 - FontMetrics.getAscender(11);
        this.graphics.putText(MultilingualText.getText("qrbill_payment_part", this.bill.getLanguage()), 0.0, this.yPos, 11, true);
        this.yPos -= FontMetrics.getDescender(11);
        double upperTextHeight = 8.0 + FontMetrics.getLineHeight(11) + this.labelPaddingTop + FontMetrics.getLineHeight(this.fontSizeLabel) + this.textPaddingTop + FontMetrics.getLineHeight(this.fontSizeText);
        this.drawLabelAndText("supports", MultilingualText.getText("credit_transfer", this.bill.getLanguage()));
        double lowerTextHeight = 23.0 + this.textPaddingTop + FontMetrics.getLineHeight(this.fontSizeLabel);
        this.yPos = lowerTextHeight + this.labelPaddingTop;
        this.drawLabelAndText("currency", this.bill.getCurrency());
        this.graphics.setTransformation(offsetX + 8.0 + 56.0 - 40.0, offsetY, 1.0);
        this.yPos = lowerTextHeight + this.labelPaddingTop;
        if (this.bill.getAmount() != null) {
            this.drawLabelAndText("amount", PaymentPartLayout.formatAmountForDisplay(this.bill.getAmount()));
        } else {
            this.drawLabel("amount");
            this.drawCorners(0.0, 8.0, 40.0, 15.0);
        }
        double qrCodeSpacing = (105.0 - upperTextHeight - 46.0 - lowerTextHeight) / 2.0;
        this.yPos = lowerTextHeight + qrCodeSpacing;
        this.qrCode.draw(this.graphics, offsetX + 8.0, offsetY + this.yPos);
        this.graphics.setTransformation(offsetX + 8.0, offsetY, 1.0);
        this.graphics.setTransformation(offsetX + 8.0 + 56.0 + 5.0, offsetY, 1.0);
        this.yPos = 97.0 - this.rightColumnPaddingTop + this.labelPaddingTop;
        this.drawLabelAndText("account", this.account);
        this.drawLabelAndTextLines("creditor", this.creditor);
        if (this.finalCreditor != null) {
            this.drawLabelAndTextLines("ultimate_creditor", this.finalCreditor);
        }
        if (this.refNo != null) {
            this.drawLabelAndText("reference_no", this.refNo);
        }
        if (this.additionalInfo != null) {
            this.drawLabelAndTextLines("additional_info", this.additionalInfo);
        }
        if (this.debtor != null) {
            this.drawLabelAndTextLines("debtor", this.debtor);
        } else {
            this.drawLabel("debtor");
            this.yPos -= this.textPaddingTop + 25.0;
            this.drawCorners(0.0, this.yPos, 71.5, 25.0);
        }
        if (this.dueDate != null) {
            this.drawLabelAndText("due_date", this.dueDate);
        }
    }

    private void drawLabel(String labelKey) throws IOException {
        this.yPos -= this.labelPaddingTop + FontMetrics.getAscender(this.fontSizeLabel);
        this.graphics.putText(MultilingualText.getText(labelKey, this.bill.getLanguage()), 0.0, this.yPos, this.fontSizeLabel, true);
        this.yPos -= FontMetrics.getDescender(this.fontSizeLabel);
    }

    private void drawLabelAndText(String labelKey, String text) throws IOException {
        this.drawLabel(labelKey);
        this.yPos -= this.textPaddingTop + FontMetrics.getAscender(this.fontSizeText);
        this.graphics.putText(text, 0.0, this.yPos, this.fontSizeText, false);
        this.yPos -= FontMetrics.getDescender(this.fontSizeText);
    }

    private void drawLabelAndTextLines(String labelKey, String[] textLines) throws IOException {
        this.drawLabel(labelKey);
        this.yPos -= this.textPaddingTop + FontMetrics.getAscender(this.fontSizeText);
        this.graphics.putTextLines(textLines, 0.0, this.yPos, this.fontSizeText, this.textLeading);
        this.yPos -= FontMetrics.getDescender(this.fontSizeText) + (double)(textLines.length - 1) * (FontMetrics.getLineHeight(this.fontSizeText) + this.textLeading);
    }

    private void prepareRightColumnText() {
        this.account = PaymentPartLayout.formatIBANForDisplay(this.bill.getAccount());
        this.creditor = FontMetrics.splitLines(PaymentPartLayout.formatPersonForDisplay(this.bill.getCreditor()), 202.67716535433073, this.fontSizeText);
        this.finalCreditor = null;
        if (this.bill.getFinalCreditor() != null) {
            this.finalCreditor = FontMetrics.splitLines(PaymentPartLayout.formatPersonForDisplay(this.bill.getFinalCreditor()), 202.67716535433073, this.fontSizeText);
        }
        this.refNo = PaymentPartLayout.formatReferenceNumber(this.bill.getReferenceNo());
        this.additionalInfo = null;
        String info = this.bill.getAdditionalInfo();
        if (info != null) {
            int p = info.indexOf("##");
            if (p > 0) {
                info = info.substring(0, p) + '\n' + info.substring(p);
            }
            this.additionalInfo = FontMetrics.splitLines(info, 202.67716535433073, this.fontSizeText);
        }
        this.debtor = null;
        if (this.bill.getDebtor() != null) {
            this.debtor = FontMetrics.splitLines(PaymentPartLayout.formatPersonForDisplay(this.bill.getDebtor()), 202.67716535433073, this.fontSizeText);
        }
        this.dueDate = null;
        if (this.bill.getDueDate() != null) {
            this.dueDate = PaymentPartLayout.formatDateForDisplay(this.bill.getDueDate());
        }
    }

    private double computeSpacing() {
        double uncompressedSpacing;
        int numLabels = 3;
        int numTextLines = 1;
        numTextLines += this.creditor.length;
        if (this.finalCreditor != null) {
            ++numLabels;
            numTextLines += this.finalCreditor.length;
        }
        if (this.refNo != null) {
            ++numLabels;
            ++numTextLines;
        }
        if (this.additionalInfo != null) {
            ++numLabels;
            numTextLines += this.additionalInfo.length;
        }
        if (this.debtor != null) {
            numTextLines += this.debtor.length;
        }
        if (this.dueDate != null) {
            ++numLabels;
            ++numTextLines;
        }
        int numExtraLines = this.debtor != null ? numTextLines - numLabels : numTextLines + 1 - numLabels;
        double preferredTextLeading = 0.2 * (double)this.fontSizeText * 0.35277777777777775;
        double heightWithoutSpacing = (double)numLabels * FontMetrics.getLineHeight(this.fontSizeLabel) + (double)numTextLines * FontMetrics.getLineHeight(this.fontSizeText) + (this.debtor == null ? 25.0 : 0.0);
        double regularHeight = heightWithoutSpacing + (uncompressedSpacing = (double)(numLabels - 1) * 2.822222222222222 + (double)numLabels * 1.7638888888888888 + (double)numExtraLines * preferredTextLeading);
        if (regularHeight <= 89.0) {
            this.labelPaddingTop = 2.822222222222222;
            this.textPaddingTop = 1.7638888888888888;
            this.textLeading = preferredTextLeading;
            double titleHeight = FontMetrics.getLineHeight(11) + this.labelPaddingTop;
            this.rightColumnPaddingTop = regularHeight <= 89.0 - titleHeight ? titleHeight : 0.0;
            return 1.0;
        }
        double remainingSpacing = 89.0 - heightWithoutSpacing;
        double factor = remainingSpacing / uncompressedSpacing;
        this.labelPaddingTop = factor * 2.822222222222222;
        this.textPaddingTop = factor * 1.7638888888888888;
        this.textLeading = factor * preferredTextLeading;
        return factor;
    }

    private void drawCorners(double x, double y, double width, double height) throws IOException {
        double lwh = 0.17638888888888887;
        double s = 3.0;
        this.graphics.startPath();
        this.graphics.moveTo(x + 0.17638888888888887, y + 3.0);
        this.graphics.lineTo(x + 0.17638888888888887, y + 0.17638888888888887);
        this.graphics.lineTo(x + 3.0, y + 0.17638888888888887);
        this.graphics.moveTo(x + width - 3.0, y + 0.17638888888888887);
        this.graphics.lineTo(x + width - 0.17638888888888887, y + 0.17638888888888887);
        this.graphics.lineTo(x + width - 0.17638888888888887, y + 3.0);
        this.graphics.moveTo(x + width - 0.17638888888888887, y + height - 3.0);
        this.graphics.lineTo(x + width - 0.17638888888888887, y + height - 0.17638888888888887);
        this.graphics.lineTo(x + width - 3.0, y + height - 0.17638888888888887);
        this.graphics.moveTo(x + 3.0, y + height - 0.17638888888888887);
        this.graphics.lineTo(x + 0.17638888888888887, y + height - 0.17638888888888887);
        this.graphics.lineTo(x + 0.17638888888888887, y + height - 3.0);
        this.graphics.strokePath(1.0, 0);
    }

    private static String formatAmountForDisplay(double amount) {
        return amountDisplayFormat.format(amount);
    }

    private static String formatDateForDisplay(LocalDate date) {
        return date.format(dateDisplayFormat);
    }

    private static String formatIBANForDisplay(String iban) {
        StringBuilder sb = new StringBuilder(25);
        int len = iban.length();
        for (int pos = 0; pos < len; pos += 4) {
            int endPos = pos + 4;
            if (endPos > len) {
                endPos = len;
            }
            sb.append(iban, pos, endPos);
            if (endPos == len) continue;
            sb.append(' ');
        }
        return sb.toString();
    }

    private static String formatPersonForDisplay(Address address) {
        String houseNo;
        StringBuilder sb = new StringBuilder();
        sb.append(address.getName());
        String street = address.getStreet();
        if (street != null) {
            sb.append("\n");
            sb.append(street);
        }
        if ((houseNo = address.getHouseNo()) != null) {
            sb.append(street != null ? " " : "\n");
            sb.append(houseNo);
        }
        sb.append("\n");
        sb.append(address.getCountryCode());
        sb.append("-");
        sb.append(address.getPostalCode());
        sb.append(" ");
        sb.append(address.getTown());
        return sb.toString();
    }

    private static String formatReferenceNumber(String refNo) {
        if (refNo == null) {
            return null;
        }
        int len = (refNo = refNo.trim()).length();
        if (len == 0) {
            return null;
        }
        if (refNo.startsWith("RF")) {
            return PaymentPartLayout.formatIBANForDisplay(refNo);
        }
        StringBuilder sb = new StringBuilder();
        int t = 0;
        while (t < len) {
            int n = t + (len - t - 1) % 5 + 1;
            if (t != 0) {
                sb.append(" ");
            }
            sb.append(refNo, t, n);
            t = n;
        }
        return sb.toString();
    }

    static {
        dateDisplayFormat = DateTimeFormatter.ofPattern("dd.MM.yyyy");
        amountDisplayFormat = new DecimalFormat("###,##0.00");
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.US);
        symbols.setDecimalSeparator('.');
        symbols.setGroupingSeparator('\'');
        amountDisplayFormat.setDecimalFormatSymbols(symbols);
    }
}

