/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.qrbill.canvas;

import java.util.ArrayList;

public class FontMetrics {
    private static final double PT_TO_MM = 0.35277777777777775;
    private static final char DEFAULT_WIDTH = '\u022c';
    private static final char[] CHAR_WIDTH_20_7F = new char[]{'\u0116', '\u0116', '\u0163', '\u022c', '\u022c', '\u0379', '\u029b', '\u00de', '\u014d', '\u014d', '\u0185', '\u0248', '\u0116', '\u014d', '\u0116', '\u0116', '\u022c', '\u022c', '\u022c', '\u022c', '\u022c', '\u022c', '\u022c', '\u022c', '\u022c', '\u022c', '\u0116', '\u0116', '\u0248', '\u0248', '\u0248', '\u022c', '\u03f7', '\u029b', '\u029b', '\u02d2', '\u02d2', '\u029b', '\u0263', '\u030a', '\u02d2', '\u0116', '\u01f4', '\u029b', '\u022c', '\u0341', '\u02d2', '\u030a', '\u029b', '\u030a', '\u02d2', '\u029b', '\u0263', '\u02d2', '\u029b', '\u03b0', '\u029b', '\u029b', '\u0263', '\u0116', '\u0116', '\u0116', '\u0000', '\u022c', '\u00de', '\u022c', '\u022c', '\u01f4', '\u022c', '\u022c', '\u0116', '\u022c', '\u022c', '\u00de', '\u00de', '\u01f4', '\u00de', '\u0341', '\u022c', '\u022c', '\u022c', '\u022c', '\u014d', '\u01f4', '\u0116', '\u022c', '\u01f4', '\u02d2', '\u01f4', '\u01f4', '\u01f4', '\u014e', '\u0000', '\u014e', '\u0248', '\u0000'};
    private static final char[] CHAR_WIDTH_A0_FF = new char[]{'\u0000', '\u0000', '\u0000', '\u022c', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u00de', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u029b', '\u029b', '\u029b', '\u0000', '\u029b', '\u0000', '\u0000', '\u02d2', '\u029b', '\u029b', '\u029b', '\u029b', '\u0116', '\u0116', '\u0116', '\u0116', '\u0000', '\u02d2', '\u030a', '\u030a', '\u030a', '\u0000', '\u030a', '\u0000', '\u0000', '\u02d2', '\u02d2', '\u02d2', '\u02d2', '\u0000', '\u0000', '\u0263', '\u022c', '\u022c', '\u022c', '\u0000', '\u022c', '\u0000', '\u0000', '\u01f4', '\u022c', '\u022c', '\u022c', '\u022c', '\u0116', '\u0116', '\u0116', '\u0116', '\u0000', '\u022c', '\u022c', '\u022c', '\u022c', '\u0000', '\u022c', '\u022c', '\u0000', '\u022c', '\u022c', '\u022c', '\u022c', '\u01f4', '\u0000', '\u0000'};

    public static double getAscender(int fontSize) {
        return (double)fontSize * 0.8 * 0.35277777777777775;
    }

    public static double getDescender(int fontSize) {
        return (double)fontSize * 0.2 * 0.35277777777777775;
    }

    public static double getLineHeight(int fontSize) {
        return (double)fontSize * 0.35277777777777775;
    }

    public static String[] splitLines(String text, double maxLength, int fontSize) {
        ArrayList<String> lines = new ArrayList<String>();
        int max = (int)(maxLength * 1000.0 / (double)fontSize);
        int len = text.length();
        int pos = 0;
        int lineStartPos = 0;
        int lineWidth = 0;
        boolean addEmptyLine = true;
        while (pos < len) {
            char ch = text.charAt(pos);
            if (ch == ' ' && pos == lineStartPos) {
                ++lineStartPos;
                ++pos;
                continue;
            }
            lineWidth = (int)((double)lineWidth + FontMetrics.getCharWidth(ch));
            addEmptyLine = false;
            if (ch == '\n' || lineWidth > max) {
                int breakPos;
                if (ch == '\n') {
                    breakPos = pos;
                } else {
                    int spacePos;
                    for (spacePos = pos - 1; spacePos > lineStartPos && text.charAt(spacePos) != ' '; --spacePos) {
                    }
                    breakPos = spacePos > lineStartPos ? spacePos : (pos > lineStartPos ? pos : lineStartPos + 1);
                }
                FontMetrics.addResultLine(lines, text, lineStartPos, breakPos);
                lineStartPos = breakPos;
                if (ch == '\n') {
                    lineStartPos = breakPos + 1;
                    addEmptyLine = true;
                }
                pos = lineStartPos;
                lineWidth = 0;
                continue;
            }
            ++pos;
        }
        if (pos > lineStartPos) {
            FontMetrics.addResultLine(lines, text, lineStartPos, pos);
        } else if (addEmptyLine) {
            lines.add("");
        }
        return lines.toArray(new String[lines.size()]);
    }

    private static void addResultLine(ArrayList<String> lines, String text, int start, int end) {
        while (end > start && text.charAt(end - 1) == ' ') {
            --end;
        }
        lines.add(text.substring(start, end));
    }

    private static double getCharWidth(char ch) {
        int width = 0;
        if (ch >= ' ' && ch <= '\u007f') {
            width = CHAR_WIDTH_20_7F[ch - 32];
        } else if (ch >= '\u00a0' && ch <= '\u00ff') {
            width = CHAR_WIDTH_A0_FF[ch - 160];
        }
        if (width == 0) {
            width = 556;
        }
        return width;
    }

    private FontMetrics() {
    }
}

