/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.qrbill.generator;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.Locale;
import net.codecrete.qrbill.generator.FontMetrics;
import net.codecrete.qrbill.generator.GraphicsGenerator;

public class SVGGenerator
implements GraphicsGenerator {
    private static final double MM_TO_PT = 2.834645669291339;
    private ByteArrayOutputStream buffer = new ByteArrayOutputStream();
    private Writer stream = new OutputStreamWriter((OutputStream)this.buffer, StandardCharsets.UTF_8);
    private boolean isInGroup = false;
    private boolean isFirstMoveInPath;
    private double lastPositionX;
    private double lastPositionY;
    private int approxPathLength;
    private static final DecimalFormat NUMBER_FORMAT = new DecimalFormat("#.###");

    public SVGGenerator(double width, double height) throws IOException {
        this.stream.write("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"no\"?>\n<!DOCTYPE svg PUBLIC \"-//W3C//DTD SVG 1.1//EN\" \"http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd\">\n<svg width=\"");
        this.stream.write(SVGGenerator.formatNumber(width));
        this.stream.write("mm\" height=\"");
        this.stream.write(SVGGenerator.formatNumber(height));
        this.stream.write("mm\" version=\"1.1\" viewBox=\"0 0 ");
        this.stream.write(SVGGenerator.formatCoordinate(width));
        this.stream.write(" ");
        this.stream.write(SVGGenerator.formatCoordinate(height));
        this.stream.write("\" xmlns=\"http://www.w3.org/2000/svg\">\n");
        this.stream.write("<g font-family=\"Helvetica,Arial\">\n");
    }

    @Override
    public void close() throws IOException {
        if (this.isInGroup) {
            this.stream.write("</g>\n");
            this.isInGroup = false;
        }
        if (this.stream != null) {
            this.stream.write("</g>\n");
            this.stream.write("</svg>\n");
            this.stream.close();
            this.stream = null;
        }
    }

    @Override
    public void startPath() throws IOException {
        this.stream.write("<path d=\"");
        this.isFirstMoveInPath = true;
        this.approxPathLength = 0;
    }

    @Override
    public void moveTo(double x, double y) throws IOException {
        if (this.isFirstMoveInPath) {
            this.stream.write("M");
            this.stream.write(SVGGenerator.formatCoordinate(x));
            this.stream.write(",");
            this.stream.write(SVGGenerator.formatCoordinate(y));
            this.isFirstMoveInPath = false;
        } else {
            this.addPathNewlines(16);
            this.stream.write("m");
            this.stream.write(SVGGenerator.formatCoordinate(x - this.lastPositionX));
            this.stream.write(",");
            this.stream.write(SVGGenerator.formatCoordinate(y - this.lastPositionY));
        }
        this.lastPositionX = x;
        this.lastPositionY = y;
        this.approxPathLength += 16;
    }

    @Override
    public void lineTo(double x, double y) throws IOException {
        this.addPathNewlines(16);
        this.stream.write("l");
        this.stream.write(SVGGenerator.formatCoordinate(x - this.lastPositionX));
        this.stream.write(",");
        this.stream.write(SVGGenerator.formatCoordinate(y - this.lastPositionY));
        this.lastPositionX = x;
        this.lastPositionY = y;
        this.approxPathLength += 16;
    }

    @Override
    public void addRectangle(double x, double y, double width, double height) throws IOException {
        this.addPathNewlines(40);
        this.moveTo(x, y);
        this.stream.write("h");
        this.stream.write(SVGGenerator.formatCoordinate(width));
        this.stream.write("v");
        this.stream.write(SVGGenerator.formatCoordinate(height));
        this.stream.write("h");
        this.stream.write(SVGGenerator.formatCoordinate(-width));
        this.stream.write("z");
        this.approxPathLength += 24;
    }

    private void addPathNewlines(int expectedLength) throws IOException {
        if (this.approxPathLength + expectedLength > 255) {
            this.stream.write("\n");
            this.approxPathLength = 0;
        }
    }

    @Override
    public void fillPath(int color) throws IOException {
        this.stream.write("\" fill=\"#");
        this.stream.write(SVGGenerator.formatColor(color));
        this.stream.write("\"/>\n");
        this.isFirstMoveInPath = true;
    }

    @Override
    public void strokePath(double strokeWidth, int color) throws IOException {
        this.stream.write("\" stroke=\"#");
        this.stream.write(SVGGenerator.formatColor(color));
        if (strokeWidth != 1.0) {
            this.stream.write("\" stroke-width=\"");
            this.stream.write(SVGGenerator.formatNumber(strokeWidth));
        }
        this.stream.write("\" fill=\"none\"/>\n");
        this.isFirstMoveInPath = true;
    }

    @Override
    public void putText(String text, double x, double y, int fontSize, boolean isBold) throws IOException {
        this.stream.write("<text x=\"");
        this.stream.write(SVGGenerator.formatCoordinate(x));
        this.stream.write("\" y=\"");
        this.stream.write(SVGGenerator.formatCoordinate(y += FontMetrics.getAscender(fontSize)));
        this.stream.write("\" font-size=\"");
        this.stream.write(SVGGenerator.formatNumber(fontSize));
        if (isBold) {
            this.stream.write("\" font-weight=\"bold");
        }
        this.stream.write("\">");
        this.stream.write(SVGGenerator.escapeXML(text));
        this.stream.write("</text>\n");
    }

    @Override
    public int putMultilineText(String text, double x, double y, double maxWidth, int fontSize) throws IOException {
        String[] lines = FontMetrics.splitLines(text, maxWidth * 2.834645669291339, fontSize);
        this.putTextLines(lines, x, y, fontSize);
        return lines.length;
    }

    @Override
    public void putTextLines(String[] lines, double x, double y, int fontSize) throws IOException {
        for (String line : lines) {
            this.putText(line, x, y, fontSize, false);
            y += FontMetrics.getLineHeight(fontSize);
        }
    }

    @Override
    public void setTransformation(double translateX, double translateY, double scale) throws IOException {
        if (this.isInGroup) {
            this.stream.write("</g>\n");
            this.isInGroup = false;
        }
        if (translateX != 0.0 || translateY != 0.0 || scale != 1.0) {
            this.stream.write("<g transform=\"translate(");
            this.stream.write(SVGGenerator.formatCoordinate(translateX));
            this.stream.write(" ");
            this.stream.write(SVGGenerator.formatCoordinate(translateY));
            if (scale != 1.0) {
                this.stream.write(") scale(");
                this.stream.write(SVGGenerator.formatNumber(scale));
            }
            this.stream.write(")\">\n");
            this.isInGroup = true;
        }
    }

    @Override
    public byte[] getResult() throws IOException {
        this.close();
        return this.buffer.toByteArray();
    }

    private static String formatNumber(double value) {
        return NUMBER_FORMAT.format(value);
    }

    private static String formatCoordinate(double value) {
        return NUMBER_FORMAT.format(value * 2.834645669291339);
    }

    private static String formatColor(int color) {
        return String.format(Locale.US, "%06x", color);
    }

    private static String escapeXML(String text) {
        int length = text.length();
        int lastCopiedPosition = 0;
        StringBuilder result = null;
        for (int i = 0; i < length; ++i) {
            String entity;
            char ch = text.charAt(i);
            if (ch != '<' && ch != '>' && ch != '&' && ch != '\'' && ch != '\"') continue;
            if (result == null) {
                result = new StringBuilder(length + 10);
            }
            if (i > lastCopiedPosition) {
                result.append(text, lastCopiedPosition, i);
            }
            switch (ch) {
                case '<': {
                    entity = "&lt;";
                    break;
                }
                case '>': {
                    entity = "&gt;";
                    break;
                }
                case '&': {
                    entity = "&amp;";
                    break;
                }
                case '\'': {
                    entity = "&apos;";
                    break;
                }
                default: {
                    entity = "&quot;";
                }
            }
            result.append(entity);
            lastCopiedPosition = i + 1;
        }
        if (result == null) {
            return text;
        }
        if (length > lastCopiedPosition) {
            result.append(text, lastCopiedPosition, length);
        }
        return result.toString();
    }
}

