/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.qrbill.generator;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Locale;
import net.codecrete.io.nayuki.qrcodegen.QrCode;
import net.codecrete.qrbill.generator.Address;
import net.codecrete.qrbill.generator.Bill;
import net.codecrete.qrbill.generator.GraphicsGenerator;
import net.codecrete.qrbill.generator.QRBillValidationError;
import net.codecrete.qrbill.generator.ValidationMessage;
import net.codecrete.qrbill.generator.ValidationResult;

public class QRCode {
    static final double SIZE = 46.0;
    private static final String CRLF = "\r\n";
    private Bill bill;
    private StringBuilder textBuilder = new StringBuilder();
    private static DecimalFormat AMOUNT_FIELD_FORMAT = new DecimalFormat("#0.00");

    public QRCode(Bill bill) {
        this.bill = bill;
        this.createQRCodeText();
    }

    public String getText() {
        return this.textBuilder.toString();
    }

    void draw(GraphicsGenerator graphics, double offsetX, double offsetY) throws IOException {
        QrCode qrCode = QrCode.encodeText(this.textBuilder.toString(), QrCode.Ecc.MEDIUM);
        boolean[][] modules = QRCode.copyModules(qrCode);
        QRCode.clearSwissCrossArea(modules);
        graphics.setTransformation(offsetX, offsetY, 46.0 / (double)modules.length / 25.4 * 72.0);
        graphics.startPath();
        this.drawModulesPath(graphics, modules);
        graphics.fillPath(0);
        graphics.setTransformation(offsetX, offsetY, 1.0);
        graphics.startPath();
        graphics.addRectangle(20.0, 20.0, 6.0, 6.0);
        graphics.fillPath(0);
        double BAR_WIDTH = 1.1666666666666667;
        double BAR_LENGTH = 3.888888888888889;
        graphics.startPath();
        graphics.addRectangle(22.416666666666668, 21.055555555555557, 1.1666666666666667, 3.888888888888889);
        graphics.addRectangle(21.055555555555557, 22.416666666666668, 3.888888888888889, 1.1666666666666667);
        graphics.fillPath(0xFFFFFF);
    }

    private void drawModulesPath(GraphicsGenerator graphics, boolean[][] modules) throws IOException {
        int size = modules.length;
        for (int y = 0; y < size; ++y) {
            for (int x = 0; x < size; ++x) {
                if (!modules[y][x]) continue;
                this.drawLargestRectangle(graphics, modules, x, y);
            }
        }
    }

    private void drawLargestRectangle(GraphicsGenerator graphics, boolean[][] modules, int x, int y) throws IOException {
        int size = modules.length;
        int bestW = 1;
        int bestH = 1;
        int maxArea = 1;
        int xLimit = size;
        for (int iy = y; iy < size && modules[iy][x]; ++iy) {
            int w = 0;
            while (x + w < xLimit && modules[iy][x + w]) {
                ++w;
            }
            int area = w * (iy - y + 1);
            if (area > maxArea) {
                maxArea = area;
                bestW = w;
                bestH = iy - y + 1;
            }
            xLimit = x + w;
        }
        double unit = 0.35277777777777775;
        graphics.addRectangle((double)x * 0.35277777777777775, (double)y * 0.35277777777777775, (double)bestW * 0.35277777777777775, (double)bestH * 0.35277777777777775);
        QRCode.clearRectangle(modules, x, y, bestW, bestH);
    }

    private static void clearSwissCrossArea(boolean[][] modules) {
        int size = modules.length;
        int start = (int)Math.floor(19.6 * (double)size / 46.0);
        QRCode.clearRectangle(modules, start, start, size - 2 * start, size - 2 * start);
    }

    private void createQRCodeText() {
        this.textBuilder.append("SPC");
        this.appendDataField("0100");
        this.appendDataField("1");
        this.appendDataField(this.bill.getAccount());
        this.appendPerson(this.bill.getCreditor());
        this.appendPerson(this.bill.getFinalCreditor());
        this.appendDataField(this.bill.getAmount() == null ? "" : QRCode.formatAmountForCode(this.bill.getAmount()));
        this.appendDataField(this.bill.getCurrency());
        this.appendDataField(this.bill.getDueDate() != null ? QRCode.formatDateForCode(this.bill.getDueDate()) : "");
        this.appendPerson(this.bill.getDebtor());
        String referenceType = "NON";
        if (this.bill.getReferenceNo() != null) {
            if (this.bill.getReferenceNo().startsWith("RF")) {
                referenceType = "SCOR";
            } else if (this.bill.getReferenceNo().length() > 0) {
                referenceType = "QRR";
            }
        }
        this.appendDataField(referenceType);
        this.appendDataField(this.bill.getReferenceNo());
        this.appendDataField(this.bill.getAdditionalInfo());
    }

    private void appendPerson(Address address) {
        if (address != null) {
            this.appendDataField(address.getName());
            this.appendDataField(address.getStreet());
            this.appendDataField(address.getHouseNo());
            this.appendDataField(address.getPostalCode());
            this.appendDataField(address.getTown());
            this.appendDataField(address.getCountryCode());
        } else {
            for (int i = 0; i < 6; ++i) {
                this.appendDataField("");
            }
        }
    }

    private void appendDataField(String value) {
        if (value == null) {
            value = "";
        }
        this.textBuilder.append(CRLF).append(value);
    }

    private static boolean[][] copyModules(QrCode qrCode) {
        int size = qrCode.size;
        boolean[][] modules = new boolean[size][size];
        for (int y = 0; y < size; ++y) {
            for (int x = 0; x < size; ++x) {
                modules[y][x] = qrCode.getModule(x, y);
            }
        }
        return modules;
    }

    private static void clearRectangle(boolean[][] modules, int x, int y, int width, int height) {
        for (int iy = y; iy < y + height; ++iy) {
            for (int ix = x; ix < x + width; ++ix) {
                modules[iy][ix] = false;
            }
        }
    }

    private static String formatAmountForCode(double amount) {
        return AMOUNT_FIELD_FORMAT.format(amount);
    }

    private static String formatDateForCode(LocalDate date) {
        return date.format(DateTimeFormatter.ISO_LOCAL_DATE);
    }

    public static Bill decodeQRCodeText(String text) {
        String[] lines = QRCode.splitLines(text);
        if (lines.length < 28 || lines.length > 30) {
            QRCode.throwSingleValidationError("qrText", "valid_data_structure");
        }
        if (!"SPC".equals(lines[0])) {
            QRCode.throwSingleValidationError("qrText", "valid_data_structure");
        }
        if (!"0100".equals(lines[1])) {
            QRCode.throwSingleValidationError("version", "supported_version");
        }
        if (!"1".equals(lines[2])) {
            QRCode.throwSingleValidationError("codingType", "supported_coding_type");
        }
        Bill bill = new Bill();
        bill.setVersion(Bill.Version.V1_0);
        bill.setAccount(lines[3]);
        Address creditor = new Address();
        bill.setCreditor(creditor);
        creditor.setName(lines[4]);
        creditor.setStreet(lines[5]);
        creditor.setHouseNo(lines[6]);
        creditor.setPostalCode(lines[7]);
        creditor.setTown(lines[8]);
        creditor.setCountryCode(lines[9]);
        if (lines[10].length() > 0 && lines[11].length() > 0 && lines[12].length() > 0 && lines[13].length() > 0 && lines[14].length() > 0 && lines[15].length() > 0) {
            Address finalCreditor = new Address();
            bill.setFinalCreditor(finalCreditor);
            finalCreditor.setName(lines[10]);
            finalCreditor.setStreet(lines[11]);
            finalCreditor.setHouseNo(lines[12]);
            finalCreditor.setPostalCode(lines[13]);
            finalCreditor.setTown(lines[14]);
            finalCreditor.setCountryCode(lines[15]);
        } else {
            bill.setFinalCreditor(null);
        }
        if (lines[16].length() > 0) {
            try {
                bill.setAmount(Double.valueOf(lines[16]));
            }
            catch (NumberFormatException nfe) {
                QRCode.throwSingleValidationError("amount", "valid_number");
            }
        } else {
            bill.setAmount(null);
        }
        bill.setCurrency(lines[17]);
        if (lines[18].length() > 0) {
            try {
                bill.setDueDate(LocalDate.parse(lines[18], DateTimeFormatter.ISO_LOCAL_DATE));
            }
            catch (DateTimeParseException dtpe) {
                QRCode.throwSingleValidationError("dueDate", "valid_date");
            }
        } else {
            bill.setDueDate(null);
        }
        if (lines[19].length() > 0 && lines[20].length() > 0 && lines[21].length() > 0 && lines[22].length() > 0 && lines[23].length() > 0 && lines[24].length() > 0) {
            Address debtor = new Address();
            bill.setDebtor(debtor);
            debtor.setName(lines[19]);
            debtor.setStreet(lines[20]);
            debtor.setHouseNo(lines[21]);
            debtor.setPostalCode(lines[22]);
            debtor.setTown(lines[23]);
            debtor.setCountryCode(lines[24]);
        } else {
            bill.setDebtor(null);
        }
        bill.setReferenceNo(lines[26]);
        bill.setAdditionalInfo(lines[27]);
        return bill;
    }

    private static String[] splitLines(String text) {
        int pos;
        ArrayList<String> lines = new ArrayList<String>(32);
        int lastPos = 0;
        while ((pos = text.indexOf(CRLF, lastPos)) >= 0) {
            lines.add(text.substring(lastPos, pos));
            lastPos = pos + CRLF.length();
        }
        lines.add(text.substring(lastPos));
        return lines.toArray(new String[lines.size()]);
    }

    private static void throwSingleValidationError(String field, String messageKey) {
        ValidationResult result = new ValidationResult();
        result.addMessage(ValidationMessage.Type.Error, field, messageKey);
        throw new QRBillValidationError(result);
    }

    static {
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.US);
        symbols.setDecimalSeparator('.');
        AMOUNT_FIELD_FORMAT.setDecimalFormatSymbols(symbols);
    }
}

