/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.qrbill.generator;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import net.codecrete.qrbill.generator.Address;
import net.codecrete.qrbill.generator.Bill;
import net.codecrete.qrbill.generator.FontMetrics;
import net.codecrete.qrbill.generator.GraphicsGenerator;
import net.codecrete.qrbill.generator.MultilingualText;
import net.codecrete.qrbill.generator.PDFGenerator;
import net.codecrete.qrbill.generator.QRBillValidationError;
import net.codecrete.qrbill.generator.QRCode;
import net.codecrete.qrbill.generator.SVGGenerator;
import net.codecrete.qrbill.generator.ValidationResult;
import net.codecrete.qrbill.generator.Validator;

public class QRBill {
    private static final double PT_TO_MM = 0.35277777777777775;
    private static final double MM_TO_PT = 2.834645669291339;
    private static final int FONT_SIZE_TITLE = 11;
    private static final int FONT_SIZE_LABEL = 8;
    private static final int FONT_SIZE_TEXT = 10;
    private static final double HORIZ_BORDER = 8.0;
    private static final double VERT_BORDER = 8.0;
    private static final double MIDDLE_SPACING = 5.0;
    private static final double LEFT_COLUMN_WIDTH = 56.0;
    private static final double AMOUNT_WIDTH = 40.0;
    private static final double AMOUNT_HEIGHT = 15.0;
    private static final double RIGHT_COLUMN_WIDTH = 71.5;
    private static final double DEBTOR_HEIGHT = 25.0;
    private static final double LABEL_TOP_PADDING = 2.1166666666666663;
    private static final double TEXT_TOP_PADDING = 0.7055555555555555;
    private Bill bill;
    private QRCode qrCode;
    private GraphicsGenerator graphics;
    private BillFormat billFormat;
    private GraphicsFormat graphicsFormat;
    private String account;
    private String[] creditor;
    private String[] finalCreditor;
    private String refNo;
    private String[] additionalInfo;
    private String[] debtor;
    private String dueDate;
    private double labelTopPadding;
    private double textTopPadding;
    private double labelLineHeight;
    private double textLineHeight;
    private int fontSizeLabel;
    private int fontSizeText;
    private double rightColumnExtraYOffset;
    private static DecimalFormat AMOUNT_DISPLAY_FORMAT;
    private static DateTimeFormatter DATE_DISPLAY_FORMAT;

    public static ValidationResult validate(Bill bill) {
        ValidationResult result = new ValidationResult();
        Validator validator = new Validator(bill, result);
        validator.validate();
        return result;
    }

    public static byte[] generate(Bill bill, BillFormat billFormat, GraphicsFormat graphicsFormat) {
        ValidationResult result = new ValidationResult();
        Validator validator = new Validator(bill, result);
        Bill cleanedBill = validator.validate();
        if (result.hasErrors()) {
            throw new QRBillValidationError(result);
        }
        QRBill qrBill = new QRBill();
        qrBill.bill = cleanedBill;
        qrBill.qrCode = new QRCode(cleanedBill);
        qrBill.billFormat = billFormat;
        qrBill.graphicsFormat = graphicsFormat;
        return qrBill.generateOutput();
    }

    public static String generateQrCodeText(Bill bill) {
        ValidationResult result = new ValidationResult();
        Validator validator = new Validator(bill, result);
        Bill cleanedBill = validator.validate();
        if (result.hasErrors()) {
            throw new QRBillValidationError(result);
        }
        QRCode qrCode = new QRCode(cleanedBill);
        return qrCode.getText();
    }

    public static Bill decodeQrCodeText(String text) {
        return QRCode.decodeQRCodeText(text);
    }

    /*
     * Exception decompiling
     */
    private byte[] generateOutput() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private GraphicsGenerator createGraphicsGenerator(double width, double height) throws IOException {
        GraphicsGenerator generator;
        switch (this.graphicsFormat) {
            case SVG: {
                generator = new SVGGenerator(width, height);
                break;
            }
            case PDF: {
                generator = new PDFGenerator(width, height);
                break;
            }
            default: {
                generator = null;
            }
        }
        return generator;
    }

    private void drawQRBill(double offsetX, double offsetY, boolean hasBorder) throws IOException {
        this.fontSizeLabel = 8;
        this.fontSizeText = 10;
        this.formatRightColumText();
        double factor = this.computeSpacing();
        if (factor < 0.6) {
            this.fontSizeLabel = 7;
            this.fontSizeText = 9;
            this.formatRightColumText();
            this.computeSpacing();
        }
        Bill.Language language = this.bill.getLanguage();
        if (hasBorder) {
            this.graphics.setTransformation(offsetX, offsetY, 1.0);
            this.graphics.startPath();
            this.graphics.moveTo(0.0, 105.0);
            this.graphics.lineTo(0.0, 0.0);
            this.graphics.lineTo(148.5, 0.0);
            this.graphics.strokePath(0.5, 0);
        }
        this.graphics.setTransformation(offsetX + 8.0, offsetY + 8.0, 1.0);
        double yPos = 0.0;
        this.graphics.putText(MultilingualText.getText("qrbill_payment_part", language), 0.0, yPos, 11, true);
        this.graphics.putText(MultilingualText.getText("supports", language), 0.0, yPos += FontMetrics.getLineHeight(11) + this.labelTopPadding, this.fontSizeLabel, true);
        this.graphics.putText(MultilingualText.getText("credit_transfer", language), 0.0, yPos += this.labelLineHeight + this.textTopPadding, this.fontSizeText, false);
        yPos = FontMetrics.getLineHeight(11) + 2.1166666666666663 + 0.7055555555555555 + this.labelLineHeight + this.textLineHeight - FontMetrics.getLeading(this.fontSizeText);
        double qrCodeSpacing = (89.0 - yPos - 15.0 - this.labelLineHeight - 0.7055555555555555 - 46.0) / 2.0;
        this.qrCode.draw(this.graphics, offsetX + 8.0, offsetY + 8.0 + yPos + qrCodeSpacing);
        this.graphics.setTransformation(offsetX + 8.0, offsetY + 8.0 + (yPos += 2.0 * qrCodeSpacing + 46.0), 1.0);
        yPos = 0.0;
        this.graphics.putText(MultilingualText.getText("currency", language), 0.0, yPos, this.fontSizeLabel, true);
        this.graphics.putText(this.bill.getCurrency(), 0.0, yPos += this.labelLineHeight + this.textTopPadding, this.fontSizeText, false);
        yPos = 0.0;
        this.graphics.putText(MultilingualText.getText("amount", language), 16.0, yPos, this.fontSizeLabel, true);
        yPos += this.labelLineHeight + this.textTopPadding;
        if (this.bill.getAmount() == null) {
            this.drawCorners(16.0, yPos, 40.0, 15.0);
        } else {
            this.graphics.putText(QRBill.formatAmountForDisplay(this.bill.getAmount()), 16.0, yPos, this.fontSizeText, false);
        }
        this.graphics.setTransformation(offsetX + 8.0 + 56.0 + 5.0, offsetY + 8.0 + this.rightColumnExtraYOffset, 1.0);
        yPos = 0.0;
        this.graphics.putText(MultilingualText.getText("account", language), 0.0, yPos, this.fontSizeLabel, true);
        this.graphics.putText(this.account, 0.0, yPos += this.labelLineHeight + this.textTopPadding, this.fontSizeText, false);
        this.graphics.putText(MultilingualText.getText("creditor", language), 0.0, yPos += this.textLineHeight + this.labelTopPadding, this.fontSizeLabel, true);
        this.graphics.putTextLines(this.creditor, 0.0, yPos += this.labelLineHeight + this.textTopPadding, this.fontSizeText);
        yPos += (double)this.creditor.length * this.textLineHeight + this.labelTopPadding;
        if (this.finalCreditor != null) {
            this.graphics.putText(MultilingualText.getText("ultimate_creditor", language), 0.0, yPos, this.fontSizeLabel, true);
            this.graphics.putTextLines(this.finalCreditor, 0.0, yPos += this.labelLineHeight + this.textTopPadding, this.fontSizeText);
            yPos += (double)this.finalCreditor.length * this.textLineHeight + this.labelTopPadding;
        }
        if (this.refNo != null) {
            this.graphics.putText(MultilingualText.getText("reference_no", language), 0.0, yPos, this.fontSizeLabel, true);
            this.graphics.putText(this.refNo, 0.0, yPos += this.labelLineHeight + this.textTopPadding, this.fontSizeText, false);
            yPos += this.textLineHeight + this.labelTopPadding;
        }
        if (this.additionalInfo != null) {
            this.graphics.putText(MultilingualText.getText("additional_info", language), 0.0, yPos, this.fontSizeLabel, true);
            this.graphics.putTextLines(this.additionalInfo, 0.0, yPos += this.labelLineHeight + this.textTopPadding, this.fontSizeText);
            yPos += (double)this.additionalInfo.length * this.textLineHeight + this.labelTopPadding;
        }
        this.graphics.putText(MultilingualText.getText("debtor", language), 0.0, yPos, this.fontSizeLabel, true);
        yPos += this.labelLineHeight + this.textTopPadding;
        if (this.debtor == null) {
            this.drawCorners(0.0, yPos, 71.5, 25.0);
            yPos += 25.0 + this.labelTopPadding;
        } else {
            this.graphics.putTextLines(this.debtor, 0.0, yPos, this.fontSizeText);
            yPos += (double)this.debtor.length * this.textLineHeight + this.labelTopPadding;
        }
        if (this.dueDate != null) {
            this.graphics.putText(MultilingualText.getText("due_date", language), 0.0, yPos, this.fontSizeLabel, true);
            this.graphics.putText(this.dueDate, 0.0, yPos += this.labelLineHeight + this.textTopPadding, this.fontSizeText, false);
        }
    }

    private void formatRightColumText() {
        this.account = QRBill.formatIBANForDisplay(this.bill.getAccount());
        this.creditor = FontMetrics.splitLines(QRBill.formatPersonForDisplay(this.bill.getCreditor()), 202.67716535433073, this.fontSizeText);
        this.finalCreditor = null;
        if (this.bill.getFinalCreditor() != null) {
            this.finalCreditor = FontMetrics.splitLines(QRBill.formatPersonForDisplay(this.bill.getFinalCreditor()), 202.67716535433073, this.fontSizeText);
        }
        this.refNo = QRBill.formatReferenceNumber(this.bill.getReferenceNo());
        this.additionalInfo = null;
        String info = this.bill.getAdditionalInfo();
        if (info != null) {
            int p = info.indexOf("##");
            if (p > 0) {
                info = info.substring(0, p) + '\n' + info.substring(p);
            }
            this.additionalInfo = FontMetrics.splitLines(info, 202.67716535433073, this.fontSizeText);
        }
        this.debtor = null;
        if (this.bill.getDebtor() != null) {
            this.debtor = FontMetrics.splitLines(QRBill.formatPersonForDisplay(this.bill.getDebtor()), 202.67716535433073, this.fontSizeText);
        }
        this.dueDate = null;
        if (this.bill.getDueDate() != null) {
            this.dueDate = QRBill.formatDateForDisplay(this.bill.getDueDate());
        }
    }

    private double computeSpacing() {
        int numBlocks = 3;
        if (this.finalCreditor != null) {
            ++numBlocks;
        }
        if (this.refNo != null) {
            ++numBlocks;
        }
        if (this.additionalInfo != null) {
            ++numBlocks;
        }
        if (this.dueDate != null) {
            ++numBlocks;
        }
        int numTextLines = 1;
        numTextLines += this.creditor.length;
        if (this.finalCreditor != null) {
            numTextLines += this.finalCreditor.length;
        }
        if (this.refNo != null) {
            ++numTextLines;
        }
        if (this.additionalInfo != null) {
            numTextLines += this.additionalInfo.length;
        }
        if (this.debtor != null) {
            numTextLines += this.debtor.length;
        }
        if (this.dueDate != null) {
            ++numTextLines;
        }
        double heightWithoutSpacing = (double)numBlocks * (FontMetrics.getLineHeight(this.fontSizeLabel) - FontMetrics.getLeading(this.fontSizeLabel)) + (double)numTextLines * (FontMetrics.getLineHeight(this.fontSizeText) - FontMetrics.getLeading(this.fontSizeText)) + (this.debtor == null ? 25.0 : 0.0);
        double uncompressedSpacing = (double)numBlocks * 0.7055555555555555 + (double)(numBlocks - 1) * 2.1166666666666663 + (double)numBlocks * FontMetrics.getLeading(this.fontSizeLabel) + (double)(numTextLines - 1) * FontMetrics.getLeading(this.fontSizeText);
        double regularHeight = heightWithoutSpacing + uncompressedSpacing;
        double factor = 1.0;
        if (regularHeight <= 89.0) {
            this.textTopPadding = 0.7055555555555555;
            this.labelTopPadding = 2.1166666666666663;
            this.labelLineHeight = FontMetrics.getLineHeight(this.fontSizeLabel);
            this.textLineHeight = FontMetrics.getLineHeight(this.fontSizeText);
            double titleHeight = FontMetrics.getLineHeight(11) + 2.1166666666666663;
            this.rightColumnExtraYOffset = regularHeight <= 89.0 - titleHeight ? titleHeight : 0.0;
        } else {
            double remainingSpacing = 89.0 - heightWithoutSpacing;
            factor = remainingSpacing / uncompressedSpacing;
            this.textTopPadding = 0.7055555555555555 * factor;
            this.labelTopPadding = 2.1166666666666663 * factor;
            this.labelLineHeight = FontMetrics.getLineHeight(this.fontSizeLabel) - (1.0 - factor) * FontMetrics.getLeading(this.fontSizeLabel);
            this.textLineHeight = FontMetrics.getLineHeight(this.fontSizeText) - (1.0 - factor) * FontMetrics.getLeading(this.fontSizeText);
        }
        return factor;
    }

    private void drawQRCodeOnly() throws IOException {
        this.qrCode.draw(this.graphics, 0.0, 0.0);
    }

    private void drawCorners(double x, double y, double width, double height) throws IOException {
        double lwh = 0.17638888888888887;
        double s = 3.0;
        this.graphics.startPath();
        this.graphics.moveTo(x + 0.17638888888888887, y + 3.0);
        this.graphics.lineTo(x + 0.17638888888888887, y + 0.17638888888888887);
        this.graphics.lineTo(x + 3.0, y + 0.17638888888888887);
        this.graphics.moveTo(x + width - 3.0, y + 0.17638888888888887);
        this.graphics.lineTo(x + width - 0.17638888888888887, y + 0.17638888888888887);
        this.graphics.lineTo(x + width - 0.17638888888888887, y + 3.0);
        this.graphics.moveTo(x + width - 0.17638888888888887, y + height - 3.0);
        this.graphics.lineTo(x + width - 0.17638888888888887, y + height - 0.17638888888888887);
        this.graphics.lineTo(x + width - 3.0, y + height - 0.17638888888888887);
        this.graphics.moveTo(x + 3.0, y + height - 0.17638888888888887);
        this.graphics.lineTo(x + 0.17638888888888887, y + height - 0.17638888888888887);
        this.graphics.lineTo(x + 0.17638888888888887, y + height - 3.0);
        this.graphics.strokePath(1.0, 0);
    }

    private static String formatAmountForDisplay(double amount) {
        return AMOUNT_DISPLAY_FORMAT.format(amount);
    }

    private static String formatDateForDisplay(LocalDate date) {
        return date.format(DATE_DISPLAY_FORMAT);
    }

    private static String formatIBANForDisplay(String iban) {
        StringBuilder sb = new StringBuilder(25);
        sb.append(iban, 0, 4);
        sb.append(" ");
        sb.append(iban, 4, 8);
        sb.append(" ");
        sb.append(iban, 8, 12);
        sb.append(" ");
        sb.append(iban, 12, 16);
        sb.append(" ");
        sb.append(iban, 16, 21);
        return sb.toString();
    }

    private static String formatPersonForDisplay(Address address) {
        String houseNo;
        StringBuilder sb = new StringBuilder();
        sb.append(address.getName());
        String street = address.getStreet();
        if (street != null) {
            sb.append("\n");
            sb.append(street);
        }
        if ((houseNo = address.getHouseNo()) != null) {
            sb.append(street != null ? " " : "\n");
            sb.append(houseNo);
        }
        sb.append("\n");
        sb.append(address.getCountryCode());
        sb.append("-");
        sb.append(address.getPostalCode());
        sb.append(" ");
        sb.append(address.getTown());
        return sb.toString();
    }

    private static String formatReferenceNumber(String refNo) {
        if (refNo == null) {
            return null;
        }
        int len = (refNo = refNo.trim()).length();
        if (len == 0) {
            return null;
        }
        if (refNo.startsWith("RF")) {
            return refNo;
        }
        StringBuilder sb = new StringBuilder();
        int t = 0;
        while (t < len) {
            int n = t + (len - t - 1) % 4 + 1;
            if (t != 0) {
                sb.append(" ");
            }
            sb.append(refNo.substring(t, n));
            t = n;
        }
        return sb.toString();
    }

    static {
        DATE_DISPLAY_FORMAT = DateTimeFormatter.ofPattern("dd.MM.yyyy");
        AMOUNT_DISPLAY_FORMAT = new DecimalFormat("###,##0.00");
        DecimalFormatSymbols symbols = new DecimalFormatSymbols(Locale.US);
        symbols.setDecimalSeparator('.');
        symbols.setGroupingSeparator('\'');
        AMOUNT_DISPLAY_FORMAT.setDecimalFormatSymbols(symbols);
    }

    public static enum BillFormat {
        A4PortraitSheet,
        A5LandscapeSheet,
        A6LandscapeSheet,
        QRCodeOnly;

    }

    public static enum GraphicsFormat {
        PDF,
        SVG;

    }
}

