/*
 * Decompiled with CFR 0.152.
 */
package net.codecrete.qrbill.generator;

import java.text.Normalizer;
import net.codecrete.qrbill.generator.Address;
import net.codecrete.qrbill.generator.Bill;
import net.codecrete.qrbill.generator.ValidationMessage;
import net.codecrete.qrbill.generator.ValidationResult;

public class Validator {
    private Bill billIn;
    private Bill billOut;
    private ValidationResult validationResult;
    private static final int[] MOD_10 = new int[]{0, 9, 4, 6, 8, 2, 7, 1, 3, 5};

    public Validator(Bill bill, ValidationResult result) {
        this.billIn = bill;
        this.billOut = new Bill();
        this.validationResult = result;
    }

    public Bill validate() {
        Double amount;
        this.billOut.setLanguage(this.billIn.getLanguage());
        this.billOut.setVersion(this.billIn.getVersion());
        String currency = Validator.trimmed(this.billIn.getCurrency());
        if (this.validateMandatory(currency, "currency")) {
            if (!"CHF".equals(currency = currency.toUpperCase()) && !"EUR".equals(currency)) {
                this.validationResult.addMessage(ValidationMessage.Type.Error, "currency", "currency_is_chf_or_eur");
            } else {
                this.billOut.setCurrency(currency);
            }
        }
        if ((amount = this.billIn.getAmount()) == null) {
            this.billOut.setAmount(null);
        } else if (this.billIn.getAmount() < 0.01 || this.billIn.getAmount() > 9.9999999999E8) {
            this.validationResult.addMessage(ValidationMessage.Type.Error, "amount", "amount_in_valid_range");
        } else {
            this.billOut.setAmount(this.billIn.getAmount());
        }
        boolean isQRBillIBAN = false;
        String account = Validator.trimmed(this.billIn.getAccount());
        if (this.validateMandatory(account, "account") && this.validateIBAN(account = Validator.whiteSpaceRemoved(account).toUpperCase(), "account")) {
            if (!account.startsWith("CH") && !account.startsWith("LI")) {
                this.validationResult.addMessage(ValidationMessage.Type.Error, "account", "account_is_ch_li_iban");
            } else if (account.length() != 21) {
                this.validationResult.addMessage(ValidationMessage.Type.Error, "account", "account_is_valid_iban");
            } else {
                this.billOut.setAccount(account);
                isQRBillIBAN = account.charAt(4) == '3' && (account.charAt(5) == '0' || account.charAt(5) == '1');
            }
        }
        Address creditor = this.validatePerson(this.billIn.getCreditor(), "creditor", true);
        this.billOut.setCreditor(creditor);
        Address finalCreditor = this.validatePerson(this.billIn.getFinalCreditor(), "finalCreditor", false);
        this.billOut.setFinalCreditor(finalCreditor);
        String referenceNo = Validator.trimmed(this.billIn.getReferenceNo());
        if (referenceNo != null) {
            if ((referenceNo = Validator.whiteSpaceRemoved(referenceNo)).startsWith("RF")) {
                if (!Validator.isValidISO11649ReferenceNo(referenceNo)) {
                    this.validationResult.addMessage(ValidationMessage.Type.Error, "referenceNo", "valid_iso11649_creditor_ref");
                } else {
                    this.billOut.setReferenceNo(referenceNo);
                }
            } else {
                if (referenceNo.length() < 27) {
                    referenceNo = "00000000000000000000000000".substring(0, 27 - referenceNo.length()) + referenceNo;
                }
                if (!Validator.isValidQRReferenceNo(referenceNo)) {
                    this.validationResult.addMessage(ValidationMessage.Type.Error, "referenceNo", "valid_qr_ref_no");
                } else {
                    this.billOut.setReferenceNo(referenceNo);
                }
            }
        } else if (isQRBillIBAN) {
            this.validationResult.addMessage(ValidationMessage.Type.Error, "referenceNo", "mandatory_for_qr_iban");
        }
        String additionalInfo = Validator.trimmed(this.billIn.getAdditionalInfo());
        additionalInfo = this.clipValue(additionalInfo, 140, "additionalInfo");
        this.billOut.setAdditionalInfo(additionalInfo);
        Address debtor = this.validatePerson(this.billIn.getDebtor(), "debtor", false);
        this.billOut.setDebtor(debtor);
        this.billOut.setDueDate(this.billIn.getDueDate());
        return this.billOut;
    }

    private Address validatePerson(Address addressIn, String fieldRoot, boolean mandatory) {
        Address addressOut = this.cleanedPerson(addressIn, fieldRoot);
        if (addressOut == null) {
            if (mandatory) {
                this.validationResult.addMessage(ValidationMessage.Type.Error, fieldRoot + ".name", "field_is_mandatory");
                this.validationResult.addMessage(ValidationMessage.Type.Error, fieldRoot + ".postalCode", "field_is_mandatory");
                this.validationResult.addMessage(ValidationMessage.Type.Error, fieldRoot + ".town", "field_is_mandatory");
                this.validationResult.addMessage(ValidationMessage.Type.Error, fieldRoot + ".countryCode", "field_is_mandatory");
            }
            return null;
        }
        this.validateMandatory(addressOut.getName(), fieldRoot, ".name");
        this.validateMandatory(addressOut.getPostalCode(), fieldRoot, ".postalCode");
        this.validateMandatory(addressOut.getTown(), fieldRoot, ".town");
        this.validateMandatory(addressOut.getCountryCode(), fieldRoot, ".countryCode");
        addressOut.setName(this.clipValue(addressOut.getName(), 70, fieldRoot, ".name"));
        addressOut.setStreet(this.clipValue(addressOut.getStreet(), 70, fieldRoot, ".street"));
        addressOut.setHouseNo(this.clipValue(addressOut.getHouseNo(), 16, fieldRoot, ".houseNo"));
        addressOut.setPostalCode(this.clipValue(addressOut.getPostalCode(), 16, fieldRoot, ".postalCode"));
        addressOut.setTown(this.clipValue(addressOut.getTown(), 35, fieldRoot, ".town"));
        if (!(addressOut.getCountryCode() == null || addressOut.getCountryCode().length() == 2 && Validator.isAlphaNumeric(addressOut.getCountryCode()))) {
            this.validationResult.addMessage(ValidationMessage.Type.Error, fieldRoot + ".countryCode", "valid_country_code");
        }
        return addressOut;
    }

    private boolean validateIBAN(String iban, String field) {
        if (!Validator.isValidIBAN(iban)) {
            this.validationResult.addMessage(ValidationMessage.Type.Error, field, "account_is_valid_iban");
            return false;
        }
        return true;
    }

    private Address cleanedPerson(Address addressIn, String fieldRoot) {
        if (addressIn == null) {
            return null;
        }
        Address addressOut = new Address();
        addressOut.setName(Validator.trimmed(this.cleanedValue(addressIn.getName(), fieldRoot, ".name")));
        addressOut.setStreet(Validator.trimmed(this.cleanedValue(addressIn.getStreet(), fieldRoot, ".street")));
        addressOut.setHouseNo(Validator.trimmed(this.cleanedValue(addressIn.getHouseNo(), fieldRoot, ".houseNo")));
        addressOut.setPostalCode(Validator.trimmed(this.cleanedValue(addressIn.getPostalCode(), fieldRoot, ".postalCode")));
        addressOut.setTown(Validator.trimmed(this.cleanedValue(addressIn.getTown(), fieldRoot, ".town")));
        addressOut.setCountryCode(Validator.trimmed(addressIn.getCountryCode()));
        if (addressOut.getName() == null && addressOut.getStreet() == null && addressOut.getHouseNo() == null && addressOut.getPostalCode() == null && addressOut.getTown() == null && addressOut.getCountryCode() == null) {
            return null;
        }
        return addressOut;
    }

    private boolean validateMandatory(String value, String field) {
        if (Validator.isNullOrEmpty(value)) {
            this.validationResult.addMessage(ValidationMessage.Type.Error, field, "field_is_mandatory");
            return false;
        }
        return true;
    }

    private boolean validateMandatory(String value, String fieldRoot, String subfield) {
        if (Validator.isNullOrEmpty(value)) {
            this.validationResult.addMessage(ValidationMessage.Type.Error, fieldRoot + subfield, "field_is_mandatory");
            return false;
        }
        return true;
    }

    private String clipValue(String value, int maxLength, String field) {
        if (value != null && value.length() > maxLength) {
            this.validationResult.addMessage(ValidationMessage.Type.Warning, field, "field_clipped", new String[]{Integer.toString(maxLength)});
            return value.substring(0, maxLength);
        }
        return value;
    }

    private String clipValue(String value, int maxLength, String fieldRoot, String subfield) {
        if (value != null && value.length() > maxLength) {
            this.validationResult.addMessage(ValidationMessage.Type.Warning, fieldRoot + subfield, "field_clipped", new String[]{Integer.toString(maxLength)});
            return value.substring(0, maxLength);
        }
        return value;
    }

    private String cleanedValue(String value, boolean isNormalized, String fieldRoot, String subfield) {
        String result;
        if (value == null) {
            return null;
        }
        int len = value.length();
        boolean justAddedSpace = false;
        StringBuilder sb = null;
        int lastCopiedPos = 0;
        for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            if (ch > '\u00ff' && !isNormalized) {
                if (Normalizer.isNormalized(value, Normalizer.Form.NFC)) {
                    isNormalized = true;
                } else {
                    value = Normalizer.normalize(value, Normalizer.Form.NFC);
                    return this.cleanedValue(value, true, fieldRoot, subfield);
                }
            }
            if (!Validator.isValidQRBillCharacter(ch)) {
                char replacement;
                if (sb == null) {
                    sb = new StringBuilder(value.length());
                }
                if (i > lastCopiedPos) {
                    sb.append(value, lastCopiedPos, i);
                }
                if (Character.isHighSurrogate(ch)) {
                    int codePoint = value.codePointAt(i);
                    if (Character.getType(codePoint) != 8) {
                        sb.append('.');
                    }
                    justAddedSpace = false;
                    lastCopiedPos = ++i + 1;
                    continue;
                }
                char c = replacement = Character.isWhitespace(ch) ? (char)' ' : '.';
                if (replacement != ' ' || !justAddedSpace) {
                    sb.append(replacement);
                    justAddedSpace = replacement == ' ';
                }
                lastCopiedPos = i + 1;
                continue;
            }
            justAddedSpace = ch == ' ';
        }
        if (sb == null) {
            return value;
        }
        if (lastCopiedPos < len) {
            sb.append(value, lastCopiedPos, len);
        }
        if ((result = sb.toString().trim()).length() == 0) {
            return null;
        }
        this.validationResult.addMessage(ValidationMessage.Type.Warning, fieldRoot + subfield, "replaced_unsupported_characters");
        return result;
    }

    private String cleanedValue(String value, String fieldRoot, String subfield) {
        return this.cleanedValue(value, false, fieldRoot, subfield);
    }

    private static boolean isValidIBAN(String iban) {
        if (iban.length() < 5) {
            return false;
        }
        if (!Validator.isAlphaNumeric(iban)) {
            return false;
        }
        if (!(Character.isLetter(iban.charAt(0)) && Character.isLetter(iban.charAt(1)) && Character.isDigit(iban.charAt(2)) && Character.isDigit(iban.charAt(3)))) {
            return false;
        }
        return Validator.hasValidMod97CheckDigits(iban);
    }

    private static boolean isValidQRReferenceNo(String referenceNo) {
        if (!Validator.isNumeric(referenceNo)) {
            return false;
        }
        int carry = 0;
        int len = referenceNo.length();
        if (len != 27) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            int digit = referenceNo.charAt(i) - 48;
            carry = MOD_10[(carry + digit) % 10];
        }
        return carry == 0;
    }

    private static boolean isValidISO11649ReferenceNo(String referenceNo) {
        if (referenceNo.length() < 5 || referenceNo.length() > 25) {
            return false;
        }
        if (!Validator.isAlphaNumeric(referenceNo)) {
            return false;
        }
        if (!Character.isDigit(referenceNo.charAt(2)) || !Character.isDigit(referenceNo.charAt(3))) {
            return false;
        }
        return Validator.hasValidMod97CheckDigits(referenceNo);
    }

    private static boolean hasValidMod97CheckDigits(String number) {
        String rearranged = number.substring(4) + number.substring(0, 4);
        int len = rearranged.length();
        int sum = 0;
        for (int i = 0; i < len; ++i) {
            char ch = rearranged.charAt(i);
            if (ch >= '0' && ch <= '9') {
                sum = sum * 10 + (ch - 48);
            } else if (ch >= 'A' && ch <= 'Z') {
                sum = sum * 100 + (ch - 65 + 10);
            } else if (ch >= 'a' && ch <= 'z') {
                sum = sum * 100 + (ch - 97 + 10);
            } else {
                return false;
            }
            if (sum <= 9999999) continue;
            sum %= 97;
        }
        return (sum %= 97) == 1;
    }

    private static String trimmed(String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).length() == 0) {
            return null;
        }
        return value;
    }

    private static String whiteSpaceRemoved(String value) {
        StringBuilder sb = null;
        int len = value.length();
        int lastCopied = 0;
        for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            if (ch != ' ') continue;
            if (i > lastCopied) {
                if (sb == null) {
                    sb = new StringBuilder();
                }
                sb.append(value, lastCopied, i);
            }
            lastCopied = i + 1;
        }
        if (sb == null) {
            return value;
        }
        if (len > lastCopied) {
            sb.append(value, lastCopied, len);
        }
        return sb.toString();
    }

    private static boolean isNumeric(String value) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            if (ch >= '0' && ch <= '9') continue;
            return false;
        }
        return true;
    }

    private static boolean isAlphaNumeric(String value) {
        int len = value.length();
        for (int i = 0; i < len; ++i) {
            char ch = value.charAt(i);
            if (ch >= '0' && ch <= '9' || ch >= 'A' && ch <= 'Z' || ch >= 'a' && ch <= 'z') continue;
            return false;
        }
        return true;
    }

    private static boolean isNullOrEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    private static boolean isValidQRBillCharacter(char ch) {
        if (ch < ' ') {
            return false;
        }
        if (ch == '^') {
            return false;
        }
        if (ch <= '~') {
            return true;
        }
        if (ch == '\u00a3' || ch == '\u00b4') {
            return true;
        }
        if (ch < '\u00c0' || ch > '\u00fd') {
            return false;
        }
        if (ch == '\u00c3' || ch == '\u00c5' || ch == '\u00c6') {
            return false;
        }
        if (ch == '\u00d0' || ch == '\u00d5' || ch == '\u00d7' || ch == '\u00d8') {
            return false;
        }
        if (ch == '\u00dd' || ch == '\u00de') {
            return false;
        }
        if (ch == '\u00e3' || ch == '\u00e5' || ch == '\u00e6') {
            return false;
        }
        return ch != '\u00f0' && ch != '\u00f5' && ch != '\u00f8';
    }
}

