/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.rest;

import com.squareup.okhttp.Authenticator;
import com.squareup.okhttp.Credentials;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import java.io.IOException;
import java.net.Proxy;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.UnaryOperator;
import net.codestory.rest.Response;
import net.codestory.rest.RestResponse;
import net.codestory.rest.RestResponseShould;
import net.codestory.rest.Should;

public class RestAssert {
    private final String url;
    private final UnaryOperator<OkHttpClient> configureClient;
    private final UnaryOperator<Request.Builder> configureRequest;

    RestAssert(String url) {
        this(url, UnaryOperator.identity(), UnaryOperator.identity());
    }

    private RestAssert(String url, UnaryOperator<OkHttpClient> configureClient, UnaryOperator<Request.Builder> configureRequest) {
        this.url = url;
        this.configureRequest = configureRequest;
        this.configureClient = configureClient;
    }

    RestAssert withRequest(UnaryOperator<Request.Builder> configure) {
        return new RestAssert(this.url, this.configureClient, request -> (Request.Builder)configure.apply((Request.Builder)this.configureRequest.apply((Request.Builder)request)));
    }

    private RestAssert withClient(UnaryOperator<OkHttpClient> configure) {
        return new RestAssert(this.url, client -> (OkHttpClient)configure.apply((OkHttpClient)this.configureClient.apply((OkHttpClient)client)), this.configureRequest);
    }

    public Response response() {
        try {
            RestResponse call = this.call();
            return new Response(call.contentType(), call.bodyAsString(), call.code());
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to query: " + this.url, e);
        }
    }

    public RestAssert withHeader(String name, String value) {
        return this.withRequest(RestAssert.addHeader(name, value));
    }

    public RestAssert withPreemptiveAuthentication(String login, String password) {
        return this.withRequest(RestAssert.addBasicAuthHeader(login, password));
    }

    public RestAssert withAuthentication(final String login, final String password) {
        return this.withClient(RestAssert.setAuthenticator(new Authenticator(){
            AtomicInteger tries = new AtomicInteger(0);

            public Request authenticate(Proxy proxy, com.squareup.okhttp.Response response) {
                if (this.tries.getAndIncrement() > 0) {
                    return null;
                }
                return ((Request.Builder)RestAssert.addBasicAuthHeader(login, password).apply(response.request().newBuilder())).build();
            }

            public Request authenticateProxy(Proxy proxy, com.squareup.okhttp.Response response) {
                return null;
            }
        }));
    }

    public Should should() {
        try {
            return new RestResponseShould(this.call(), false);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to query: " + this.url, e);
        }
    }

    private static UnaryOperator<OkHttpClient> setAuthenticator(Authenticator authenticator) {
        return client -> client.setAuthenticator(authenticator);
    }

    private RestResponse call() throws IOException {
        return RestResponse.call(this.url, this.configureClient, this.configureRequest);
    }

    private static UnaryOperator<Request.Builder> addBasicAuthHeader(String login, String password) {
        return RestAssert.addHeader("Authorization", Credentials.basic((String)login, (String)password));
    }

    private static UnaryOperator<Request.Builder> addHeader(String name, String value) {
        return request -> request.addHeader(name, value);
    }
}

