/*
 * Decompiled with CFR 0.152.
 */
package net.codestory.http.appengine;

import com.google.apphosting.api.ApiProxy;
import com.google.apphosting.runtime.timer.Timer;
import com.google.apphosting.vmruntime.VmApiProxyDelegate;
import com.google.apphosting.vmruntime.VmApiProxyEnvironment;
import com.google.apphosting.vmruntime.VmMetadataCache;
import com.google.apphosting.vmruntime.VmRuntimeUtils;
import com.google.apphosting.vmruntime.VmTimer;
import java.io.IOException;
import net.codestory.http.Context;
import net.codestory.http.appengine.LazyApiProxyEnvironment;
import net.codestory.http.filters.Filter;
import net.codestory.http.filters.PayloadSupplier;
import net.codestory.http.payload.Payload;

public class AppEngineFilter
implements Filter {
    private final VmMetadataCache metadataCache = new VmMetadataCache();
    private final Timer wallclockTimer = new VmTimer();

    public AppEngineFilter() {
        ApiProxy.setDelegate((ApiProxy.Delegate)new VmApiProxyDelegate());
    }

    public boolean matches(String uri, Context context) {
        return !uri.startsWith("/webjars/");
    }

    public Payload apply(String uri, Context context, PayloadSupplier nextFilter) throws IOException {
        if (uri.equals("/_ah/start") || uri.equals("/_ah/stop") || uri.equals("/_ah/health")) {
            return new Payload((Object)"ok");
        }
        ApiProxy.setEnvironmentForCurrentThread((ApiProxy.Environment)new LazyApiProxyEnvironment(() -> VmApiProxyEnvironment.createFromHeaders(System.getenv(), this.metadataCache, name -> context.request().header(name), VmRuntimeUtils.getApiServerAddress(), this.wallclockTimer, 86400000L)));
        return nextFilter.get();
    }
}

