/*
 * Decompiled with CFR 0.152.
 */
package com.google.apphosting.vmruntime;

import com.google.appengine.repackaged.com.google.common.base.Preconditions;
import com.google.appengine.repackaged.com.google.common.collect.ImmutableList;
import com.google.appengine.repackaged.com.google.common.collect.Lists;
import com.google.apphosting.api.ApiProxy;
import java.util.List;
import java.util.concurrent.ThreadFactory;

public class VmRequestThreadFactory
implements ThreadFactory {
    private final ApiProxy.Environment requestEnvironment;
    private final Object mutex = new Object();
    private final List<Thread> createdThreads;
    private volatile boolean allowNewRequestThreadCreation;

    public VmRequestThreadFactory(ApiProxy.Environment requestEnvironment) {
        this.requestEnvironment = requestEnvironment;
        this.createdThreads = Lists.newLinkedList();
        this.allowNewRequestThreadCreation = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Thread newThread(final Runnable runnable) {
        Preconditions.checkState((this.requestEnvironment != null ? 1 : 0) != 0, (Object)"Request threads can only be created within the context of a running request.");
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                if (runnable == null) {
                    return;
                }
                Preconditions.checkState((boolean)VmRequestThreadFactory.this.allowNewRequestThreadCreation, (Object)"Cannot start new threads after the request thread stops.");
                ApiProxy.setEnvironmentForCurrentThread((ApiProxy.Environment)VmRequestThreadFactory.this.requestEnvironment);
                runnable.run();
            }
        });
        Preconditions.checkState((boolean)this.allowNewRequestThreadCreation, (Object)"Cannot create new threads after the request thread stops.");
        Object object = this.mutex;
        synchronized (object) {
            this.createdThreads.add(thread);
        }
        return thread;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Thread> getRequestThreads() {
        Object object = this.mutex;
        synchronized (object) {
            return ImmutableList.copyOf(this.createdThreads);
        }
    }
}

