/*
 * Decompiled with CFR 0.152.
 */
package net.cnri.recommend.web;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.cnri.cordra.api.BadRequestCordraException;
import net.cnri.recommend.RecommenderService;
import net.cnri.recommend.ServiceFactory;
import net.cnri.recommend.web.BasicAuthHeader;
import net.cnri.recommend.web.ServletErrorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/rateItem/*"})
public class RateItemServlet
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(RateItemServlet.class);

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            String authHeaderString = req.getHeader("Authorization");
            if (authHeaderString == null) {
                throw new BadRequestCordraException("Auth header is missing");
            }
            BasicAuthHeader authHeader = new BasicAuthHeader(authHeaderString);
            RecommenderService service = ServiceFactory.getInstance();
            String userId = service.getUserIdForUsername(authHeader.getUsername());
            String itemId = req.getParameter("itemId");
            if (itemId == null) {
                throw new BadRequestCordraException("Request must include itemId param");
            }
            String ratingString = req.getParameter("rating");
            Integer rating = null;
            if (ratingString != null) {
                try {
                    rating = Integer.parseInt(ratingString);
                }
                catch (NumberFormatException e) {
                    throw new BadRequestCordraException(ratingString + ", is not a valid rating");
                }
            }
            service.rateItem(userId, itemId, rating, authHeader.getUsername(), authHeader.getPassword());
            ServletErrorUtil.okWithMessage((HttpServletResponse)resp, (String)"success");
        }
        catch (BadRequestCordraException e) {
            ServletErrorUtil.badRequest((HttpServletResponse)resp, (String)e.getMessage());
        }
        catch (Exception e) {
            logger.error("Unexpected error", (Throwable)e);
            ServletErrorUtil.internalServerError((HttpServletResponse)resp);
        }
    }

    protected void doDelete(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            String authHeaderString = req.getHeader("Authorization");
            if (authHeaderString == null) {
                throw new Exception("Auth header is missing");
            }
            BasicAuthHeader authHeader = new BasicAuthHeader(authHeaderString);
            RecommenderService service = ServiceFactory.getInstance();
            String userId = service.getUserIdForUsername(authHeader.getUsername());
            String itemId = req.getParameter("itemId");
            service.deleteRating(userId, itemId, authHeader.getUsername(), authHeader.getPassword());
            ServletErrorUtil.okWithMessage((HttpServletResponse)resp, (String)"success");
        }
        catch (Exception e) {
            logger.error("Unexpected error", (Throwable)e);
            ServletErrorUtil.badRequest((HttpServletResponse)resp, (String)e.getMessage());
        }
    }
}

