/*
 * Decompiled with CFR 0.152.
 */
package net.cnri.recommend.web;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.annotation.WebServlet;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.cnri.cordra.api.BadRequestCordraException;
import net.cnri.recommend.RecommenderService;
import net.cnri.recommend.ServiceFactory;
import net.cnri.recommend.web.BasicAuthHeader;
import net.cnri.recommend.web.ServletErrorUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@WebServlet(value={"/moreLikeThis/*"})
public class MoreLikeThisServlet
extends HttpServlet {
    private static Logger logger = LoggerFactory.getLogger(MoreLikeThisServlet.class);
    private static final int NUM_RECS = 10;

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            String[] idsArray;
            String authHeaderString = req.getHeader("Authorization");
            if (authHeaderString == null) {
                throw new Exception("Auth header is missing");
            }
            BasicAuthHeader authHeader = new BasicAuthHeader(authHeaderString);
            RecommenderService service = ServiceFactory.getInstance();
            String userId = service.getUserIdForUsername(authHeader.getUsername());
            String numString = req.getParameter("num");
            int num = 10;
            if (numString != null) {
                num = Integer.parseInt(numString);
            }
            if ((idsArray = req.getParameterValues("id")) == null || idsArray.length == 0) {
                throw new BadRequestCordraException("Request must include one or more id params.");
            }
            List<String> ids = Arrays.asList(idsArray);
            List results = service.getMoreLikeThis(userId, ids, authHeader.getUsername(), authHeader.getPassword(), num);
            Gson gson = new Gson();
            String result = gson.toJson((Object)results);
            PrintWriter w = resp.getWriter();
            w.write(result);
            w.close();
        }
        catch (BadRequestCordraException e) {
            ServletErrorUtil.badRequest((HttpServletResponse)resp, (String)e.getMessage());
        }
        catch (Exception e) {
            logger.error("Unexpected error", (Throwable)e);
            ServletErrorUtil.internalServerError((HttpServletResponse)resp);
        }
    }
}

