/*
 * Decompiled with CFR 0.152.
 */
package net.cnri.recommend.web;

import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class BasicAuthHeader {
    private String username = null;
    private String password = null;

    public BasicAuthHeader(String authHeader) {
        if (authHeader != null) {
            try {
                String encodedUsernameAndPassWord = this.getEncodedUserNameAndPassword(authHeader);
                String decodedAuthHeader = new String(Base64.getDecoder().decode(encodedUsernameAndPassWord.getBytes()));
                this.username = decodedAuthHeader.substring(0, decodedAuthHeader.indexOf(":"));
                this.password = decodedAuthHeader.substring(decodedAuthHeader.indexOf(":") + 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public BasicAuthHeader(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public String getAuthHeader() {
        byte[] usernamePasswordBytes = (this.username + ":" + this.password).getBytes(StandardCharsets.UTF_8);
        String usernamePasswordBase64 = Base64.getEncoder().encodeToString(usernamePasswordBytes);
        return "Basic " + usernamePasswordBase64;
    }

    private String getEncodedUserNameAndPassword(String authHeader) {
        return authHeader.substring(authHeader.indexOf(" ") + 1).trim();
    }

    public String getPassword() {
        return this.password;
    }

    public String getUsername() {
        return this.username;
    }
}

