/*
 * Decompiled with CFR 0.152.
 */
package net.cnri.recommend;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import net.cnri.recommend.MoreLikeThis;
import net.cnri.recommend.VectorUtil;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrQuery;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;

/*
 * Exception performing whole class analysis ignored.
 */
public class MoreLikeThis {
    public static Map<String, Double> getTermVector(String objectId, SolrClient solr, List<String> includeList) throws Exception {
        return (Map)MoreLikeThis.getTermVectors(Collections.singletonList(objectId), (SolrClient)solr, includeList).get(objectId);
    }

    public static Map<String, Map<String, Double>> getTermVectors(List<String> ids, SolrClient solr, List<String> includeList) throws Exception {
        long totalDocs = MoreLikeThis.getTotalDocs((SolrClient)solr);
        HashMap<String, Map<String, Double>> res = new HashMap<String, Map<String, Double>>();
        String queryString = MoreLikeThis.queryStringForIds(ids);
        SolrQuery query = new SolrQuery(MoreLikeThis.fixSlashes((String)queryString));
        query.setRows(Integer.valueOf(Integer.MAX_VALUE));
        query.setRequestHandler("/tvrh");
        query.setParam("tv.tf", true);
        query.setParam("tv.df", true);
        QueryResponse queryResponse = solr.query((SolrParams)query);
        if (queryResponse.getStatus() != 0) {
            throw new Exception("Unexpected Solr response " + queryResponse);
        }
        NamedList termVectorsList = (NamedList)queryResponse.getResponse().get("termVectors");
        for (String id : ids) {
            NamedList termVectorNamedList = (NamedList)termVectorsList.get(id);
            Map termVector = MoreLikeThis.termVectorFromSolrNamedList((NamedList)termVectorNamedList, (long)totalDocs, includeList);
            res.put(id, termVector);
        }
        return res;
    }

    private static String queryStringForIds(List<String> ids) {
        return "id:" + String.join((CharSequence)" id:", ids);
    }

    private static Map<String, Double> termVectorFromSolrNamedList(NamedList termVector, long totalDocs, List<String> includeList) {
        HashMap<String, Double> result = new HashMap<String, Double>();
        for (Map.Entry fieldEntry : termVector) {
            String key = (String)fieldEntry.getKey();
            if ("uniqueKey".equals(key) || includeList != null && !includeList.contains(key) && !MoreLikeThis.containsPrefixFor(includeList, (String)key)) continue;
            for (Map.Entry tvInfo : (NamedList)fieldEntry.getValue()) {
                NamedList tv = (NamedList)tvInfo.getValue();
                String tvKey = (String)tvInfo.getKey();
                tvKey = MoreLikeThis.quote((String)tvKey);
                int tf = (Integer)tv.get("tf");
                int df = (Integer)tv.get("df");
                double idf = MoreLikeThis.idf((long)df, (long)totalDocs);
                double tfidf = (double)tf * idf;
                result.put(key + ":" + tvKey, tfidf);
            }
        }
        return result;
    }

    private static boolean containsPrefixFor(List<String> includeList, String term) {
        for (String s : includeList) {
            String prefix;
            if (!s.endsWith("*") || !term.startsWith(prefix = s.substring(0, s.length() - 1))) continue;
            return true;
        }
        return false;
    }

    private static String quote(String tvKey) {
        return tvKey.replace(":", "\\:");
    }

    public static long getTotalDocs(SolrClient solr) throws SolrServerException, IOException {
        SolrQuery q = new SolrQuery("*:*");
        q.setRows(Integer.valueOf(0));
        return solr.query((SolrParams)q).getResults().getNumFound();
    }

    public static double idf(long docFreq, long totalDocs) {
        return Math.log((double)totalDocs / (double)(docFreq + 1L)) + 1.0;
    }

    public static String getMoreLikeThis(List<String> ids, SolrClient solr) throws Exception {
        Map termVectorsMap = MoreLikeThis.getTermVectors(ids, (SolrClient)solr, null);
        String query = MoreLikeThis.buildMoreLikeThisQueryFor(termVectorsMap.values(), (boolean)true);
        return query;
    }

    public static String buildMoreLikeThisQueryFor(Map<String, Double> termVector, boolean includeBoost) {
        Map.Entry term;
        PriorityQueue priorityTerms = MoreLikeThis.toSortedPriortiyQueue(termVector);
        ArrayList<Map.Entry> priorityTermsList = new ArrayList<Map.Entry>();
        int maxItems = 25;
        for (int i = 0; i < maxItems && (term = (Map.Entry)priorityTerms.poll()) != null; ++i) {
            priorityTermsList.add(term);
        }
        StringBuilder sb = new StringBuilder();
        Map.Entry lastTerm = (Map.Entry)priorityTermsList.get(priorityTermsList.size() - 1);
        double lowestScore = (Double)lastTerm.getValue();
        for (Map.Entry term2 : priorityTermsList) {
            double score = (Double)term2.getValue();
            double nScore = score / lowestScore;
            sb.append((String)term2.getKey());
            if (includeBoost) {
                sb.append("^" + nScore);
            }
            sb.append(" ");
        }
        return sb.toString();
    }

    public static String buildMoreLikeThisQueryForWithBoosts(Map<String, Map<String, Double>> termVectors, Map<String, Double> boosts) {
        Map normalizedVectors = VectorUtil.normalizeTermVectors(termVectors);
        MoreLikeThis.boostTermVectors(boosts, (Map)normalizedVectors);
        ArrayList normalizedVectorsAsList = new ArrayList();
        normalizedVectorsAsList.addAll(normalizedVectors.values());
        Map tasteVector = VectorUtil.sumTermVectors(normalizedVectorsAsList);
        String query = MoreLikeThis.buildMoreLikeThisQueryFor((Map)tasteVector, (boolean)true);
        return query;
    }

    public static void boostTermVectors(Map<String, Double> itemRatingMap, Map<String, Map<String, Double>> termVectorsMap) {
        for (String itemId : itemRatingMap.keySet()) {
            Double rating;
            Double boost = rating = itemRatingMap.get(itemId);
            Map<String, Double> termVector = termVectorsMap.get(itemId);
            for (String term : termVector.keySet()) {
                Double magnitude = termVector.get(term);
                Double boostedMagnitude = magnitude * boost;
                termVector.put(term, boostedMagnitude);
            }
        }
    }

    public static String buildMoreLikeThisQueryFor(Collection<Map<String, Double>> termVectors, boolean includeBoost) {
        Map tasteVector = VectorUtil.normalizeAndSumTermVectors(termVectors);
        String query = MoreLikeThis.buildMoreLikeThisQueryFor((Map)tasteVector, (boolean)includeBoost);
        return query;
    }

    public static String generateExcludeIdsQueryFragment(List<String> ids) {
        return " -id:" + String.join((CharSequence)" -id:", ids);
    }

    private static PriorityQueue<Map.Entry<String, Double>> toSortedPriortiyQueue(Map<String, Double> termVector) {
        PriorityQueue<Map.Entry<String, Double>> priorityTerms = new PriorityQueue<Map.Entry<String, Double>>(11, (Comparator<Map.Entry<String, Double>>)new TermComparator());
        for (Map.Entry<String, Double> term : termVector.entrySet()) {
            priorityTerms.add(term);
        }
        return priorityTerms;
    }

    public static String fixSlashes(String s) {
        if (s == null) {
            return null;
        }
        return s.replaceAll("(?<!\\\\)/", "\\\\/");
    }
}

